/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.LongString;
import com.rabbitmq.client.Method;
import com.rabbitmq.client.impl.AMQBasicProperties;
import com.rabbitmq.client.impl.AMQImpl;
import com.rabbitmq.client.impl.ContentHeaderPropertyReader;
import com.rabbitmq.client.impl.ContentHeaderPropertyWriter;
import com.rabbitmq.client.impl.LongStringHelper;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public interface AMQP {
    public static final int ACCESS_REFUSED = 403;
    public static final int CHANNEL_ERROR = 504;
    public static final int COMMAND_INVALID = 503;
    public static final int CONNECTION_FORCED = 320;
    public static final int CONTENT_TOO_LARGE = 311;
    public static final int FRAME_BODY = 3;
    public static final int FRAME_END = 206;
    public static final int FRAME_ERROR = 501;
    public static final int FRAME_HEADER = 2;
    public static final int FRAME_HEARTBEAT = 8;
    public static final int FRAME_METHOD = 1;
    public static final int FRAME_MIN_SIZE = 4096;
    public static final int INTERNAL_ERROR = 541;
    public static final int INVALID_PATH = 402;
    public static final int NOT_ALLOWED = 530;
    public static final int NOT_FOUND = 404;
    public static final int NOT_IMPLEMENTED = 540;
    public static final int NO_CONSUMERS = 313;
    public static final int NO_ROUTE = 312;
    public static final int PRECONDITION_FAILED = 406;
    public static final int REPLY_SUCCESS = 200;
    public static final int RESOURCE_ERROR = 506;
    public static final int RESOURCE_LOCKED = 405;
    public static final int SYNTAX_ERROR = 502;
    public static final int UNEXPECTED_FRAME = 505;

    public static class Access {

        public static interface Request
        extends Method {
            public boolean getActive();

            public boolean getExclusive();

            public boolean getPassive();

            public boolean getRead();

            public String getRealm();

            public boolean getWrite();

            public static final class Builder {
                private boolean active = true;
                private boolean exclusive = false;
                private boolean passive = true;
                private boolean read = true;
                private String realm = "/data";
                private boolean write = true;

                public Builder active() {
                    return this.active(true);
                }

                public Builder active(boolean bl2) {
                    this.active = bl2;
                    return this;
                }

                public Request build() {
                    return new AMQImpl.Access.Request(this.realm, this.exclusive, this.passive, this.active, this.write, this.read);
                }

                public Builder exclusive() {
                    return this.exclusive(true);
                }

                public Builder exclusive(boolean bl2) {
                    this.exclusive = bl2;
                    return this;
                }

                public Builder passive() {
                    return this.passive(true);
                }

                public Builder passive(boolean bl2) {
                    this.passive = bl2;
                    return this;
                }

                public Builder read() {
                    return this.read(true);
                }

                public Builder read(boolean bl2) {
                    this.read = bl2;
                    return this;
                }

                public Builder realm(String string2) {
                    this.realm = string2;
                    return this;
                }

                public Builder write() {
                    return this.write(true);
                }

                public Builder write(boolean bl2) {
                    this.write = bl2;
                    return this;
                }
            }
        }

        public static interface RequestOk
        extends Method {
            public int getTicket();

            public static final class Builder {
                private int ticket = 1;

                public RequestOk build() {
                    return new AMQImpl.Access.RequestOk(this.ticket);
                }

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }
            }
        }
    }

    public static class Basic {

        public static interface Ack
        extends Method {
            public long getDeliveryTag();

            public boolean getMultiple();

            public static final class Builder {
                private long deliveryTag = 0L;
                private boolean multiple = false;

                public Ack build() {
                    return new AMQImpl.Basic.Ack(this.deliveryTag, this.multiple);
                }

                public Builder deliveryTag(long l2) {
                    this.deliveryTag = l2;
                    return this;
                }

                public Builder multiple() {
                    return this.multiple(true);
                }

                public Builder multiple(boolean bl2) {
                    this.multiple = bl2;
                    return this;
                }
            }
        }

        public static interface Cancel
        extends Method {
            public String getConsumerTag();

            public boolean getNowait();

            public static final class Builder {
                private String consumerTag;
                private boolean nowait = false;

                public Cancel build() {
                    return new AMQImpl.Basic.Cancel(this.consumerTag, this.nowait);
                }

                public Builder consumerTag(String string2) {
                    this.consumerTag = string2;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder nowait(boolean bl2) {
                    this.nowait = bl2;
                    return this;
                }
            }
        }

        public static interface CancelOk
        extends Method {
            public String getConsumerTag();

            public static final class Builder {
                private String consumerTag;

                public CancelOk build() {
                    return new AMQImpl.Basic.CancelOk(this.consumerTag);
                }

                public Builder consumerTag(String string2) {
                    this.consumerTag = string2;
                    return this;
                }
            }
        }

        public static interface Consume
        extends Method {
            public Map<String, Object> getArguments();

            public String getConsumerTag();

            public boolean getExclusive();

            public boolean getNoAck();

            public boolean getNoLocal();

            public boolean getNowait();

            public String getQueue();

            public int getTicket();

            public static final class Builder {
                private Map<String, Object> arguments = null;
                private String consumerTag = "";
                private boolean exclusive = false;
                private boolean noAck = false;
                private boolean noLocal = false;
                private boolean nowait = false;
                private String queue = "";
                private int ticket = 0;

                public Builder arguments(Map<String, Object> map) {
                    this.arguments = map;
                    return this;
                }

                public Consume build() {
                    return new AMQImpl.Basic.Consume(this.ticket, this.queue, this.consumerTag, this.noLocal, this.noAck, this.exclusive, this.nowait, this.arguments);
                }

                public Builder consumerTag(String string2) {
                    this.consumerTag = string2;
                    return this;
                }

                public Builder exclusive() {
                    return this.exclusive(true);
                }

                public Builder exclusive(boolean bl2) {
                    this.exclusive = bl2;
                    return this;
                }

                public Builder noAck() {
                    return this.noAck(true);
                }

                public Builder noAck(boolean bl2) {
                    this.noAck = bl2;
                    return this;
                }

                public Builder noLocal() {
                    return this.noLocal(true);
                }

                public Builder noLocal(boolean bl2) {
                    this.noLocal = bl2;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder nowait(boolean bl2) {
                    this.nowait = bl2;
                    return this;
                }

                public Builder queue(String string2) {
                    this.queue = string2;
                    return this;
                }

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }
            }
        }

        public static interface ConsumeOk
        extends Method {
            public String getConsumerTag();

            public static final class Builder {
                private String consumerTag;

                public ConsumeOk build() {
                    return new AMQImpl.Basic.ConsumeOk(this.consumerTag);
                }

                public Builder consumerTag(String string2) {
                    this.consumerTag = string2;
                    return this;
                }
            }
        }

        public static interface Deliver
        extends Method {
            public String getConsumerTag();

            public long getDeliveryTag();

            public String getExchange();

            public boolean getRedelivered();

            public String getRoutingKey();

            public static final class Builder {
                private String consumerTag;
                private long deliveryTag;
                private String exchange;
                private boolean redelivered = false;
                private String routingKey;

                public Deliver build() {
                    return new AMQImpl.Basic.Deliver(this.consumerTag, this.deliveryTag, this.redelivered, this.exchange, this.routingKey);
                }

                public Builder consumerTag(String string2) {
                    this.consumerTag = string2;
                    return this;
                }

                public Builder deliveryTag(long l2) {
                    this.deliveryTag = l2;
                    return this;
                }

                public Builder exchange(String string2) {
                    this.exchange = string2;
                    return this;
                }

                public Builder redelivered() {
                    return this.redelivered(true);
                }

                public Builder redelivered(boolean bl2) {
                    this.redelivered = bl2;
                    return this;
                }

                public Builder routingKey(String string2) {
                    this.routingKey = string2;
                    return this;
                }
            }
        }

        public static interface Get
        extends Method {
            public boolean getNoAck();

            public String getQueue();

            public int getTicket();

            public static final class Builder {
                private boolean noAck = false;
                private String queue = "";
                private int ticket = 0;

                public Get build() {
                    return new AMQImpl.Basic.Get(this.ticket, this.queue, this.noAck);
                }

                public Builder noAck() {
                    return this.noAck(true);
                }

                public Builder noAck(boolean bl2) {
                    this.noAck = bl2;
                    return this;
                }

                public Builder queue(String string2) {
                    this.queue = string2;
                    return this;
                }

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }
            }
        }

        public static interface GetEmpty
        extends Method {
            public String getClusterId();

            public static final class Builder {
                private String clusterId = "";

                public GetEmpty build() {
                    return new AMQImpl.Basic.GetEmpty(this.clusterId);
                }

                public Builder clusterId(String string2) {
                    this.clusterId = string2;
                    return this;
                }
            }
        }

        public static interface GetOk
        extends Method {
            public long getDeliveryTag();

            public String getExchange();

            public int getMessageCount();

            public boolean getRedelivered();

            public String getRoutingKey();

            public static final class Builder {
                private long deliveryTag;
                private String exchange;
                private int messageCount;
                private boolean redelivered = false;
                private String routingKey;

                public GetOk build() {
                    return new AMQImpl.Basic.GetOk(this.deliveryTag, this.redelivered, this.exchange, this.routingKey, this.messageCount);
                }

                public Builder deliveryTag(long l2) {
                    this.deliveryTag = l2;
                    return this;
                }

                public Builder exchange(String string2) {
                    this.exchange = string2;
                    return this;
                }

                public Builder messageCount(int n2) {
                    this.messageCount = n2;
                    return this;
                }

                public Builder redelivered() {
                    return this.redelivered(true);
                }

                public Builder redelivered(boolean bl2) {
                    this.redelivered = bl2;
                    return this;
                }

                public Builder routingKey(String string2) {
                    this.routingKey = string2;
                    return this;
                }
            }
        }

        public static interface Nack
        extends Method {
            public long getDeliveryTag();

            public boolean getMultiple();

            public boolean getRequeue();

            public static final class Builder {
                private long deliveryTag = 0L;
                private boolean multiple = false;
                private boolean requeue = true;

                public Nack build() {
                    return new AMQImpl.Basic.Nack(this.deliveryTag, this.multiple, this.requeue);
                }

                public Builder deliveryTag(long l2) {
                    this.deliveryTag = l2;
                    return this;
                }

                public Builder multiple() {
                    return this.multiple(true);
                }

                public Builder multiple(boolean bl2) {
                    this.multiple = bl2;
                    return this;
                }

                public Builder requeue() {
                    return this.requeue(true);
                }

                public Builder requeue(boolean bl2) {
                    this.requeue = bl2;
                    return this;
                }
            }
        }

        public static interface Publish
        extends Method {
            public String getExchange();

            public boolean getImmediate();

            public boolean getMandatory();

            public String getRoutingKey();

            public int getTicket();

            public static final class Builder {
                private String exchange = "";
                private boolean immediate = false;
                private boolean mandatory = false;
                private String routingKey = "";
                private int ticket = 0;

                public Publish build() {
                    return new AMQImpl.Basic.Publish(this.ticket, this.exchange, this.routingKey, this.mandatory, this.immediate);
                }

                public Builder exchange(String string2) {
                    this.exchange = string2;
                    return this;
                }

                public Builder immediate() {
                    return this.immediate(true);
                }

                public Builder immediate(boolean bl2) {
                    this.immediate = bl2;
                    return this;
                }

                public Builder mandatory() {
                    return this.mandatory(true);
                }

                public Builder mandatory(boolean bl2) {
                    this.mandatory = bl2;
                    return this;
                }

                public Builder routingKey(String string2) {
                    this.routingKey = string2;
                    return this;
                }

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }
            }
        }

        public static interface Qos
        extends Method {
            public boolean getGlobal();

            public int getPrefetchCount();

            public int getPrefetchSize();

            public static final class Builder {
                private boolean global = false;
                private int prefetchCount = 0;
                private int prefetchSize = 0;

                public Qos build() {
                    return new AMQImpl.Basic.Qos(this.prefetchSize, this.prefetchCount, this.global);
                }

                public Builder global() {
                    return this.global(true);
                }

                public Builder global(boolean bl2) {
                    this.global = bl2;
                    return this;
                }

                public Builder prefetchCount(int n2) {
                    this.prefetchCount = n2;
                    return this;
                }

                public Builder prefetchSize(int n2) {
                    this.prefetchSize = n2;
                    return this;
                }
            }
        }

        public static interface QosOk
        extends Method {

            public static final class Builder {
                public QosOk build() {
                    return new AMQImpl.Basic.QosOk();
                }
            }
        }

        public static interface Recover
        extends Method {
            public boolean getRequeue();

            public static final class Builder {
                private boolean requeue = false;

                public Recover build() {
                    return new AMQImpl.Basic.Recover(this.requeue);
                }

                public Builder requeue() {
                    return this.requeue(true);
                }

                public Builder requeue(boolean bl2) {
                    this.requeue = bl2;
                    return this;
                }
            }
        }

        public static interface RecoverAsync
        extends Method {
            public boolean getRequeue();

            public static final class Builder {
                private boolean requeue = false;

                public RecoverAsync build() {
                    return new AMQImpl.Basic.RecoverAsync(this.requeue);
                }

                public Builder requeue() {
                    return this.requeue(true);
                }

                public Builder requeue(boolean bl2) {
                    this.requeue = bl2;
                    return this;
                }
            }
        }

        public static interface RecoverOk
        extends Method {

            public static final class Builder {
                public RecoverOk build() {
                    return new AMQImpl.Basic.RecoverOk();
                }
            }
        }

        public static interface Reject
        extends Method {
            public long getDeliveryTag();

            public boolean getRequeue();

            public static final class Builder {
                private long deliveryTag;
                private boolean requeue = true;

                public Reject build() {
                    return new AMQImpl.Basic.Reject(this.deliveryTag, this.requeue);
                }

                public Builder deliveryTag(long l2) {
                    this.deliveryTag = l2;
                    return this;
                }

                public Builder requeue() {
                    return this.requeue(true);
                }

                public Builder requeue(boolean bl2) {
                    this.requeue = bl2;
                    return this;
                }
            }
        }

        public static interface Return
        extends Method {
            public String getExchange();

            public int getReplyCode();

            public String getReplyText();

            public String getRoutingKey();

            public static final class Builder {
                private String exchange;
                private int replyCode;
                private String replyText = "";
                private String routingKey;

                public Return build() {
                    return new AMQImpl.Basic.Return(this.replyCode, this.replyText, this.exchange, this.routingKey);
                }

                public Builder exchange(String string2) {
                    this.exchange = string2;
                    return this;
                }

                public Builder replyCode(int n2) {
                    this.replyCode = n2;
                    return this;
                }

                public Builder replyText(String string2) {
                    this.replyText = string2;
                    return this;
                }

                public Builder routingKey(String string2) {
                    this.routingKey = string2;
                    return this;
                }
            }
        }
    }

    public static class BasicProperties
    extends AMQBasicProperties {
        private String appId;
        private String clusterId;
        private String contentEncoding;
        private String contentType;
        private String correlationId;
        private Integer deliveryMode;
        private String expiration;
        private Map<String, Object> headers;
        private String messageId;
        private Integer priority;
        private String replyTo;
        private Date timestamp;
        private String type;
        private String userId;

        public BasicProperties() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public BasicProperties(DataInputStream dataInputStream) throws IOException {
            super(dataInputStream);
            ContentHeaderPropertyReader contentHeaderPropertyReader = new ContentHeaderPropertyReader(dataInputStream);
            boolean bl2 = contentHeaderPropertyReader.readPresence();
            boolean bl3 = contentHeaderPropertyReader.readPresence();
            boolean bl4 = contentHeaderPropertyReader.readPresence();
            boolean bl5 = contentHeaderPropertyReader.readPresence();
            boolean bl6 = contentHeaderPropertyReader.readPresence();
            boolean bl7 = contentHeaderPropertyReader.readPresence();
            boolean bl8 = contentHeaderPropertyReader.readPresence();
            boolean bl9 = contentHeaderPropertyReader.readPresence();
            boolean bl10 = contentHeaderPropertyReader.readPresence();
            boolean bl11 = contentHeaderPropertyReader.readPresence();
            boolean bl12 = contentHeaderPropertyReader.readPresence();
            boolean bl13 = contentHeaderPropertyReader.readPresence();
            boolean bl14 = contentHeaderPropertyReader.readPresence();
            boolean bl15 = contentHeaderPropertyReader.readPresence();
            contentHeaderPropertyReader.finishPresence();
            String string2 = bl2 ? contentHeaderPropertyReader.readShortstr() : null;
            this.contentType = string2;
            String string3 = bl3 ? contentHeaderPropertyReader.readShortstr() : null;
            this.contentEncoding = string3;
            Map<String, Object> map = bl4 ? contentHeaderPropertyReader.readTable() : null;
            this.headers = map;
            Integer n2 = bl5 ? Integer.valueOf(contentHeaderPropertyReader.readOctet()) : null;
            this.deliveryMode = n2;
            Integer n3 = bl6 ? Integer.valueOf(contentHeaderPropertyReader.readOctet()) : null;
            this.priority = n3;
            String string4 = bl7 ? contentHeaderPropertyReader.readShortstr() : null;
            this.correlationId = string4;
            String string5 = bl8 ? contentHeaderPropertyReader.readShortstr() : null;
            this.replyTo = string5;
            String string6 = bl9 ? contentHeaderPropertyReader.readShortstr() : null;
            this.expiration = string6;
            String string7 = bl10 ? contentHeaderPropertyReader.readShortstr() : null;
            this.messageId = string7;
            Date date = bl11 ? contentHeaderPropertyReader.readTimestamp() : null;
            this.timestamp = date;
            String string8 = bl12 ? contentHeaderPropertyReader.readShortstr() : null;
            this.type = string8;
            String string9 = bl13 ? contentHeaderPropertyReader.readShortstr() : null;
            this.userId = string9;
            String string10 = bl14 ? contentHeaderPropertyReader.readShortstr() : null;
            this.appId = string10;
            String string11 = bl15 ? contentHeaderPropertyReader.readShortstr() : null;
            this.clusterId = string11;
        }

        /*
         * Enabled aggressive block sorting
         */
        public BasicProperties(String string2, String string3, Map<String, Object> map, Integer n2, Integer n3, String string4, String string5, String string6, String string7, Date date, String string8, String string9, String string10, String string11) {
            this.contentType = string2;
            this.contentEncoding = string3;
            Map<String, Object> map2 = map == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(map));
            this.headers = map2;
            this.deliveryMode = n2;
            this.priority = n3;
            this.correlationId = string4;
            this.replyTo = string5;
            this.expiration = string6;
            this.messageId = string7;
            this.timestamp = date;
            this.type = string8;
            this.userId = string9;
            this.appId = string10;
            this.clusterId = string11;
        }

        @Override
        public void appendPropertyDebugStringTo(StringBuilder stringBuilder) {
            stringBuilder.append("(content-type=").append(this.contentType).append(", content-encoding=").append(this.contentEncoding).append(", headers=").append(this.headers).append(", delivery-mode=").append(this.deliveryMode).append(", priority=").append(this.priority).append(", correlation-id=").append(this.correlationId).append(", reply-to=").append(this.replyTo).append(", expiration=").append(this.expiration).append(", message-id=").append(this.messageId).append(", timestamp=").append(this.timestamp).append(", type=").append(this.type).append(", user-id=").append(this.userId).append(", app-id=").append(this.appId).append(", cluster-id=").append(this.clusterId).append(")");
        }

        public Builder builder() {
            return new Builder().contentType(this.contentType).contentEncoding(this.contentEncoding).headers(this.headers).deliveryMode(this.deliveryMode).priority(this.priority).correlationId(this.correlationId).replyTo(this.replyTo).expiration(this.expiration).messageId(this.messageId).timestamp(this.timestamp).type(this.type).userId(this.userId).appId(this.appId).clusterId(this.clusterId);
        }

        @Override
        public String getAppId() {
            return this.appId;
        }

        @Override
        public int getClassId() {
            return 60;
        }

        @Override
        public String getClassName() {
            return "basic";
        }

        public String getClusterId() {
            return this.clusterId;
        }

        @Override
        public String getContentEncoding() {
            return this.contentEncoding;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public String getCorrelationId() {
            return this.correlationId;
        }

        @Override
        public Integer getDeliveryMode() {
            return this.deliveryMode;
        }

        @Override
        public String getExpiration() {
            return this.expiration;
        }

        @Override
        public Map<String, Object> getHeaders() {
            return this.headers;
        }

        @Override
        public String getMessageId() {
            return this.messageId;
        }

        @Override
        public Integer getPriority() {
            return this.priority;
        }

        @Override
        public String getReplyTo() {
            return this.replyTo;
        }

        @Override
        public Date getTimestamp() {
            return this.timestamp;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getUserId() {
            return this.userId;
        }

        @Override
        @Deprecated
        public void setAppId(String string2) {
            this.appId = string2;
        }

        @Deprecated
        public void setClusterId(String string2) {
            this.clusterId = string2;
        }

        @Override
        @Deprecated
        public void setContentEncoding(String string2) {
            this.contentEncoding = string2;
        }

        @Override
        @Deprecated
        public void setContentType(String string2) {
            this.contentType = string2;
        }

        @Override
        @Deprecated
        public void setCorrelationId(String string2) {
            this.correlationId = string2;
        }

        @Override
        @Deprecated
        public void setDeliveryMode(Integer n2) {
            this.deliveryMode = n2;
        }

        @Override
        @Deprecated
        public void setExpiration(String string2) {
            this.expiration = string2;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @Deprecated
        public void setHeaders(Map<String, Object> map) {
            Map<String, Object> map2 = map == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(map));
            this.headers = map2;
        }

        @Override
        @Deprecated
        public void setMessageId(String string2) {
            this.messageId = string2;
        }

        @Override
        @Deprecated
        public void setPriority(Integer n2) {
            this.priority = n2;
        }

        @Override
        @Deprecated
        public void setReplyTo(String string2) {
            this.replyTo = string2;
        }

        @Override
        @Deprecated
        public void setTimestamp(Date date) {
            this.timestamp = date;
        }

        @Override
        @Deprecated
        public void setType(String string2) {
            this.type = string2;
        }

        @Override
        @Deprecated
        public void setUserId(String string2) {
            this.userId = string2;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writePropertiesTo(ContentHeaderPropertyWriter contentHeaderPropertyWriter) throws IOException {
            boolean bl2 = true;
            boolean bl3 = this.contentType != null ? bl2 : false;
            contentHeaderPropertyWriter.writePresence(bl3);
            boolean bl4 = this.contentEncoding != null ? bl2 : false;
            contentHeaderPropertyWriter.writePresence(bl4);
            boolean bl5 = this.headers != null ? bl2 : false;
            contentHeaderPropertyWriter.writePresence(bl5);
            boolean bl6 = this.deliveryMode != null ? bl2 : false;
            contentHeaderPropertyWriter.writePresence(bl6);
            boolean bl7 = this.priority != null ? bl2 : false;
            contentHeaderPropertyWriter.writePresence(bl7);
            boolean bl8 = this.correlationId != null ? bl2 : false;
            contentHeaderPropertyWriter.writePresence(bl8);
            boolean bl9 = this.replyTo != null ? bl2 : false;
            contentHeaderPropertyWriter.writePresence(bl9);
            boolean bl10 = this.expiration != null ? bl2 : false;
            contentHeaderPropertyWriter.writePresence(bl10);
            boolean bl11 = this.messageId != null ? bl2 : false;
            contentHeaderPropertyWriter.writePresence(bl11);
            boolean bl12 = this.timestamp != null ? bl2 : false;
            contentHeaderPropertyWriter.writePresence(bl12);
            boolean bl13 = this.type != null ? bl2 : false;
            contentHeaderPropertyWriter.writePresence(bl13);
            boolean bl14 = this.userId != null ? bl2 : false;
            contentHeaderPropertyWriter.writePresence(bl14);
            boolean bl15 = this.appId != null ? bl2 : false;
            contentHeaderPropertyWriter.writePresence(bl15);
            if (this.clusterId == null) {
                bl2 = false;
            }
            contentHeaderPropertyWriter.writePresence(bl2);
            contentHeaderPropertyWriter.finishPresence();
            if (this.contentType != null) {
                contentHeaderPropertyWriter.writeShortstr(this.contentType);
            }
            if (this.contentEncoding != null) {
                contentHeaderPropertyWriter.writeShortstr(this.contentEncoding);
            }
            if (this.headers != null) {
                contentHeaderPropertyWriter.writeTable(this.headers);
            }
            if (this.deliveryMode != null) {
                contentHeaderPropertyWriter.writeOctet(this.deliveryMode);
            }
            if (this.priority != null) {
                contentHeaderPropertyWriter.writeOctet(this.priority);
            }
            if (this.correlationId != null) {
                contentHeaderPropertyWriter.writeShortstr(this.correlationId);
            }
            if (this.replyTo != null) {
                contentHeaderPropertyWriter.writeShortstr(this.replyTo);
            }
            if (this.expiration != null) {
                contentHeaderPropertyWriter.writeShortstr(this.expiration);
            }
            if (this.messageId != null) {
                contentHeaderPropertyWriter.writeShortstr(this.messageId);
            }
            if (this.timestamp != null) {
                contentHeaderPropertyWriter.writeTimestamp(this.timestamp);
            }
            if (this.type != null) {
                contentHeaderPropertyWriter.writeShortstr(this.type);
            }
            if (this.userId != null) {
                contentHeaderPropertyWriter.writeShortstr(this.userId);
            }
            if (this.appId != null) {
                contentHeaderPropertyWriter.writeShortstr(this.appId);
            }
            if (this.clusterId != null) {
                contentHeaderPropertyWriter.writeShortstr(this.clusterId);
            }
        }

        public static final class Builder {
            private String appId;
            private String clusterId;
            private String contentEncoding;
            private String contentType;
            private String correlationId;
            private Integer deliveryMode;
            private String expiration;
            private Map<String, Object> headers;
            private String messageId;
            private Integer priority;
            private String replyTo;
            private Date timestamp;
            private String type;
            private String userId;

            public Builder appId(String string2) {
                this.appId = string2;
                return this;
            }

            public BasicProperties build() {
                return new BasicProperties(this.contentType, this.contentEncoding, this.headers, this.deliveryMode, this.priority, this.correlationId, this.replyTo, this.expiration, this.messageId, this.timestamp, this.type, this.userId, this.appId, this.clusterId);
            }

            public Builder clusterId(String string2) {
                this.clusterId = string2;
                return this;
            }

            public Builder contentEncoding(String string2) {
                this.contentEncoding = string2;
                return this;
            }

            public Builder contentType(String string2) {
                this.contentType = string2;
                return this;
            }

            public Builder correlationId(String string2) {
                this.correlationId = string2;
                return this;
            }

            public Builder deliveryMode(Integer n2) {
                this.deliveryMode = n2;
                return this;
            }

            public Builder expiration(String string2) {
                this.expiration = string2;
                return this;
            }

            public Builder headers(Map<String, Object> map) {
                this.headers = map;
                return this;
            }

            public Builder messageId(String string2) {
                this.messageId = string2;
                return this;
            }

            public Builder priority(Integer n2) {
                this.priority = n2;
                return this;
            }

            public Builder replyTo(String string2) {
                this.replyTo = string2;
                return this;
            }

            public Builder timestamp(Date date) {
                this.timestamp = date;
                return this;
            }

            public Builder type(String string2) {
                this.type = string2;
                return this;
            }

            public Builder userId(String string2) {
                this.userId = string2;
                return this;
            }
        }
    }

    public static class Channel {

        public static interface Close
        extends Method {
            public int getClassId();

            public int getMethodId();

            public int getReplyCode();

            public String getReplyText();

            public static final class Builder {
                private int classId;
                private int methodId;
                private int replyCode;
                private String replyText = "";

                public Close build() {
                    return new AMQImpl.Channel.Close(this.replyCode, this.replyText, this.classId, this.methodId);
                }

                public Builder classId(int n2) {
                    this.classId = n2;
                    return this;
                }

                public Builder methodId(int n2) {
                    this.methodId = n2;
                    return this;
                }

                public Builder replyCode(int n2) {
                    this.replyCode = n2;
                    return this;
                }

                public Builder replyText(String string2) {
                    this.replyText = string2;
                    return this;
                }
            }
        }

        public static interface CloseOk
        extends Method {

            public static final class Builder {
                public CloseOk build() {
                    return new AMQImpl.Channel.CloseOk();
                }
            }
        }

        public static interface Flow
        extends Method {
            public boolean getActive();

            public static final class Builder {
                private boolean active;

                public Builder active() {
                    return this.active(true);
                }

                public Builder active(boolean bl2) {
                    this.active = bl2;
                    return this;
                }

                public Flow build() {
                    return new AMQImpl.Channel.Flow(this.active);
                }
            }
        }

        public static interface FlowOk
        extends Method {
            public boolean getActive();

            public static final class Builder {
                private boolean active;

                public Builder active() {
                    return this.active(true);
                }

                public Builder active(boolean bl2) {
                    this.active = bl2;
                    return this;
                }

                public FlowOk build() {
                    return new AMQImpl.Channel.FlowOk(this.active);
                }
            }
        }

        public static interface Open
        extends Method {
            public String getOutOfBand();

            public static final class Builder {
                private String outOfBand = "";

                public Open build() {
                    return new AMQImpl.Channel.Open(this.outOfBand);
                }

                public Builder outOfBand(String string2) {
                    this.outOfBand = string2;
                    return this;
                }
            }
        }

        public static interface OpenOk
        extends Method {
            public LongString getChannelId();

            public static final class Builder {
                private LongString channelId = LongStringHelper.asLongString("");

                public OpenOk build() {
                    return new AMQImpl.Channel.OpenOk(this.channelId);
                }

                public Builder channelId(LongString longString) {
                    this.channelId = longString;
                    return this;
                }

                public Builder channelId(String string2) {
                    return this.channelId(LongStringHelper.asLongString(string2));
                }
            }
        }
    }

    public static class Confirm {

        public static interface Select
        extends Method {
            public boolean getNowait();

            public static final class Builder {
                private boolean nowait = false;

                public Select build() {
                    return new AMQImpl.Confirm.Select(this.nowait);
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder nowait(boolean bl2) {
                    this.nowait = bl2;
                    return this;
                }
            }
        }

        public static interface SelectOk
        extends Method {

            public static final class Builder {
                public SelectOk build() {
                    return new AMQImpl.Confirm.SelectOk();
                }
            }
        }
    }

    public static class Connection {

        public static interface Blocked
        extends Method {
            public String getReason();

            public static final class Builder {
                private String reason = "";

                public Blocked build() {
                    return new AMQImpl.Connection.Blocked(this.reason);
                }

                public Builder reason(String string2) {
                    this.reason = string2;
                    return this;
                }
            }
        }

        public static interface Close
        extends Method {
            public int getClassId();

            public int getMethodId();

            public int getReplyCode();

            public String getReplyText();

            public static final class Builder {
                private int classId;
                private int methodId;
                private int replyCode;
                private String replyText = "";

                public Close build() {
                    return new AMQImpl.Connection.Close(this.replyCode, this.replyText, this.classId, this.methodId);
                }

                public Builder classId(int n2) {
                    this.classId = n2;
                    return this;
                }

                public Builder methodId(int n2) {
                    this.methodId = n2;
                    return this;
                }

                public Builder replyCode(int n2) {
                    this.replyCode = n2;
                    return this;
                }

                public Builder replyText(String string2) {
                    this.replyText = string2;
                    return this;
                }
            }
        }

        public static interface CloseOk
        extends Method {

            public static final class Builder {
                public CloseOk build() {
                    return new AMQImpl.Connection.CloseOk();
                }
            }
        }

        public static interface Open
        extends Method {
            public String getCapabilities();

            public boolean getInsist();

            public String getVirtualHost();

            public static final class Builder {
                private String capabilities = "";
                private boolean insist = false;
                private String virtualHost = "/";

                public Open build() {
                    return new AMQImpl.Connection.Open(this.virtualHost, this.capabilities, this.insist);
                }

                public Builder capabilities(String string2) {
                    this.capabilities = string2;
                    return this;
                }

                public Builder insist() {
                    return this.insist(true);
                }

                public Builder insist(boolean bl2) {
                    this.insist = bl2;
                    return this;
                }

                public Builder virtualHost(String string2) {
                    this.virtualHost = string2;
                    return this;
                }
            }
        }

        public static interface OpenOk
        extends Method {
            public String getKnownHosts();

            public static final class Builder {
                private String knownHosts = "";

                public OpenOk build() {
                    return new AMQImpl.Connection.OpenOk(this.knownHosts);
                }

                public Builder knownHosts(String string2) {
                    this.knownHosts = string2;
                    return this;
                }
            }
        }

        public static interface Secure
        extends Method {
            public LongString getChallenge();

            public static final class Builder {
                private LongString challenge;

                public Secure build() {
                    return new AMQImpl.Connection.Secure(this.challenge);
                }

                public Builder challenge(LongString longString) {
                    this.challenge = longString;
                    return this;
                }

                public Builder challenge(String string2) {
                    return this.challenge(LongStringHelper.asLongString(string2));
                }
            }
        }

        public static interface SecureOk
        extends Method {
            public LongString getResponse();

            public static final class Builder {
                private LongString response;

                public SecureOk build() {
                    return new AMQImpl.Connection.SecureOk(this.response);
                }

                public Builder response(LongString longString) {
                    this.response = longString;
                    return this;
                }

                public Builder response(String string2) {
                    return this.response(LongStringHelper.asLongString(string2));
                }
            }
        }

        public static interface Start
        extends Method {
            public LongString getLocales();

            public LongString getMechanisms();

            public Map<String, Object> getServerProperties();

            public int getVersionMajor();

            public int getVersionMinor();

            public static final class Builder {
                private LongString locales;
                private LongString mechanisms = LongStringHelper.asLongString("PLAIN");
                private Map<String, Object> serverProperties;
                private int versionMajor = 0;
                private int versionMinor = 9;

                public Builder() {
                    this.locales = LongStringHelper.asLongString("en_US");
                }

                public Start build() {
                    return new AMQImpl.Connection.Start(this.versionMajor, this.versionMinor, this.serverProperties, this.mechanisms, this.locales);
                }

                public Builder locales(LongString longString) {
                    this.locales = longString;
                    return this;
                }

                public Builder locales(String string2) {
                    return this.locales(LongStringHelper.asLongString(string2));
                }

                public Builder mechanisms(LongString longString) {
                    this.mechanisms = longString;
                    return this;
                }

                public Builder mechanisms(String string2) {
                    return this.mechanisms(LongStringHelper.asLongString(string2));
                }

                public Builder serverProperties(Map<String, Object> map) {
                    this.serverProperties = map;
                    return this;
                }

                public Builder versionMajor(int n2) {
                    this.versionMajor = n2;
                    return this;
                }

                public Builder versionMinor(int n2) {
                    this.versionMinor = n2;
                    return this;
                }
            }
        }

        public static interface StartOk
        extends Method {
            public Map<String, Object> getClientProperties();

            public String getLocale();

            public String getMechanism();

            public LongString getResponse();

            public static final class Builder {
                private Map<String, Object> clientProperties;
                private String locale = "en_US";
                private String mechanism = "PLAIN";
                private LongString response;

                public StartOk build() {
                    return new AMQImpl.Connection.StartOk(this.clientProperties, this.mechanism, this.response, this.locale);
                }

                public Builder clientProperties(Map<String, Object> map) {
                    this.clientProperties = map;
                    return this;
                }

                public Builder locale(String string2) {
                    this.locale = string2;
                    return this;
                }

                public Builder mechanism(String string2) {
                    this.mechanism = string2;
                    return this;
                }

                public Builder response(LongString longString) {
                    this.response = longString;
                    return this;
                }

                public Builder response(String string2) {
                    return this.response(LongStringHelper.asLongString(string2));
                }
            }
        }

        public static interface Tune
        extends Method {
            public int getChannelMax();

            public int getFrameMax();

            public int getHeartbeat();

            public static final class Builder {
                private int channelMax = 0;
                private int frameMax = 0;
                private int heartbeat = 0;

                public Tune build() {
                    return new AMQImpl.Connection.Tune(this.channelMax, this.frameMax, this.heartbeat);
                }

                public Builder channelMax(int n2) {
                    this.channelMax = n2;
                    return this;
                }

                public Builder frameMax(int n2) {
                    this.frameMax = n2;
                    return this;
                }

                public Builder heartbeat(int n2) {
                    this.heartbeat = n2;
                    return this;
                }
            }
        }

        public static interface TuneOk
        extends Method {
            public int getChannelMax();

            public int getFrameMax();

            public int getHeartbeat();

            public static final class Builder {
                private int channelMax = 0;
                private int frameMax = 0;
                private int heartbeat = 0;

                public TuneOk build() {
                    return new AMQImpl.Connection.TuneOk(this.channelMax, this.frameMax, this.heartbeat);
                }

                public Builder channelMax(int n2) {
                    this.channelMax = n2;
                    return this;
                }

                public Builder frameMax(int n2) {
                    this.frameMax = n2;
                    return this;
                }

                public Builder heartbeat(int n2) {
                    this.heartbeat = n2;
                    return this;
                }
            }
        }

        public static interface Unblocked
        extends Method {

            public static final class Builder {
                public Unblocked build() {
                    return new AMQImpl.Connection.Unblocked();
                }
            }
        }
    }

    public static class Exchange {

        public static interface Bind
        extends Method {
            public Map<String, Object> getArguments();

            public String getDestination();

            public boolean getNowait();

            public String getRoutingKey();

            public String getSource();

            public int getTicket();

            public static final class Builder {
                private Map<String, Object> arguments = null;
                private String destination;
                private boolean nowait = false;
                private String routingKey = "";
                private String source;
                private int ticket = 0;

                public Builder arguments(Map<String, Object> map) {
                    this.arguments = map;
                    return this;
                }

                public Bind build() {
                    return new AMQImpl.Exchange.Bind(this.ticket, this.destination, this.source, this.routingKey, this.nowait, this.arguments);
                }

                public Builder destination(String string2) {
                    this.destination = string2;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder nowait(boolean bl2) {
                    this.nowait = bl2;
                    return this;
                }

                public Builder routingKey(String string2) {
                    this.routingKey = string2;
                    return this;
                }

                public Builder source(String string2) {
                    this.source = string2;
                    return this;
                }

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }
            }
        }

        public static interface BindOk
        extends Method {

            public static final class Builder {
                public BindOk build() {
                    return new AMQImpl.Exchange.BindOk();
                }
            }
        }

        public static interface Declare
        extends Method {
            public Map<String, Object> getArguments();

            public boolean getAutoDelete();

            public boolean getDurable();

            public String getExchange();

            public boolean getInternal();

            public boolean getNowait();

            public boolean getPassive();

            public int getTicket();

            public String getType();

            public static final class Builder {
                private Map<String, Object> arguments = null;
                private boolean autoDelete = false;
                private boolean durable = false;
                private String exchange;
                private boolean internal = false;
                private boolean nowait = false;
                private boolean passive = false;
                private int ticket = 0;
                private String type = "direct";

                public Builder arguments(Map<String, Object> map) {
                    this.arguments = map;
                    return this;
                }

                public Builder autoDelete() {
                    return this.autoDelete(true);
                }

                public Builder autoDelete(boolean bl2) {
                    this.autoDelete = bl2;
                    return this;
                }

                public Declare build() {
                    return new AMQImpl.Exchange.Declare(this.ticket, this.exchange, this.type, this.passive, this.durable, this.autoDelete, this.internal, this.nowait, this.arguments);
                }

                public Builder durable() {
                    return this.durable(true);
                }

                public Builder durable(boolean bl2) {
                    this.durable = bl2;
                    return this;
                }

                public Builder exchange(String string2) {
                    this.exchange = string2;
                    return this;
                }

                public Builder internal() {
                    return this.internal(true);
                }

                public Builder internal(boolean bl2) {
                    this.internal = bl2;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder nowait(boolean bl2) {
                    this.nowait = bl2;
                    return this;
                }

                public Builder passive() {
                    return this.passive(true);
                }

                public Builder passive(boolean bl2) {
                    this.passive = bl2;
                    return this;
                }

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }

                public Builder type(String string2) {
                    this.type = string2;
                    return this;
                }
            }
        }

        public static interface DeclareOk
        extends Method {

            public static final class Builder {
                public DeclareOk build() {
                    return new AMQImpl.Exchange.DeclareOk();
                }
            }
        }

        public static interface Delete
        extends Method {
            public String getExchange();

            public boolean getIfUnused();

            public boolean getNowait();

            public int getTicket();

            public static final class Builder {
                private String exchange;
                private boolean ifUnused = false;
                private boolean nowait = false;
                private int ticket = 0;

                public Delete build() {
                    return new AMQImpl.Exchange.Delete(this.ticket, this.exchange, this.ifUnused, this.nowait);
                }

                public Builder exchange(String string2) {
                    this.exchange = string2;
                    return this;
                }

                public Builder ifUnused() {
                    return this.ifUnused(true);
                }

                public Builder ifUnused(boolean bl2) {
                    this.ifUnused = bl2;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder nowait(boolean bl2) {
                    this.nowait = bl2;
                    return this;
                }

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }
            }
        }

        public static interface DeleteOk
        extends Method {

            public static final class Builder {
                public DeleteOk build() {
                    return new AMQImpl.Exchange.DeleteOk();
                }
            }
        }

        public static interface Unbind
        extends Method {
            public Map<String, Object> getArguments();

            public String getDestination();

            public boolean getNowait();

            public String getRoutingKey();

            public String getSource();

            public int getTicket();

            public static final class Builder {
                private Map<String, Object> arguments = null;
                private String destination;
                private boolean nowait = false;
                private String routingKey = "";
                private String source;
                private int ticket = 0;

                public Builder arguments(Map<String, Object> map) {
                    this.arguments = map;
                    return this;
                }

                public Unbind build() {
                    return new AMQImpl.Exchange.Unbind(this.ticket, this.destination, this.source, this.routingKey, this.nowait, this.arguments);
                }

                public Builder destination(String string2) {
                    this.destination = string2;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder nowait(boolean bl2) {
                    this.nowait = bl2;
                    return this;
                }

                public Builder routingKey(String string2) {
                    this.routingKey = string2;
                    return this;
                }

                public Builder source(String string2) {
                    this.source = string2;
                    return this;
                }

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }
            }
        }

        public static interface UnbindOk
        extends Method {

            public static final class Builder {
                public UnbindOk build() {
                    return new AMQImpl.Exchange.UnbindOk();
                }
            }
        }
    }

    public static class PROTOCOL {
        public static final int MAJOR = 0;
        public static final int MINOR = 9;
        public static final int PORT = 5672;
        public static final int REVISION = 1;
    }

    public static class Queue {

        public static interface Bind
        extends Method {
            public Map<String, Object> getArguments();

            public String getExchange();

            public boolean getNowait();

            public String getQueue();

            public String getRoutingKey();

            public int getTicket();

            public static final class Builder {
                private Map<String, Object> arguments = null;
                private String exchange;
                private boolean nowait = false;
                private String queue = "";
                private String routingKey = "";
                private int ticket = 0;

                public Builder arguments(Map<String, Object> map) {
                    this.arguments = map;
                    return this;
                }

                public Bind build() {
                    return new AMQImpl.Queue.Bind(this.ticket, this.queue, this.exchange, this.routingKey, this.nowait, this.arguments);
                }

                public Builder exchange(String string2) {
                    this.exchange = string2;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder nowait(boolean bl2) {
                    this.nowait = bl2;
                    return this;
                }

                public Builder queue(String string2) {
                    this.queue = string2;
                    return this;
                }

                public Builder routingKey(String string2) {
                    this.routingKey = string2;
                    return this;
                }

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }
            }
        }

        public static interface BindOk
        extends Method {

            public static final class Builder {
                public BindOk build() {
                    return new AMQImpl.Queue.BindOk();
                }
            }
        }

        public static interface Declare
        extends Method {
            public Map<String, Object> getArguments();

            public boolean getAutoDelete();

            public boolean getDurable();

            public boolean getExclusive();

            public boolean getNowait();

            public boolean getPassive();

            public String getQueue();

            public int getTicket();

            public static final class Builder {
                private Map<String, Object> arguments = null;
                private boolean autoDelete = false;
                private boolean durable = false;
                private boolean exclusive = false;
                private boolean nowait = false;
                private boolean passive = false;
                private String queue = "";
                private int ticket = 0;

                public Builder arguments(Map<String, Object> map) {
                    this.arguments = map;
                    return this;
                }

                public Builder autoDelete() {
                    return this.autoDelete(true);
                }

                public Builder autoDelete(boolean bl2) {
                    this.autoDelete = bl2;
                    return this;
                }

                public Declare build() {
                    return new AMQImpl.Queue.Declare(this.ticket, this.queue, this.passive, this.durable, this.exclusive, this.autoDelete, this.nowait, this.arguments);
                }

                public Builder durable() {
                    return this.durable(true);
                }

                public Builder durable(boolean bl2) {
                    this.durable = bl2;
                    return this;
                }

                public Builder exclusive() {
                    return this.exclusive(true);
                }

                public Builder exclusive(boolean bl2) {
                    this.exclusive = bl2;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder nowait(boolean bl2) {
                    this.nowait = bl2;
                    return this;
                }

                public Builder passive() {
                    return this.passive(true);
                }

                public Builder passive(boolean bl2) {
                    this.passive = bl2;
                    return this;
                }

                public Builder queue(String string2) {
                    this.queue = string2;
                    return this;
                }

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }
            }
        }

        public static interface DeclareOk
        extends Method {
            public int getConsumerCount();

            public int getMessageCount();

            public String getQueue();

            public static final class Builder {
                private int consumerCount;
                private int messageCount;
                private String queue;

                public DeclareOk build() {
                    return new AMQImpl.Queue.DeclareOk(this.queue, this.messageCount, this.consumerCount);
                }

                public Builder consumerCount(int n2) {
                    this.consumerCount = n2;
                    return this;
                }

                public Builder messageCount(int n2) {
                    this.messageCount = n2;
                    return this;
                }

                public Builder queue(String string2) {
                    this.queue = string2;
                    return this;
                }
            }
        }

        public static interface Delete
        extends Method {
            public boolean getIfEmpty();

            public boolean getIfUnused();

            public boolean getNowait();

            public String getQueue();

            public int getTicket();

            public static final class Builder {
                private boolean ifEmpty = false;
                private boolean ifUnused = false;
                private boolean nowait = false;
                private String queue = "";
                private int ticket = 0;

                public Delete build() {
                    return new AMQImpl.Queue.Delete(this.ticket, this.queue, this.ifUnused, this.ifEmpty, this.nowait);
                }

                public Builder ifEmpty() {
                    return this.ifEmpty(true);
                }

                public Builder ifEmpty(boolean bl2) {
                    this.ifEmpty = bl2;
                    return this;
                }

                public Builder ifUnused() {
                    return this.ifUnused(true);
                }

                public Builder ifUnused(boolean bl2) {
                    this.ifUnused = bl2;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder nowait(boolean bl2) {
                    this.nowait = bl2;
                    return this;
                }

                public Builder queue(String string2) {
                    this.queue = string2;
                    return this;
                }

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }
            }
        }

        public static interface DeleteOk
        extends Method {
            public int getMessageCount();

            public static final class Builder {
                private int messageCount;

                public DeleteOk build() {
                    return new AMQImpl.Queue.DeleteOk(this.messageCount);
                }

                public Builder messageCount(int n2) {
                    this.messageCount = n2;
                    return this;
                }
            }
        }

        public static interface Purge
        extends Method {
            public boolean getNowait();

            public String getQueue();

            public int getTicket();

            public static final class Builder {
                private boolean nowait = false;
                private String queue = "";
                private int ticket = 0;

                public Purge build() {
                    return new AMQImpl.Queue.Purge(this.ticket, this.queue, this.nowait);
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder nowait(boolean bl2) {
                    this.nowait = bl2;
                    return this;
                }

                public Builder queue(String string2) {
                    this.queue = string2;
                    return this;
                }

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }
            }
        }

        public static interface PurgeOk
        extends Method {
            public int getMessageCount();

            public static final class Builder {
                private int messageCount;

                public PurgeOk build() {
                    return new AMQImpl.Queue.PurgeOk(this.messageCount);
                }

                public Builder messageCount(int n2) {
                    this.messageCount = n2;
                    return this;
                }
            }
        }

        public static interface Unbind
        extends Method {
            public Map<String, Object> getArguments();

            public String getExchange();

            public String getQueue();

            public String getRoutingKey();

            public int getTicket();

            public static final class Builder {
                private Map<String, Object> arguments = null;
                private String exchange;
                private String queue = "";
                private String routingKey = "";
                private int ticket = 0;

                public Builder arguments(Map<String, Object> map) {
                    this.arguments = map;
                    return this;
                }

                public Unbind build() {
                    return new AMQImpl.Queue.Unbind(this.ticket, this.queue, this.exchange, this.routingKey, this.arguments);
                }

                public Builder exchange(String string2) {
                    this.exchange = string2;
                    return this;
                }

                public Builder queue(String string2) {
                    this.queue = string2;
                    return this;
                }

                public Builder routingKey(String string2) {
                    this.routingKey = string2;
                    return this;
                }

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }
            }
        }

        public static interface UnbindOk
        extends Method {

            public static final class Builder {
                public UnbindOk build() {
                    return new AMQImpl.Queue.UnbindOk();
                }
            }
        }
    }

    public static class Tx {

        public static interface Commit
        extends Method {

            public static final class Builder {
                public Commit build() {
                    return new AMQImpl.Tx.Commit();
                }
            }
        }

        public static interface CommitOk
        extends Method {

            public static final class Builder {
                public CommitOk build() {
                    return new AMQImpl.Tx.CommitOk();
                }
            }
        }

        public static interface Rollback
        extends Method {

            public static final class Builder {
                public Rollback build() {
                    return new AMQImpl.Tx.Rollback();
                }
            }
        }

        public static interface RollbackOk
        extends Method {

            public static final class Builder {
                public RollbackOk build() {
                    return new AMQImpl.Tx.RollbackOk();
                }
            }
        }

        public static interface Select
        extends Method {

            public static final class Builder {
                public Select build() {
                    return new AMQImpl.Tx.Select();
                }
            }
        }

        public static interface SelectOk
        extends Method {

            public static final class Builder {
                public SelectOk build() {
                    return new AMQImpl.Tx.SelectOk();
                }
            }
        }
    }
}

