/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.retry;

import com.octo.android.robospice.persistence.exception.SpiceException;
import com.octo.android.robospice.retry.RetryPolicy;

public class DefaultRetryPolicy
implements RetryPolicy {
    public static final float DEFAULT_BACKOFF_MULT = 1.0f;
    public static final long DEFAULT_DELAY_BEFORE_RETRY = 2500L;
    public static final int DEFAULT_RETRY_COUNT = 3;
    private float backOffMultiplier = 1.0f;
    private long delayBeforeRetry = 2500L;
    private int retryCount = 3;

    public DefaultRetryPolicy() {
        this(3, 2500L, 1.0f);
    }

    public DefaultRetryPolicy(int n2, long l2, float f2) {
        this.retryCount = n2;
        this.delayBeforeRetry = l2;
        this.backOffMultiplier = f2;
    }

    @Override
    public long getDelayBeforeRetry() {
        return this.delayBeforeRetry;
    }

    @Override
    public int getRetryCount() {
        return this.retryCount;
    }

    @Override
    public void retry(SpiceException spiceException) {
        this.retryCount = -1 + this.retryCount;
        this.delayBeforeRetry = (long)((float)this.delayBeforeRetry * this.backOffMultiplier);
    }
}

