/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.request.simple;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.octo.android.robospice.request.ProgressByteProcessor;
import com.octo.android.robospice.request.SpiceRequest;
import com.octo.android.robospice.request.simple.IBitmapRequest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import roboguice.util.temp.Ln;

public class BitmapRequest
extends SpiceRequest<Bitmap>
implements IBitmapRequest {
    private static final int BUF_SIZE = 4096;
    private File cacheFile;
    private int height = -1;
    private BitmapFactory.Options options;
    private String url;
    private int width = -1;

    public BitmapRequest(String string2, int n2, int n3, File file) {
        super(Bitmap.class);
        this.url = string2;
        this.width = n2;
        this.height = n3;
        this.cacheFile = file;
    }

    public BitmapRequest(String string2, BitmapFactory.Options options, File file) {
        super(Bitmap.class);
        this.url = string2;
        this.options = options;
        this.cacheFile = file;
    }

    public BitmapRequest(String string2, File file) {
        this(string2, new BitmapFactory.Options(), file);
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int n2, int n3) {
        int n4;
        block3: {
            int n5;
            block2: {
                int n6 = options.outHeight;
                n4 = options.outWidth;
                n5 = 1;
                if (n6 <= n3 && n4 <= n2) break block2;
                if (n4 <= n6) break block3;
                n5 = Math.round((float)n6 / (float)n3);
            }
            return n5;
        }
        return Math.round((float)n4 / (float)n2);
    }

    @Override
    public File getCacheFile() {
        return this.cacheFile;
    }

    protected final String getUrl() {
        return this.url;
    }

    @Override
    public Bitmap loadDataFromNetwork() throws Exception {
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(this.url).openConnection();
            this.processStream(httpURLConnection.getContentLength(), httpURLConnection.getInputStream());
            if (this.width != -1 && this.height != -1) {
                this.options = new BitmapFactory.Options();
                this.options.inJustDecodeBounds = true;
                BitmapFactory.decodeFile((String)this.cacheFile.getAbsolutePath(), (BitmapFactory.Options)this.options);
                this.options.inSampleSize = BitmapRequest.calculateInSampleSize(this.options, this.width, this.height);
                this.options.inJustDecodeBounds = false;
                this.options.inPurgeable = true;
                return BitmapFactory.decodeFile((String)this.cacheFile.getAbsolutePath(), (BitmapFactory.Options)this.options);
            }
            Bitmap bitmap = BitmapFactory.decodeFile((String)this.cacheFile.getAbsolutePath(), (BitmapFactory.Options)this.options);
            return bitmap;
        }
        catch (MalformedURLException malformedURLException) {
            Ln.e(malformedURLException, (Object)"Unable to create URL", new Object[0]);
            throw malformedURLException;
        }
        catch (IOException iOException) {
            Ln.e(iOException, (Object)"Unable to download binary", new Object[0]);
            throw iOException;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processStream(int n2, InputStream inputStream) throws IOException {
        FileOutputStream fileOutputStream;
        FileOutputStream fileOutputStream2 = null;
        try {
            if (!this.cacheFile.setLastModified(System.currentTimeMillis())) {
                Object[] objectArray = new Object[]{this.cacheFile.getAbsolutePath()};
                Ln.d("Modification time of file %s could not be changed normally ", objectArray);
            }
            fileOutputStream = new FileOutputStream(this.cacheFile);
        }
        catch (Throwable throwable) {}
        try {
            this.readBytes(inputStream, new ProgressByteProcessor(this, fileOutputStream, n2));
        }
        catch (Throwable throwable) {
            fileOutputStream2 = fileOutputStream;
        }
        IOUtils.closeQuietly(fileOutputStream);
        return;
        {
            void var4_7;
            IOUtils.closeQuietly(fileOutputStream2);
            throw var4_7;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readBytes(InputStream inputStream, ProgressByteProcessor progressByteProcessor) throws IOException {
        byte[] byArray = new byte[4096];
        while (true) {
            int n2;
            try {
                n2 = inputStream.read(byArray);
                if (n2 != -1) continue;
                break;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            {
                boolean bl2;
                if (bl2 = progressByteProcessor.processBytes(byArray, 0, n2)) continue;
            }
            break;
        }
        IOUtils.closeQuietly(inputStream);
    }
}

