/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.request.simple;

import com.octo.android.robospice.request.ProgressByteProcessor;
import com.octo.android.robospice.request.SpiceRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import roboguice.util.temp.Ln;

public abstract class BinaryRequest
extends SpiceRequest<InputStream> {
    private static final int BUF_SIZE = 4096;
    protected String url;

    public BinaryRequest(String string2) {
        super(InputStream.class);
        this.url = string2;
    }

    protected final String getUrl() {
        return this.url;
    }

    @Override
    public final InputStream loadDataFromNetwork() throws Exception {
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(this.url).openConnection();
            InputStream inputStream = this.processStream(httpURLConnection.getContentLength(), httpURLConnection.getInputStream());
            return inputStream;
        }
        catch (MalformedURLException malformedURLException) {
            Ln.e(malformedURLException, (Object)"Unable to create URL", new Object[0]);
            throw malformedURLException;
        }
        catch (IOException iOException) {
            Ln.e(iOException, (Object)"Unable to download binary", new Object[0]);
            throw iOException;
        }
    }

    public abstract InputStream processStream(int var1, InputStream var2) throws IOException;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readBytes(InputStream inputStream, ProgressByteProcessor progressByteProcessor) throws IOException {
        byte[] byArray = new byte[4096];
        while (true) {
            int n2;
            try {
                n2 = inputStream.read(byArray);
                if (n2 != -1) continue;
                break;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            {
                boolean bl2;
                if (bl2 = progressByteProcessor.processBytes(byArray, 0, n2)) continue;
            }
            break;
        }
        IOUtils.closeQuietly(inputStream);
    }
}

