/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.request.notifier;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.octo.android.robospice.request.CachedSpiceRequest;
import com.octo.android.robospice.request.listener.RequestListener;
import com.octo.android.robospice.request.listener.RequestProgress;
import com.octo.android.robospice.request.listener.SpiceServiceListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import roboguice.util.temp.Ln;

public class SpiceServiceListenerNotifier {
    private Handler messageQueue;
    private final List<SpiceServiceListener> spiceServiceListenerList = Collections.synchronizedList(new ArrayList());

    public void addSpiceServiceListener(SpiceServiceListener spiceServiceListener) {
        this.spiceServiceListenerList.add(spiceServiceListener);
        if (this.messageQueue == null) {
            Ln.d("Message Queue starting", new Object[0]);
            this.messageQueue = new Handler(Looper.getMainLooper());
        }
    }

    protected void createMessageQueue() {
        this.messageQueue = new Handler(Looper.getMainLooper());
    }

    int getRequestToObserverMapCount() {
        return this.spiceServiceListenerList.size();
    }

    public void notifyObserversOfRequestAdded(CachedSpiceRequest<?> cachedSpiceRequest, Set<RequestListener<?>> set) {
        SpiceServiceListener.RequestProcessingContext requestProcessingContext = new SpiceServiceListener.RequestProcessingContext();
        requestProcessingContext.setExecutionThread(Thread.currentThread());
        requestProcessingContext.setRequestListeners(set);
        this.post(new RequestAddedNotifier(cachedSpiceRequest, this.spiceServiceListenerList, requestProcessingContext));
    }

    public void notifyObserversOfRequestAggregated(CachedSpiceRequest<?> cachedSpiceRequest, Set<RequestListener<?>> set) {
        SpiceServiceListener.RequestProcessingContext requestProcessingContext = new SpiceServiceListener.RequestProcessingContext();
        requestProcessingContext.setExecutionThread(Thread.currentThread());
        requestProcessingContext.setRequestListeners(set);
        this.post(new RequestAggregatedNotifier(cachedSpiceRequest, this.spiceServiceListenerList, requestProcessingContext));
    }

    public void notifyObserversOfRequestCancellation(CachedSpiceRequest<?> cachedSpiceRequest) {
        SpiceServiceListener.RequestProcessingContext requestProcessingContext = new SpiceServiceListener.RequestProcessingContext();
        requestProcessingContext.setExecutionThread(Thread.currentThread());
        this.post(new RequestCancelledNotifier(cachedSpiceRequest, this.spiceServiceListenerList, requestProcessingContext));
    }

    public void notifyObserversOfRequestFailure(CachedSpiceRequest<?> cachedSpiceRequest) {
        SpiceServiceListener.RequestProcessingContext requestProcessingContext = new SpiceServiceListener.RequestProcessingContext();
        requestProcessingContext.setExecutionThread(Thread.currentThread());
        this.post(new RequestFailedNotifier(cachedSpiceRequest, this.spiceServiceListenerList, requestProcessingContext));
    }

    public void notifyObserversOfRequestNotFound(CachedSpiceRequest<?> cachedSpiceRequest) {
        SpiceServiceListener.RequestProcessingContext requestProcessingContext = new SpiceServiceListener.RequestProcessingContext();
        requestProcessingContext.setExecutionThread(Thread.currentThread());
        this.post(new RequestNotFoundNotifier(cachedSpiceRequest, this.spiceServiceListenerList, requestProcessingContext));
    }

    public void notifyObserversOfRequestProcessed(CachedSpiceRequest<?> cachedSpiceRequest, Set<RequestListener<?>> set) {
        SpiceServiceListener.RequestProcessingContext requestProcessingContext = new SpiceServiceListener.RequestProcessingContext();
        requestProcessingContext.setExecutionThread(Thread.currentThread());
        requestProcessingContext.setRequestListeners(set);
        this.post(new RequestProcessedNotifier(cachedSpiceRequest, this.spiceServiceListenerList, requestProcessingContext));
    }

    public void notifyObserversOfRequestProgress(CachedSpiceRequest<?> cachedSpiceRequest, RequestProgress requestProgress) {
        SpiceServiceListener.RequestProcessingContext requestProcessingContext = new SpiceServiceListener.RequestProcessingContext();
        requestProcessingContext.setExecutionThread(Thread.currentThread());
        requestProcessingContext.setRequestProgress(requestProgress);
        this.post(new RequestProgressNotifier(cachedSpiceRequest, this.spiceServiceListenerList, requestProcessingContext));
    }

    public <T> void notifyObserversOfRequestSuccess(CachedSpiceRequest<T> cachedSpiceRequest) {
        SpiceServiceListener.RequestProcessingContext requestProcessingContext = new SpiceServiceListener.RequestProcessingContext();
        requestProcessingContext.setExecutionThread(Thread.currentThread());
        this.post(new RequestSucceededNotifier<T>(cachedSpiceRequest, this.spiceServiceListenerList, requestProcessingContext));
    }

    protected void onStopped() {
    }

    protected void post(Runnable runnable) {
        Ln.d("Message queue is " + this.messageQueue, new Object[0]);
        if (this.messageQueue == null) {
            return;
        }
        this.messageQueue.postAtTime(runnable, SystemClock.uptimeMillis());
    }

    public void removeSpiceServiceListener(SpiceServiceListener spiceServiceListener) {
        this.spiceServiceListenerList.remove(spiceServiceListener);
    }

    private static class RequestAddedNotifier
    implements Runnable {
        private CachedSpiceRequest<?> request;
        private SpiceServiceListener.RequestProcessingContext requestProcessingContext;
        private List<SpiceServiceListener> spiceServiceListenerList;

        public RequestAddedNotifier(CachedSpiceRequest<?> cachedSpiceRequest, List<SpiceServiceListener> list, SpiceServiceListener.RequestProcessingContext requestProcessingContext) {
            this.spiceServiceListenerList = list;
            this.request = cachedSpiceRequest;
            this.requestProcessingContext = requestProcessingContext;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Object[] objectArray = new Object[]{this.request};
            Ln.d("Processing request added: %s", objectArray);
            List<SpiceServiceListener> list = this.spiceServiceListenerList;
            synchronized (list) {
                Iterator<SpiceServiceListener> iterator = this.spiceServiceListenerList.iterator();
                while (iterator.hasNext()) {
                    iterator.next().onRequestAdded(this.request, this.requestProcessingContext);
                }
                return;
            }
        }
    }

    private static class RequestAggregatedNotifier
    implements Runnable {
        private CachedSpiceRequest<?> request;
        private SpiceServiceListener.RequestProcessingContext requestProcessingContext;
        private List<SpiceServiceListener> spiceServiceListenerList;

        public RequestAggregatedNotifier(CachedSpiceRequest<?> cachedSpiceRequest, List<SpiceServiceListener> list, SpiceServiceListener.RequestProcessingContext requestProcessingContext) {
            this.spiceServiceListenerList = list;
            this.request = cachedSpiceRequest;
            this.requestProcessingContext = requestProcessingContext;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Object[] objectArray = new Object[]{this.request};
            Ln.d("Processing request added: %s", objectArray);
            List<SpiceServiceListener> list = this.spiceServiceListenerList;
            synchronized (list) {
                Iterator<SpiceServiceListener> iterator = this.spiceServiceListenerList.iterator();
                while (iterator.hasNext()) {
                    iterator.next().onRequestAggregated(this.request, this.requestProcessingContext);
                }
                return;
            }
        }
    }

    private static class RequestCancelledNotifier
    implements Runnable {
        private CachedSpiceRequest<?> request;
        private SpiceServiceListener.RequestProcessingContext requestProcessingContext;
        private List<SpiceServiceListener> spiceServiceListenerList;

        public RequestCancelledNotifier(CachedSpiceRequest<?> cachedSpiceRequest, List<SpiceServiceListener> list, SpiceServiceListener.RequestProcessingContext requestProcessingContext) {
            this.spiceServiceListenerList = list;
            this.request = cachedSpiceRequest;
            this.requestProcessingContext = requestProcessingContext;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Object[] objectArray = new Object[]{this.request};
            Ln.d("Processing request cancelled: %s", objectArray);
            List<SpiceServiceListener> list = this.spiceServiceListenerList;
            synchronized (list) {
                Iterator<SpiceServiceListener> iterator = this.spiceServiceListenerList.iterator();
                while (iterator.hasNext()) {
                    iterator.next().onRequestCancelled(this.request, this.requestProcessingContext);
                }
                return;
            }
        }
    }

    private static class RequestFailedNotifier
    implements Runnable {
        private CachedSpiceRequest<?> request;
        private SpiceServiceListener.RequestProcessingContext requestProcessingContext;
        private List<SpiceServiceListener> spiceServiceListenerList;

        public RequestFailedNotifier(CachedSpiceRequest<?> cachedSpiceRequest, List<SpiceServiceListener> list, SpiceServiceListener.RequestProcessingContext requestProcessingContext) {
            this.spiceServiceListenerList = list;
            this.request = cachedSpiceRequest;
            this.requestProcessingContext = requestProcessingContext;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            List<SpiceServiceListener> list = this.spiceServiceListenerList;
            synchronized (list) {
                Iterator<SpiceServiceListener> iterator = this.spiceServiceListenerList.iterator();
                while (iterator.hasNext()) {
                    iterator.next().onRequestFailed(this.request, this.requestProcessingContext);
                }
                return;
            }
        }
    }

    private static class RequestNotFoundNotifier
    implements Runnable {
        private CachedSpiceRequest<?> request;
        private SpiceServiceListener.RequestProcessingContext requestProcessingContext;
        private List<SpiceServiceListener> spiceServiceListenerList;

        public RequestNotFoundNotifier(CachedSpiceRequest<?> cachedSpiceRequest, List<SpiceServiceListener> list, SpiceServiceListener.RequestProcessingContext requestProcessingContext) {
            this.spiceServiceListenerList = list;
            this.request = cachedSpiceRequest;
            this.requestProcessingContext = requestProcessingContext;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Object[] objectArray = new Object[]{this.request};
            Ln.d("Processing request not found: %s", objectArray);
            List<SpiceServiceListener> list = this.spiceServiceListenerList;
            synchronized (list) {
                Iterator<SpiceServiceListener> iterator = this.spiceServiceListenerList.iterator();
                while (iterator.hasNext()) {
                    iterator.next().onRequestNotFound(this.request, this.requestProcessingContext);
                }
                return;
            }
        }
    }

    private static class RequestProcessedNotifier
    implements Runnable {
        private CachedSpiceRequest<?> request;
        private SpiceServiceListener.RequestProcessingContext requestProcessingContext;
        private List<SpiceServiceListener> spiceServiceListenerList;

        public RequestProcessedNotifier(CachedSpiceRequest<?> cachedSpiceRequest, List<SpiceServiceListener> list, SpiceServiceListener.RequestProcessingContext requestProcessingContext) {
            this.spiceServiceListenerList = list;
            this.request = cachedSpiceRequest;
            this.requestProcessingContext = requestProcessingContext;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            List<SpiceServiceListener> list = this.spiceServiceListenerList;
            synchronized (list) {
                Iterator<SpiceServiceListener> iterator = this.spiceServiceListenerList.iterator();
                while (iterator.hasNext()) {
                    iterator.next().onRequestProcessed(this.request, this.requestProcessingContext);
                }
                return;
            }
        }
    }

    private static class RequestProgressNotifier
    implements Runnable {
        private CachedSpiceRequest<?> request;
        private SpiceServiceListener.RequestProcessingContext requestProcessingContext;
        private List<SpiceServiceListener> spiceServiceListenerList;

        public RequestProgressNotifier(CachedSpiceRequest<?> cachedSpiceRequest, List<SpiceServiceListener> list, SpiceServiceListener.RequestProcessingContext requestProcessingContext) {
            this.spiceServiceListenerList = list;
            this.request = cachedSpiceRequest;
            this.requestProcessingContext = requestProcessingContext;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            List<SpiceServiceListener> list = this.spiceServiceListenerList;
            synchronized (list) {
                Iterator<SpiceServiceListener> iterator = this.spiceServiceListenerList.iterator();
                while (iterator.hasNext()) {
                    iterator.next().onRequestProgressUpdated(this.request, this.requestProcessingContext);
                }
                return;
            }
        }
    }

    private static class RequestSucceededNotifier<T>
    implements Runnable {
        private CachedSpiceRequest<T> request;
        private SpiceServiceListener.RequestProcessingContext requestProcessingContext;
        private List<SpiceServiceListener> spiceServiceListenerList;

        public RequestSucceededNotifier(CachedSpiceRequest<T> cachedSpiceRequest, List<SpiceServiceListener> list, SpiceServiceListener.RequestProcessingContext requestProcessingContext) {
            this.spiceServiceListenerList = list;
            this.request = cachedSpiceRequest;
            this.requestProcessingContext = requestProcessingContext;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            List<SpiceServiceListener> list = this.spiceServiceListenerList;
            synchronized (list) {
                Iterator<SpiceServiceListener> iterator = this.spiceServiceListenerList.iterator();
                while (iterator.hasNext()) {
                    iterator.next().onRequestSucceeded(this.request, this.requestProcessingContext);
                }
                return;
            }
        }
    }
}

