/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.request.notifier;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.octo.android.robospice.exception.RequestCancelledException;
import com.octo.android.robospice.persistence.exception.SpiceException;
import com.octo.android.robospice.request.CachedSpiceRequest;
import com.octo.android.robospice.request.listener.PendingRequestListener;
import com.octo.android.robospice.request.listener.RequestListener;
import com.octo.android.robospice.request.listener.RequestProgress;
import com.octo.android.robospice.request.listener.RequestProgressListener;
import com.octo.android.robospice.request.notifier.RequestListenerNotifier;
import java.util.Iterator;
import java.util.Set;
import roboguice.util.temp.Ln;

public class DefaultRequestListenerNotifier
implements RequestListenerNotifier {
    private final Handler handlerResponse = new Handler(Looper.getMainLooper());

    private void post(Runnable runnable, Object object) {
        this.handlerResponse.postAtTime(runnable, object, SystemClock.uptimeMillis());
    }

    @Override
    public <T> void clearNotificationsForRequest(CachedSpiceRequest<T> cachedSpiceRequest, Set<RequestListener<?>> set) {
        this.handlerResponse.removeCallbacksAndMessages(cachedSpiceRequest.getRequestCacheKey());
    }

    @Override
    public <T> void notifyListenersOfRequestAdded(CachedSpiceRequest<T> cachedSpiceRequest, Set<RequestListener<?>> set) {
    }

    @Override
    public <T> void notifyListenersOfRequestAggregated(CachedSpiceRequest<T> cachedSpiceRequest, Set<RequestListener<?>> set) {
    }

    @Override
    public <T> void notifyListenersOfRequestCancellation(CachedSpiceRequest<T> cachedSpiceRequest, Set<RequestListener<?>> set) {
        this.post(new ResultRunnable<RequestCancelledException>(set, new RequestCancelledException("Request has been cancelled explicitely.")), cachedSpiceRequest.getRequestCacheKey());
    }

    @Override
    public <T> void notifyListenersOfRequestFailure(CachedSpiceRequest<T> cachedSpiceRequest, SpiceException spiceException, Set<RequestListener<?>> set) {
        this.post(new ResultRunnable<SpiceException>(set, spiceException), cachedSpiceRequest.getRequestCacheKey());
    }

    @Override
    public <T> void notifyListenersOfRequestNotFound(CachedSpiceRequest<T> cachedSpiceRequest, Set<RequestListener<?>> set) {
        this.post(new NotFoundRunnable(set), cachedSpiceRequest.getRequestCacheKey());
    }

    @Override
    public <T> void notifyListenersOfRequestProgress(CachedSpiceRequest<T> cachedSpiceRequest, Set<RequestListener<?>> set, RequestProgress requestProgress) {
        this.post(new ProgressRunnable(set, requestProgress), cachedSpiceRequest.getRequestCacheKey());
    }

    @Override
    public <T> void notifyListenersOfRequestSuccess(CachedSpiceRequest<T> cachedSpiceRequest, T t2, Set<RequestListener<?>> set) {
        this.post(new ResultRunnable<T>(set, t2), cachedSpiceRequest.getRequestCacheKey());
    }

    private static class NotFoundRunnable
    implements Runnable {
        private final Set<RequestListener<?>> listeners;

        public NotFoundRunnable(Set<RequestListener<?>> set) {
            this.listeners = set;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (this.listeners == null) {
                return;
            }
            Ln.v("Notifying " + this.listeners.size() + " listeners of request not found", new Object[0]);
            Set<RequestListener<?>> set = this.listeners;
            synchronized (set) {
                Iterator<RequestListener<?>> iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    RequestListener<?> requestListener = iterator.next();
                    if (requestListener == null || !(requestListener instanceof PendingRequestListener)) continue;
                    Object[] objectArray = new Object[]{requestListener.getClass().getSimpleName()};
                    Ln.v("Notifying %s", objectArray);
                    ((PendingRequestListener)requestListener).onRequestNotFound();
                }
                return;
            }
        }
    }

    private static class ProgressRunnable
    implements Runnable {
        private final Set<RequestListener<?>> listeners;
        private final RequestProgress progress;

        public ProgressRunnable(Set<RequestListener<?>> set, RequestProgress requestProgress) {
            this.progress = requestProgress;
            this.listeners = set;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (this.listeners == null) {
                return;
            }
            Ln.v("Notifying " + this.listeners.size() + " listeners of progress " + this.progress, new Object[0]);
            Set<RequestListener<?>> set = this.listeners;
            synchronized (set) {
                Iterator<RequestListener<?>> iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    RequestListener<?> requestListener = iterator.next();
                    if (requestListener == null || !(requestListener instanceof RequestProgressListener)) continue;
                    Object[] objectArray = new Object[]{requestListener.getClass().getSimpleName()};
                    Ln.v("Notifying %s", objectArray);
                    ((RequestProgressListener)((Object)requestListener)).onRequestProgressUpdate(this.progress);
                }
                return;
            }
        }
    }

    private static class ResultRunnable<T>
    implements Runnable {
        private final Set<RequestListener<?>> listeners;
        private T result;
        private SpiceException spiceException;

        public ResultRunnable(Set<RequestListener<?>> set, SpiceException spiceException) {
            this.spiceException = spiceException;
            this.listeners = set;
        }

        public ResultRunnable(Set<RequestListener<?>> set, T t2) {
            this.result = t2;
            this.listeners = set;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (this.listeners == null) {
                return;
            }
            String string2 = this.spiceException == null ? "success" : "failure";
            Ln.v("Notifying " + this.listeners.size() + " listeners of request " + string2, new Object[0]);
            Set<RequestListener<?>> set = this.listeners;
            synchronized (set) {
                Iterator<RequestListener<?>> iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    RequestListener<?> requestListener = iterator.next();
                    if (requestListener == null) continue;
                    Object[] objectArray = new Object[]{requestListener.getClass().getSimpleName()};
                    Ln.v("Notifying %s", objectArray);
                    if (this.spiceException == null) {
                        requestListener.onRequestSuccess(this.result);
                        continue;
                    }
                    requestListener.onRequestFailure(this.spiceException);
                }
                return;
            }
        }
    }
}

