/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.request;

import android.content.Context;
import com.octo.android.robospice.request.listener.RequestCancellationListener;
import com.octo.android.robospice.request.listener.RequestProgress;
import com.octo.android.robospice.request.listener.RequestProgressListener;
import com.octo.android.robospice.request.listener.RequestStatus;
import com.octo.android.robospice.retry.DefaultRetryPolicy;
import com.octo.android.robospice.retry.RetryPolicy;
import java.lang.reflect.Modifier;
import java.util.concurrent.Future;

public abstract class SpiceRequest<RESULT>
implements Comparable<SpiceRequest<RESULT>> {
    public static final int PRIORITY_HIGH = 0;
    public static final int PRIORITY_LOW = 100;
    public static final int PRIORITY_NORMAL = 50;
    private Future<?> future;
    private boolean isAggregatable = true;
    private boolean isCanceled = false;
    private int priority = 50;
    private RequestProgress progress = new RequestProgress(RequestStatus.PENDING);
    private RequestCancellationListener requestCancellationListener;
    private RequestProgressListener requestProgressListener;
    private final Class<RESULT> resultType;
    private RetryPolicy retryPolicy = new DefaultRetryPolicy();

    public SpiceRequest(Class<RESULT> clazz) {
        this.checkInnerClassDeclarationToPreventMemoryLeak();
        this.resultType = clazz;
    }

    private void checkInnerClassDeclarationToPreventMemoryLeak() {
        if (this.getClass().isMemberClass() && Context.class.isAssignableFrom(this.getClass().getDeclaringClass()) && !Modifier.isStatic(this.getClass().getModifiers())) {
            throw new IllegalArgumentException("Requests must be either non-inner classes or a static inner member class of Context : " + this.getClass());
        }
    }

    public void cancel() {
        this.isCanceled = true;
        if (this.future != null) {
            this.future.cancel(true);
        }
        if (this.requestCancellationListener != null) {
            this.requestCancellationListener.onRequestCancelled();
        }
    }

    @Override
    public int compareTo(SpiceRequest<RESULT> spiceRequest) {
        if (this == spiceRequest) {
            return 0;
        }
        return this.priority - spiceRequest.priority;
    }

    public int getPriority() {
        return this.priority;
    }

    RequestProgress getProgress() {
        return this.progress;
    }

    public Class<RESULT> getResultType() {
        return this.resultType;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public boolean isAggregatable() {
        return this.isAggregatable;
    }

    public boolean isCancelled() {
        return this.isCanceled;
    }

    public abstract RESULT loadDataFromNetwork() throws Exception;

    protected void publishProgress() {
        if (this.requestProgressListener != null) {
            this.requestProgressListener.onRequestProgressUpdate(this.progress);
        }
    }

    protected void publishProgress(float f2) {
        this.progress.setStatus(RequestStatus.LOADING_FROM_NETWORK);
        this.progress.setProgress(f2);
        this.publishProgress();
    }

    public void setAggregatable(boolean bl2) {
        this.isAggregatable = bl2;
    }

    protected void setFuture(Future<?> future) {
        this.future = future;
    }

    public void setPriority(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Priority must be positive.");
        }
        this.priority = n2;
    }

    public void setRequestCancellationListener(RequestCancellationListener requestCancellationListener) {
        this.requestCancellationListener = requestCancellationListener;
    }

    protected void setRequestProgressListener(RequestProgressListener requestProgressListener) {
        this.requestProgressListener = requestProgressListener;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    void setStatus(RequestStatus requestStatus) {
        this.progress = new RequestProgress(requestStatus);
        this.publishProgress();
    }
}

