/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.request;

import com.octo.android.robospice.persistence.exception.SpiceException;
import com.octo.android.robospice.request.CachedSpiceRequest;
import com.octo.android.robospice.request.RequestProcessorListener;
import com.octo.android.robospice.request.listener.RequestListener;
import com.octo.android.robospice.request.listener.RequestProgress;
import com.octo.android.robospice.request.listener.RequestProgressListener;
import com.octo.android.robospice.request.listener.RequestStatus;
import com.octo.android.robospice.request.listener.SpiceServiceListener;
import com.octo.android.robospice.request.notifier.RequestListenerNotifier;
import com.octo.android.robospice.request.notifier.SpiceServiceListenerNotifier;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import roboguice.util.temp.Ln;

public class RequestProgressManager {
    private Map<CachedSpiceRequest<?>, Set<RequestListener<?>>> mapRequestToRequestListener;
    private final RequestListenerNotifier requestListenerNotifier;
    private final RequestProcessorListener requestProcessorListener;
    private final SpiceServiceListenerNotifier spiceServiceListenerNotifier;

    public RequestProgressManager(RequestProcessorListener requestProcessorListener, RequestListenerNotifier requestListenerNotifier, SpiceServiceListenerNotifier spiceServiceListenerNotifier) {
        this.requestProcessorListener = requestProcessorListener;
        this.requestListenerNotifier = requestListenerNotifier;
        this.spiceServiceListenerNotifier = spiceServiceListenerNotifier;
    }

    public void addSpiceServiceListener(SpiceServiceListener spiceServiceListener) {
        this.spiceServiceListenerNotifier.addSpiceServiceListener(spiceServiceListener);
    }

    protected void checkAllRequestComplete() {
        if (this.mapRequestToRequestListener.isEmpty()) {
            Ln.d("Sending all request complete.", new Object[0]);
            this.requestProcessorListener.allRequestComplete();
        }
    }

    public <T> RequestProgressListener createProgressListener(final CachedSpiceRequest<T> cachedSpiceRequest) {
        return new RequestProgressListener(){

            @Override
            public void onRequestProgressUpdate(RequestProgress requestProgress) {
                Set set = (Set)RequestProgressManager.this.mapRequestToRequestListener.get(cachedSpiceRequest);
                RequestProgressManager.this.notifyListenersOfRequestProgress(cachedSpiceRequest, set, requestProgress);
            }
        };
    }

    public void dontNotifyRequestListenersForRequest(CachedSpiceRequest<?> cachedSpiceRequest, Collection<RequestListener<?>> collection) {
        Set<RequestListener<RequestListener<?>>> set = this.mapRequestToRequestListener.get(cachedSpiceRequest);
        this.requestListenerNotifier.clearNotificationsForRequest(cachedSpiceRequest, set);
        if (set != null && collection != null) {
            Ln.d("Removing listeners of request : " + cachedSpiceRequest.toString() + " : " + set.size(), new Object[0]);
            set.removeAll(collection);
        }
    }

    public int getPendingRequestCount() {
        return this.mapRequestToRequestListener.keySet().size();
    }

    public <T> void notifyListenersOfRequestAdded(CachedSpiceRequest<T> cachedSpiceRequest, Set<RequestListener<?>> set) {
        Ln.d("Request was added to queue.", new Object[0]);
        this.spiceServiceListenerNotifier.notifyObserversOfRequestAdded(cachedSpiceRequest, set);
        this.requestListenerNotifier.notifyListenersOfRequestAdded(cachedSpiceRequest, set);
        this.notifyListenersOfRequestProgress(cachedSpiceRequest, set, cachedSpiceRequest.getProgress());
    }

    public <T> void notifyListenersOfRequestAggregated(CachedSpiceRequest<T> cachedSpiceRequest, Set<RequestListener<?>> set) {
        Ln.d("Request was aggregated in queue.", new Object[0]);
        this.spiceServiceListenerNotifier.notifyObserversOfRequestAggregated(cachedSpiceRequest, set);
        this.requestListenerNotifier.notifyListenersOfRequestAggregated(cachedSpiceRequest, set);
        this.notifyListenersOfRequestProgress(cachedSpiceRequest, set, cachedSpiceRequest.getProgress());
    }

    public void notifyListenersOfRequestCancellation(CachedSpiceRequest<?> cachedSpiceRequest) {
        Ln.d("Not calling network request : " + cachedSpiceRequest + " as it is cancelled. ", new Object[0]);
        Set<RequestListener<?>> set = this.mapRequestToRequestListener.get(cachedSpiceRequest);
        this.notifyListenersOfRequestProgress(cachedSpiceRequest, set, RequestStatus.COMPLETE);
        this.spiceServiceListenerNotifier.notifyObserversOfRequestCancellation(cachedSpiceRequest);
        this.requestListenerNotifier.notifyListenersOfRequestCancellation(cachedSpiceRequest, set);
        this.notifyOfRequestProcessed(cachedSpiceRequest, set);
    }

    public <T> void notifyListenersOfRequestFailure(CachedSpiceRequest<T> cachedSpiceRequest, SpiceException spiceException) {
        Set<RequestListener<?>> set = this.mapRequestToRequestListener.get(cachedSpiceRequest);
        this.notifyListenersOfRequestProgress(cachedSpiceRequest, set, RequestStatus.COMPLETE);
        this.spiceServiceListenerNotifier.notifyObserversOfRequestFailure(cachedSpiceRequest);
        this.requestListenerNotifier.notifyListenersOfRequestFailure(cachedSpiceRequest, spiceException, set);
        this.notifyOfRequestProcessed(cachedSpiceRequest, set);
    }

    public void notifyListenersOfRequestNotFound(CachedSpiceRequest<?> cachedSpiceRequest, Set<RequestListener<?>> set) {
        Ln.d("Request was *NOT* found when adding request listeners to existing requests.", new Object[0]);
        this.spiceServiceListenerNotifier.notifyObserversOfRequestNotFound(cachedSpiceRequest);
        this.requestListenerNotifier.notifyListenersOfRequestNotFound(cachedSpiceRequest, set);
    }

    public <T> void notifyListenersOfRequestProgress(CachedSpiceRequest<?> cachedSpiceRequest, Set<RequestListener<?>> set, RequestProgress requestProgress) {
        Object[] objectArray = new Object[]{requestProgress.getStatus()};
        Ln.d("Sending progress %s", objectArray);
        this.spiceServiceListenerNotifier.notifyObserversOfRequestProgress(cachedSpiceRequest, requestProgress);
        this.requestListenerNotifier.notifyListenersOfRequestProgress(cachedSpiceRequest, set, requestProgress);
        this.checkAllRequestComplete();
    }

    protected <T> void notifyListenersOfRequestProgress(CachedSpiceRequest<?> cachedSpiceRequest, Set<RequestListener<?>> set, RequestStatus requestStatus) {
        this.notifyListenersOfRequestProgress(cachedSpiceRequest, set, new RequestProgress(requestStatus));
        this.checkAllRequestComplete();
    }

    public <T> void notifyListenersOfRequestSuccess(CachedSpiceRequest<T> cachedSpiceRequest, T t2) {
        Set<RequestListener<?>> set = this.mapRequestToRequestListener.get(cachedSpiceRequest);
        this.notifyListenersOfRequestProgress(cachedSpiceRequest, set, RequestStatus.COMPLETE);
        this.spiceServiceListenerNotifier.notifyObserversOfRequestSuccess(cachedSpiceRequest);
        this.requestListenerNotifier.notifyListenersOfRequestSuccess(cachedSpiceRequest, t2, set);
        this.notifyOfRequestProcessed(cachedSpiceRequest, set);
    }

    public <T> void notifyListenersOfRequestSuccessButDontCompleteRequest(CachedSpiceRequest<T> cachedSpiceRequest, T t2) {
        Set<RequestListener<?>> set = this.mapRequestToRequestListener.get(cachedSpiceRequest);
        this.spiceServiceListenerNotifier.notifyObserversOfRequestSuccess(cachedSpiceRequest);
        this.requestListenerNotifier.notifyListenersOfRequestSuccess(cachedSpiceRequest, t2, set);
    }

    public void notifyOfRequestProcessed(CachedSpiceRequest<?> cachedSpiceRequest, Set<RequestListener<?>> set) {
        Object[] objectArray = new Object[]{cachedSpiceRequest, this.mapRequestToRequestListener.size()};
        Ln.v("Removing %s  size is %d", objectArray);
        this.mapRequestToRequestListener.remove(cachedSpiceRequest);
        this.checkAllRequestComplete();
        this.spiceServiceListenerNotifier.notifyObserversOfRequestProcessed(cachedSpiceRequest, set);
    }

    public void removeSpiceServiceListener(SpiceServiceListener spiceServiceListener) {
        this.spiceServiceListenerNotifier.removeSpiceServiceListener(spiceServiceListener);
    }

    public void setMapRequestToRequestListener(Map<CachedSpiceRequest<?>, Set<RequestListener<?>>> map) {
        this.mapRequestToRequestListener = map;
    }
}

