/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.request;

import com.octo.android.robospice.persistence.CacheManager;
import com.octo.android.robospice.request.CachedSpiceRequest;
import com.octo.android.robospice.request.RequestProgressManager;
import com.octo.android.robospice.request.RequestRunner;
import com.octo.android.robospice.request.listener.RequestCancellationListener;
import com.octo.android.robospice.request.listener.RequestListener;
import com.octo.android.robospice.request.listener.SpiceServiceListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import roboguice.util.temp.Ln;

public class RequestProcessor {
    private final CacheManager cacheManager;
    private boolean isStopped;
    private final Map<CachedSpiceRequest<?>, Set<RequestListener<?>>> mapRequestToRequestListener = Collections.synchronizedMap(new LinkedHashMap());
    private final RequestProgressManager requestProgressManager;
    private final RequestRunner requestRunner;

    public RequestProcessor(CacheManager cacheManager, RequestProgressManager requestProgressManager, RequestRunner requestRunner) {
        this.cacheManager = cacheManager;
        this.requestProgressManager = requestProgressManager;
        requestProgressManager.setMapRequestToRequestListener(this.mapRequestToRequestListener);
        this.requestRunner = requestRunner;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addRequest(final CachedSpiceRequest<?> cachedSpiceRequest, Set<RequestListener<?>> set) {
        boolean bl2;
        Set<RequestListener<Object>> set2;
        if (this.isStopped) {
            Ln.d("Dropping request : " + cachedSpiceRequest + " as processor is stopped.", new Object[0]);
            return;
        }
        Ln.d("Adding request to queue " + this.hashCode() + ": " + cachedSpiceRequest + " size is " + this.mapRequestToRequestListener.size(), new Object[0]);
        if (cachedSpiceRequest.isCancelled()) {
            Map<CachedSpiceRequest<?>, Set<RequestListener<?>>> map = this.mapRequestToRequestListener;
            synchronized (map) {
                for (CachedSpiceRequest<?> cachedSpiceRequest2 : this.mapRequestToRequestListener.keySet()) {
                    if (!cachedSpiceRequest2.equals(cachedSpiceRequest)) continue;
                    cachedSpiceRequest2.cancel();
                    this.requestProgressManager.notifyListenersOfRequestCancellation(cachedSpiceRequest);
                    return;
                }
            }
        }
        if ((set2 = this.mapRequestToRequestListener.get(cachedSpiceRequest)) == null) {
            boolean bl3 = cachedSpiceRequest.isProcessable();
            bl2 = false;
            if (bl3) {
                Object[] objectArray = new Object[]{cachedSpiceRequest.getResultType(), cachedSpiceRequest.getRequestCacheKey()};
                Ln.d("Adding entry for type %s and cacheKey %s.", objectArray);
                set2 = Collections.synchronizedSet(new HashSet());
                this.mapRequestToRequestListener.put(cachedSpiceRequest, set2);
            }
        } else {
            Object[] objectArray = new Object[]{cachedSpiceRequest.getResultType(), cachedSpiceRequest.getRequestCacheKey()};
            Ln.d("Request for type %s and cacheKey %s already exists.", objectArray);
            bl2 = true;
        }
        if (set != null && set2 != null) {
            set2.addAll(set);
        }
        if (bl2) {
            this.requestProgressManager.notifyListenersOfRequestAggregated(cachedSpiceRequest, set);
            return;
        }
        if (cachedSpiceRequest.isProcessable()) {
            this.requestProgressManager.notifyListenersOfRequestAdded(cachedSpiceRequest, set);
            cachedSpiceRequest.setRequestCancellationListener(new RequestCancellationListener(){

                @Override
                public void onRequestCancelled() {
                    RequestProcessor.this.requestProgressManager.notifyListenersOfRequestCancellation(cachedSpiceRequest);
                    RequestProcessor.this.mapRequestToRequestListener.remove(cachedSpiceRequest);
                }
            });
            if (cachedSpiceRequest.isCancelled()) {
                this.requestProgressManager.notifyListenersOfRequestCancellation(cachedSpiceRequest);
                this.mapRequestToRequestListener.remove(cachedSpiceRequest);
                return;
            }
        } else {
            if (set2 == null) {
                this.requestProgressManager.notifyListenersOfRequestNotFound(cachedSpiceRequest, set);
            }
            this.requestProgressManager.notifyOfRequestProcessed(cachedSpiceRequest, set);
            return;
        }
        this.requestRunner.executeRequest(cachedSpiceRequest);
    }

    public void addSpiceServiceListener(SpiceServiceListener spiceServiceListener) {
        this.requestProgressManager.addSpiceServiceListener(spiceServiceListener);
    }

    public void dontNotifyRequestListenersForRequest(CachedSpiceRequest<?> cachedSpiceRequest, Collection<RequestListener<?>> collection) {
        this.requestProgressManager.dontNotifyRequestListenersForRequest(cachedSpiceRequest, collection);
    }

    public boolean isFailOnCacheError() {
        return this.requestRunner.isFailOnCacheError();
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void removeAllDataFromCache() {
        this.cacheManager.removeAllDataFromCache();
    }

    public void removeAllDataFromCache(Class<?> clazz) {
        this.cacheManager.removeAllDataFromCache(clazz);
    }

    public boolean removeDataFromCache(Class<?> clazz, Object object) {
        return this.cacheManager.removeDataFromCache(clazz, object);
    }

    public void removeSpiceServiceListener(SpiceServiceListener spiceServiceListener) {
        this.requestProgressManager.removeSpiceServiceListener(spiceServiceListener);
    }

    public void setFailOnCacheError(boolean bl2) {
        this.requestRunner.setFailOnCacheError(bl2);
    }

    public void shouldStop() {
        this.isStopped = true;
        this.requestRunner.shouldStop();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" : ");
        stringBuilder.append(" request count= ");
        stringBuilder.append(this.mapRequestToRequestListener.keySet().size());
        stringBuilder.append(", listeners per requests = [");
        for (Map.Entry<CachedSpiceRequest<?>, Set<RequestListener<?>>> entry : this.mapRequestToRequestListener.entrySet()) {
            stringBuilder.append(entry.getKey().getClass().getName());
            stringBuilder.append(":");
            stringBuilder.append(entry.getKey());
            stringBuilder.append(" --> ");
            if (entry.getValue() == null) {
                stringBuilder.append(entry.getValue());
                continue;
            }
            stringBuilder.append(entry.getValue().size());
        }
        stringBuilder.append(']');
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

