/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.request;

import android.content.Context;
import com.octo.android.robospice.exception.NetworkException;
import com.octo.android.robospice.exception.NoNetworkException;
import com.octo.android.robospice.networkstate.NetworkStateChecker;
import com.octo.android.robospice.persistence.CacheManager;
import com.octo.android.robospice.persistence.exception.CacheCreationException;
import com.octo.android.robospice.persistence.exception.CacheLoadingException;
import com.octo.android.robospice.persistence.exception.CacheSavingException;
import com.octo.android.robospice.persistence.exception.SpiceException;
import com.octo.android.robospice.priority.PriorityRunnable;
import com.octo.android.robospice.request.CachedSpiceRequest;
import com.octo.android.robospice.request.RequestProgressManager;
import com.octo.android.robospice.request.RequestRunner;
import com.octo.android.robospice.request.listener.RequestStatus;
import java.util.concurrent.ExecutorService;
import roboguice.util.temp.Ln;

public class DefaultRequestRunner
implements RequestRunner {
    private final Context applicationContext;
    private final CacheManager cacheManager;
    private ExecutorService executorService = null;
    private boolean failOnCacheError;
    private boolean isStopped;
    private final NetworkStateChecker networkStateChecker;
    private final RequestProgressManager requestProgressManager;

    public DefaultRequestRunner(Context context, CacheManager cacheManager, ExecutorService executorService, RequestProgressManager requestProgressManager, NetworkStateChecker networkStateChecker) {
        this.applicationContext = context;
        this.cacheManager = cacheManager;
        this.networkStateChecker = networkStateChecker;
        this.executorService = executorService;
        this.requestProgressManager = requestProgressManager;
        this.networkStateChecker.checkPermissions(context);
    }

    private static String getTimeString(long l2) {
        Object[] objectArray = new Object[]{l2};
        return String.format("%02d ms", objectArray);
    }

    private void handleRetry(final CachedSpiceRequest<?> cachedSpiceRequest, SpiceException spiceException) {
        if (cachedSpiceRequest.getRetryPolicy() != null) {
            cachedSpiceRequest.getRetryPolicy().retry(spiceException);
            if (cachedSpiceRequest.getRetryPolicy().getRetryCount() > 0) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(cachedSpiceRequest.getRetryPolicy().getDelayBeforeRetry());
                            DefaultRequestRunner.this.planRequestExecution(cachedSpiceRequest);
                            return;
                        }
                        catch (InterruptedException interruptedException) {
                            Ln.e(interruptedException, (Object)("Retry attempt failed for request " + cachedSpiceRequest), new Object[0]);
                            return;
                        }
                    }
                }).start();
                return;
            }
        }
        this.requestProgressManager.notifyListenersOfRequestFailure(cachedSpiceRequest, spiceException);
    }

    private <T> T loadDataFromCache(Class<T> clazz, Object object, long l2) throws CacheLoadingException, CacheCreationException {
        return this.cacheManager.loadDataFromCache(clazz, object, l2);
    }

    private static void printRequestProcessingDuration(long l2, CachedSpiceRequest<?> cachedSpiceRequest) {
        Object[] objectArray = new Object[]{DefaultRequestRunner.getTimeString(System.currentTimeMillis() - l2), cachedSpiceRequest.toString()};
        Ln.d("It tooks %s to process request %s.", objectArray);
    }

    private <T> T saveDataToCacheAndReturnData(T t2, Object object) throws CacheSavingException, CacheCreationException {
        return this.cacheManager.saveDataToCacheAndReturnData(t2, object);
    }

    @Override
    public void executeRequest(CachedSpiceRequest<?> cachedSpiceRequest) {
        if (this.isStopped) {
            Ln.d("Dropping request : " + cachedSpiceRequest + " as runner is stopped.", new Object[0]);
            return;
        }
        this.planRequestExecution(cachedSpiceRequest);
    }

    @Override
    public boolean isFailOnCacheError() {
        return this.failOnCacheError;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    protected void planRequestExecution(final CachedSpiceRequest<?> cachedSpiceRequest) {
        cachedSpiceRequest.setFuture(this.executorService.submit(new PriorityRunnable(){

            @Override
            public int getPriority() {
                return cachedSpiceRequest.getPriority();
            }

            @Override
            public void run() {
                try {
                    DefaultRequestRunner.this.processRequest(cachedSpiceRequest);
                    return;
                }
                catch (Throwable throwable) {
                    Object[] objectArray = new Object[]{cachedSpiceRequest.toString()};
                    Ln.d(throwable, (Object)"An unexpected error occurred when processsing request %s", objectArray);
                    return;
                }
                finally {
                    cachedSpiceRequest.setRequestCancellationListener(null);
                }
            }
        }));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> void processRequest(CachedSpiceRequest<T> var1_1) {
        block23: {
            block24: {
                block22: {
                    block21: {
                        block20: {
                            var2_2 = System.currentTimeMillis();
                            Ln.d("Processing request : " + var1_1, new Object[0]);
                            var1_1.setRequestProgressListener(this.requestProgressManager.createProgressListener(var1_1));
                            if (var1_1.getRequestCacheKey() != null && var1_1.getCacheDuration() != -1L) {
                                Ln.d("Loading request from cache : " + var1_1, new Object[0]);
                                var1_1.setStatus(RequestStatus.READING_FROM_CACHE);
                                var23_3 = this.loadDataFromCache(var1_1.getResultType(), var1_1.getRequestCacheKey(), var1_1.getCacheDuration());
                                if (var23_3 != null) {
                                    Ln.d("Request loaded from cache : " + var1_1 + " result=" + var23_3, new Object[0]);
                                    this.requestProgressManager.notifyListenersOfRequestSuccess(var1_1, var23_3);
                                    DefaultRequestRunner.printRequestProcessingDuration(var2_2, var1_1);
                                    return;
                                }
                                if (!var1_1.isAcceptingDirtyCache() || (var25_4 = this.loadDataFromCache(var1_1.getResultType(), var1_1.getRequestCacheKey(), 0L)) == null) break block20;
                                this.requestProgressManager.notifyListenersOfRequestSuccessButDontCompleteRequest(var1_1, var25_4);
                            }
                        }
lbl20:
                        // 2 sources

                        while (true) {
                            Ln.d("Cache content not available or expired or disabled", new Object[0]);
                            if (!this.networkStateChecker.isNetworkAvailable(this.applicationContext) && !var1_1.isOffline()) {
                                Ln.e("Network is down.", new Object[0]);
                                this.handleRetry(var1_1, new NoNetworkException());
                                DefaultRequestRunner.printRequestProcessingDuration(var2_2, var1_1);
                                return;
                            }
                            break block21;
                            break;
                        }
                        catch (SpiceException var18_5) {
                            Ln.d(var18_5, (Object)"Cache file could not be read.", new Object[0]);
                            if (this.failOnCacheError) {
                                this.handleRetry(var1_1, var18_5);
                                DefaultRequestRunner.printRequestProcessingDuration(var2_2, var1_1);
                                return;
                            }
                            this.cacheManager.removeDataFromCache(var1_1.getResultType(), var1_1.getRequestCacheKey());
                            Ln.d(var18_5, (Object)"Cache file deleted.", new Object[0]);
                            ** continue;
                        }
                    }
                    try {
                        if (var1_1.isCancelled()) {
                            DefaultRequestRunner.printRequestProcessingDuration(var2_2, var1_1);
                            return;
                        }
                    }
                    catch (Exception var6_6) {
                        if (!var1_1.isCancelled()) {
                            Ln.e(var6_6, (Object)("An exception occurred during request network execution :" + var6_6.getMessage()), new Object[0]);
                            this.handleRetry(var1_1, new NetworkException("Exception occurred during invocation of web service.", var6_6));
lbl53:
                            // 2 sources

                            while (true) {
                                DefaultRequestRunner.printRequestProcessingDuration(var2_2, var1_1);
                                return;
                            }
                        }
                        break block22;
                    }
                    {
                        Ln.d("Calling netwok request.", new Object[0]);
                        var1_1.setStatus(RequestStatus.LOADING_FROM_NETWORK);
                        var10_7 = var1_1.loadDataFromNetwork();
                        Ln.d("Network request call ended.", new Object[0]);
                        if (var10_7 == null || var1_1.getRequestCacheKey() == null) break block23;
                    }
                    try {
                        if (var1_1.isCancelled()) {
                            DefaultRequestRunner.printRequestProcessingDuration(var2_2, var1_1);
                            return;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (SpiceException var12_8) {
                        Ln.d(var12_8, (Object)("An exception occurred during service execution :" + var12_8.getMessage()), new Object[0]);
                        if (this.failOnCacheError) {
                            this.handleRetry(var1_1, var12_8);
                            DefaultRequestRunner.printRequestProcessingDuration(var2_2, var1_1);
                            return;
                        }
                        break block24;
                    }
                }
                Ln.e("An exception occurred during request network execution but request was cancelled, so listeners are not called.", new Object[0]);
                ** while (true)
lbl-1000:
                // 1 sources

                {
                    Ln.d("Start caching content...", new Object[0]);
                    var1_1.setStatus(RequestStatus.WRITING_TO_CACHE);
                    var10_7 = this.saveDataToCacheAndReturnData(var10_7, var1_1.getRequestCacheKey());
                    if (var1_1.isCancelled()) {
                        DefaultRequestRunner.printRequestProcessingDuration(var2_2, var1_1);
                        return;
                    }
                    this.requestProgressManager.notifyListenersOfRequestSuccess(var1_1, var10_7);
                    DefaultRequestRunner.printRequestProcessingDuration(var2_2, var1_1);
                    return;
                }
            }
            if (var1_1.isCancelled()) {
                DefaultRequestRunner.printRequestProcessingDuration(var2_2, var1_1);
                return;
            }
            this.requestProgressManager.notifyListenersOfRequestSuccess(var1_1, var10_7);
            this.cacheManager.removeDataFromCache(var1_1.getResultType(), var1_1.getRequestCacheKey());
            Ln.d(var12_8, (Object)"Cache file deleted.", new Object[0]);
            return;
        }
        this.requestProgressManager.notifyListenersOfRequestSuccess(var1_1, var10_7);
        DefaultRequestRunner.printRequestProcessingDuration(var2_2, var1_1);
    }

    @Override
    public void setFailOnCacheError(boolean bl2) {
        this.failOnCacheError = bl2;
    }

    @Override
    public void shouldStop() {
        this.isStopped = true;
        this.executorService.shutdown();
    }
}

