/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.priority;

import java.io.ObjectInputStream;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class PausablePriorityBlockingQueue<T>
extends PriorityBlockingQueue<T> {
    private static final long serialVersionUID = 3726077277740650698L;
    private boolean isPaused;
    private transient ReentrantLock pauseLock = new ReentrantLock();
    private transient Condition unpaused = this.pauseLock.newCondition();

    private void readObject(ObjectInputStream objectInputStream) {
        try {
            objectInputStream.defaultReadObject();
            this.pauseLock = new ReentrantLock();
            this.pauseLock.newCondition();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void pause() {
        this.pauseLock.lock();
        try {
            this.isPaused = true;
            return;
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    @Override
    public T poll() {
        this.pauseLock.lock();
        try {
            while (this.isPaused) {
                this.unpaused.await();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted while paused.");
        }
        finally {
            this.pauseLock.unlock();
        }
        return (T)super.poll();
    }

    @Override
    public T poll(long l2, TimeUnit timeUnit) throws InterruptedException {
        this.pauseLock.lock();
        try {
            while (this.isPaused) {
                this.unpaused.await();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted while paused.");
        }
        finally {
            this.pauseLock.unlock();
        }
        return (T)super.poll(l2, timeUnit);
    }

    public void resume() {
        this.pauseLock.lock();
        try {
            this.isPaused = false;
            this.unpaused.signalAll();
            return;
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    @Override
    public T take() throws InterruptedException {
        this.pauseLock.lock();
        try {
            while (this.isPaused) {
                this.unpaused.await();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted while paused.");
        }
        finally {
            this.pauseLock.unlock();
        }
        return (T)super.take();
    }
}

