/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.persistence.string;

import android.app.Application;
import com.octo.android.robospice.persistence.exception.CacheCreationException;
import com.octo.android.robospice.persistence.exception.CacheLoadingException;
import com.octo.android.robospice.persistence.exception.CacheSavingException;
import com.octo.android.robospice.persistence.file.InFileObjectPersister;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import roboguice.util.temp.Ln;

public class InFileStringObjectPersister
extends InFileObjectPersister<String> {
    public InFileStringObjectPersister(Application application) throws CacheCreationException {
        super(application, String.class);
    }

    @Override
    public boolean canHandleClass(Class<?> clazz) {
        return clazz.equals(String.class);
    }

    @Override
    protected String readCacheDataFromFile(File file) throws CacheLoadingException {
        try {
            String string2 = FileUtils.readFileToString(file, "UTF-8");
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Ln.w("file " + file.getAbsolutePath() + " does not exists", fileNotFoundException);
            return null;
        }
        catch (Exception exception) {
            throw new CacheLoadingException(exception);
        }
    }

    @Override
    public String saveDataToCacheAndReturnData(final String string2, final Object object) throws CacheSavingException {
        block3: {
            Ln.v("Saving String " + string2 + " into cacheKey = " + object, new Object[0]);
            try {
                if (!this.isAsyncSaveEnabled()) break block3;
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            FileUtils.writeStringToFile(InFileStringObjectPersister.this.getCacheFile(object), string2, "UTF-8");
                            return;
                        }
                        catch (IOException iOException) {
                            Ln.e(iOException, (Object)("An error occured on saving request " + object + " data asynchronously"), new Object[0]);
                            return;
                        }
                    }
                }.start();
                return string2;
            }
            catch (Exception exception) {
                throw new CacheSavingException(exception);
            }
        }
        FileUtils.writeStringToFile(this.getCacheFile(object), string2, "UTF-8");
        return string2;
    }
}

