/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.persistence.memory;

import com.octo.android.robospice.persistence.ObjectPersister;
import com.octo.android.robospice.persistence.exception.CacheLoadingException;
import com.octo.android.robospice.persistence.exception.CacheSavingException;
import com.octo.android.robospice.persistence.memory.CacheItem;
import com.octo.android.robospice.persistence.memory.LruCache;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import roboguice.util.temp.Ln;

public class LruCacheObjectPersister<T>
extends ObjectPersister<T> {
    private ObjectPersister<T> decoratedPersister;
    private LruCache<Object, CacheItem<T>> lruCache;

    public LruCacheObjectPersister(ObjectPersister<T> objectPersister, LruCache<Object, CacheItem<T>> lruCache) {
        super(objectPersister.getApplication(), objectPersister.getHandledClass());
        this.decoratedPersister = objectPersister;
        this.lruCache = lruCache;
    }

    public LruCacheObjectPersister(Class<T> clazz, LruCache<Object, CacheItem<T>> lruCache) {
        super(null, clazz);
        this.lruCache = lruCache;
    }

    @Override
    public List<Object> getAllCacheKeys() {
        if (this.decoratedPersister != null) {
            return this.decoratedPersister.getAllCacheKeys();
        }
        return new ArrayList<Object>(this.lruCache.snapshot().keySet());
    }

    @Override
    public long getCreationDateInCache(Object object) throws CacheLoadingException {
        CacheItem<T> cacheItem = this.lruCache.get(object);
        if (cacheItem != null) {
            return cacheItem.getCreationDate();
        }
        throw new CacheLoadingException("Data could not be found in cache for cacheKey=" + object);
    }

    public ObjectPersister<T> getDecoratedPersister() {
        return this.decoratedPersister;
    }

    public LruCache<Object, CacheItem<T>> getLruCache() {
        return this.lruCache;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isDataInCache(Object object, long l2) {
        boolean bl2;
        CacheItem<T> cacheItem = this.lruCache.get(object);
        if (cacheItem == null) {
            ObjectPersister<T> objectPersister = this.decoratedPersister;
            bl2 = false;
            if (objectPersister == null) return bl2;
            return this.decoratedPersister.isDataInCache(object, l2);
        }
        boolean bl3 = l2 != 0L;
        boolean bl4 = System.currentTimeMillis() - cacheItem.getCreationDate() <= l2;
        if (!bl3) return true;
        bl2 = false;
        if (!bl4) return bl2;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<T> loadAllDataFromCache() throws CacheLoadingException {
        if (this.decoratedPersister != null) {
            return this.decoratedPersister.loadAllDataFromCache();
        }
        Map<Object, CacheItem<T>> map = this.lruCache.snapshot();
        List<T> list = new ArrayList<T>();
        Iterator<CacheItem<T>> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next().getData());
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public T loadDataFromCache(Object object, long l2) throws CacheLoadingException {
        CacheItem<T> cacheItem = this.lruCache.get(object);
        if (cacheItem == null) {
            Ln.d("Miss from lru cache for %s", object);
            if (this.decoratedPersister == null) {
                return null;
            }
            T t2 = this.decoratedPersister.loadDataFromCache(object, l2);
            if (t2 == null) {
                return null;
            }
            CacheItem<T> cacheItem2 = new CacheItem<T>(this.decoratedPersister.getCreationDateInCache(object), t2);
            Ln.d("Put in lru cache after miss", new Object[0]);
            this.lruCache.put(object, cacheItem2);
            return t2;
        }
        Ln.d("Hit from lru cache for %s", object);
        boolean bl2 = l2 != 0L;
        boolean bl3 = System.currentTimeMillis() - cacheItem.getCreationDate() <= l2;
        if (bl2 && !bl3) {
            return null;
        }
        return cacheItem.getData();
    }

    @Override
    public void removeAllDataFromCache() {
        this.lruCache.evictAll();
        if (this.decoratedPersister != null) {
            this.decoratedPersister.removeAllDataFromCache();
        }
    }

    @Override
    public boolean removeDataFromCache(Object object) {
        ObjectPersister<T> objectPersister = this.decoratedPersister;
        boolean bl2 = false;
        if (objectPersister != null) {
            bl2 = this.decoratedPersister.removeDataFromCache(object);
        }
        return bl2 || this.lruCache.remove(object) != null;
    }

    @Override
    public T saveDataToCacheAndReturnData(T t2, Object object) throws CacheSavingException {
        CacheItem<T> cacheItem = new CacheItem<T>(t2);
        this.lruCache.put(object, cacheItem);
        Ln.d("Put in lru cache for %s", object);
        if (this.decoratedPersister != null) {
            this.decoratedPersister.saveDataToCacheAndReturnData(t2, object);
        }
        return t2;
    }
}

