/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.persistence.keysanitation;

import android.annotation.TargetApi;
import android.util.Base64;
import com.octo.android.robospice.persistence.exception.KeySanitationExcepion;
import com.octo.android.robospice.persistence.keysanitation.KeySanitizer;
import java.io.UnsupportedEncodingException;

@TargetApi(value=8)
public class DefaultKeySanitizer
implements KeySanitizer {
    private static final int BASE64_FLAGS = 11;
    private static final String UTF8_CHARSET_NAME = "UTF-8";

    @Override
    public Object desanitizeKey(Object object) throws KeySanitationExcepion {
        if (!(object instanceof String)) {
            throw new KeySanitationExcepion(DefaultKeySanitizer.class.getSimpleName() + " can only be used with Strings cache keys.");
        }
        try {
            String string2 = new String(Base64.decode((String)((String)object), (int)11), UTF8_CHARSET_NAME);
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new KeySanitationExcepion(unsupportedEncodingException);
        }
    }

    @Override
    public Object sanitizeKey(Object object) throws KeySanitationExcepion {
        if (!(object instanceof String)) {
            throw new KeySanitationExcepion(DefaultKeySanitizer.class.getSimpleName() + " can only be used with Strings cache keys.");
        }
        try {
            String string2 = Base64.encodeToString((byte[])((String)object).getBytes(UTF8_CHARSET_NAME), (int)11);
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new KeySanitationExcepion(unsupportedEncodingException);
        }
    }
}

