/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.persistence.googlehttpclient.json;

import android.app.Application;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonGenerator;
import com.google.api.client.json.JsonParser;
import com.octo.android.robospice.persistence.exception.CacheCreationException;
import com.octo.android.robospice.persistence.exception.CacheLoadingException;
import com.octo.android.robospice.persistence.exception.CacheSavingException;
import com.octo.android.robospice.persistence.file.InFileObjectPersister;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import roboguice.util.temp.Ln;

public final class JsonObjectPersister<T>
extends InFileObjectPersister<T> {
    private final JsonFactory jsonFactory;

    public JsonObjectPersister(Application application, JsonFactory jsonFactory, Class<T> clazz) throws CacheCreationException {
        super(application, clazz);
        this.jsonFactory = jsonFactory;
    }

    public JsonObjectPersister(Application application, JsonFactory jsonFactory, Class<T> clazz, File file) throws CacheCreationException {
        super(application, clazz, file);
        this.jsonFactory = jsonFactory;
    }

    private void saveData(T t2, Object object) throws IOException, CacheSavingException {
        JsonGenerator jsonGenerator = this.jsonFactory.createJsonGenerator(new FileWriter(this.getCacheFile(object)));
        jsonGenerator.serialize(t2);
        jsonGenerator.flush();
        jsonGenerator.close();
    }

    @Override
    protected T readCacheDataFromFile(File file) throws CacheLoadingException {
        Object t2;
        try {
            JsonParser jsonParser = this.jsonFactory.createJsonParser(new FileReader(file));
            t2 = jsonParser.parse(this.getHandledClass(), null);
            jsonParser.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Ln.w("file " + file.getAbsolutePath() + " does not exists", fileNotFoundException);
            return null;
        }
        catch (Exception exception) {
            throw new CacheLoadingException(exception);
        }
        return t2;
    }

    @Override
    public T saveDataToCacheAndReturnData(final T t2, final Object object) throws CacheSavingException {
        block4: {
            if (!this.isAsyncSaveEnabled()) break block4;
            new Thread(){

                @Override
                public void run() {
                    try {
                        JsonObjectPersister.this.saveData(t2, object);
                        return;
                    }
                    catch (IOException iOException) {
                        Ln.e(iOException, (Object)("An error occured on saving request " + object + " data asynchronously"), new Object[0]);
                        return;
                    }
                    catch (CacheSavingException cacheSavingException) {
                        Ln.e(cacheSavingException, (Object)("An error occured on saving request " + object + " data asynchronously"), new Object[0]);
                        return;
                    }
                }
            }.start();
            return t2;
        }
        try {
            this.saveData(t2, object);
        }
        catch (CacheSavingException cacheSavingException) {
            throw cacheSavingException;
        }
        catch (Exception exception) {
            throw new CacheSavingException(exception);
        }
        return t2;
    }
}

