/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.persistence.file;

import android.app.Application;
import com.octo.android.robospice.persistence.CacheCleaner;
import com.octo.android.robospice.persistence.ObjectPersisterFactory;
import com.octo.android.robospice.persistence.exception.CacheCreationException;
import com.octo.android.robospice.persistence.file.InFileObjectPersister;
import com.octo.android.robospice.persistence.keysanitation.KeySanitizer;
import java.io.File;
import java.io.FileFilter;
import java.util.List;
import roboguice.util.temp.Ln;

public abstract class InFileObjectPersisterFactory
extends ObjectPersisterFactory
implements CacheCleaner {
    private File cacheFolder;
    private String cachePrefix;
    private KeySanitizer keySanitizer;

    public InFileObjectPersisterFactory(Application application) throws CacheCreationException {
        this(application, null, null);
    }

    public InFileObjectPersisterFactory(Application application, File file) throws CacheCreationException {
        this(application, null, file);
    }

    public InFileObjectPersisterFactory(Application application, List<Class<?>> list) throws CacheCreationException {
        this(application, list, null);
    }

    public InFileObjectPersisterFactory(Application application, List<Class<?>> list, File file) throws CacheCreationException {
        super(application, list);
        this.setCacheFolder(file);
        this.setCachePrefix(this.getClass().getSimpleName() + "_");
    }

    public abstract <T> InFileObjectPersister<T> createInFileObjectPersister(Class<T> var1, File var2) throws CacheCreationException;

    public final <T> InFileObjectPersister<T> createObjectPersister(Class<T> clazz) {
        try {
            InFileObjectPersister<T> inFileObjectPersister = this.createInFileObjectPersister(clazz, this.cacheFolder);
            inFileObjectPersister.setFactoryCachePrefix(this.cachePrefix);
            inFileObjectPersister.setKeySanitizer(this.keySanitizer);
            return inFileObjectPersister;
        }
        catch (CacheCreationException cacheCreationException) {
            throw new RuntimeException("Could not create cache folder of factory.", cacheCreationException);
        }
    }

    public File getCacheFolder() {
        return this.cacheFolder;
    }

    public String getCachePrefix() {
        return this.cachePrefix;
    }

    public KeySanitizer getKeySanitizer() {
        return this.keySanitizer;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void removeAllDataFromCache() {
        block4: {
            block3: {
                File[] fileArray = this.getCacheFolder().listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.getName().startsWith(InFileObjectPersisterFactory.this.getCachePrefix());
                    }
                });
                boolean bl2 = true;
                if (fileArray == null) return;
                if (fileArray.length == 0) break block3;
                int n2 = fileArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    bl2 = fileArray[i2].delete() && bl2;
                }
                if (bl2 || fileArray.length == 0) break block4;
            }
            return;
        }
        Ln.d("Some file could not be deleted from cache.", new Object[0]);
    }

    public void setCacheFolder(File file) throws CacheCreationException {
        if (file == null) {
            file = new File(this.getApplication().getCacheDir(), "robospice-cache");
        }
        this.cacheFolder = file;
        if (!file.exists() && !file.mkdirs()) {
            throw new CacheCreationException("The cache folder " + file.getAbsolutePath() + " could not be created.");
        }
    }

    public void setCachePrefix(String string2) {
        this.cachePrefix = string2;
    }

    public void setKeySanitizer(KeySanitizer keySanitizer) {
        this.keySanitizer = keySanitizer;
    }
}

