/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.persistence.file;

import android.app.Application;
import com.octo.android.robospice.persistence.ObjectPersister;
import com.octo.android.robospice.persistence.exception.CacheCreationException;
import com.octo.android.robospice.persistence.exception.CacheLoadingException;
import com.octo.android.robospice.persistence.exception.KeySanitationExcepion;
import com.octo.android.robospice.persistence.keysanitation.KeySanitizer;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import roboguice.util.temp.Ln;

public abstract class InFileObjectPersister<T>
extends ObjectPersister<T> {
    static final String CACHE_PREFIX_END = "_";
    static final String DEFAULT_ROOT_CACHE_DIR = "robospice-cache";
    private File cacheFolder;
    private String factoryCachePrefix = "";
    private KeySanitizer keySanitizer;

    public InFileObjectPersister(Application application, Class<T> clazz) throws CacheCreationException {
        super(application, clazz);
        this.setCacheFolder(null);
    }

    public InFileObjectPersister(Application application, Class<T> clazz, File file) throws CacheCreationException {
        super(application, clazz);
        this.setCacheFolder(file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final String fromKey(String string2) {
        if (!this.isUsingKeySanitizer()) return string2;
        try {
            String string3 = (String)this.keySanitizer.desanitizeKey(string2);
            return string3;
        }
        catch (KeySanitationExcepion keySanitationExcepion) {
            Ln.e(keySanitationExcepion, (Object)"Key could not be desanitized, falling back on original key.", new Object[0]);
            return string2;
        }
    }

    @Override
    public List<Object> getAllCacheKeys() {
        final String string2 = this.getCachePrefix();
        int n2 = string2.length();
        String[] stringArray = this.getCacheFolder().list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string22) {
                return string22.startsWith(string2);
            }
        });
        ArrayList<Object> arrayList = new ArrayList<Object>(stringArray.length);
        int n3 = stringArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            arrayList.add(this.fromKey(stringArray[i2].substring(n2)));
        }
        return arrayList;
    }

    public final File getCacheFile(Object object) {
        return new File(this.getCacheFolder(), this.getCachePrefix() + this.toKey(object.toString()));
    }

    public final File getCacheFolder() {
        return this.cacheFolder;
    }

    protected final String getCachePrefix() {
        return this.factoryCachePrefix + this.getClass().getSimpleName() + CACHE_PREFIX_END;
    }

    @Override
    public long getCreationDateInCache(Object object) throws CacheLoadingException {
        File file = this.getCacheFile(object);
        if (file.exists()) {
            return file.lastModified();
        }
        throw new CacheLoadingException("Data could not be found in cache for cacheKey=" + object);
    }

    public KeySanitizer getKeySanitizer() {
        return this.keySanitizer;
    }

    protected boolean isCachedAndNotExpired(File file, long l2) {
        if (file.exists()) {
            long l3 = System.currentTimeMillis() - file.lastModified();
            if (l2 == 0L || l3 <= l2) {
                return true;
            }
        }
        return false;
    }

    protected boolean isCachedAndNotExpired(Object object, long l2) {
        return this.isCachedAndNotExpired(this.getCacheFile(object), l2);
    }

    @Override
    public boolean isDataInCache(Object object, long l2) {
        return this.isCachedAndNotExpired(this.getCacheFile(object), l2);
    }

    public boolean isUsingKeySanitizer() {
        return this.keySanitizer != null;
    }

    @Override
    public List<T> loadAllDataFromCache() throws CacheLoadingException {
        List<Object> list = this.getAllCacheKeys();
        ArrayList<T> arrayList = new ArrayList<T>(list.size());
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.loadDataFromCache(iterator.next(), 0L));
        }
        return arrayList;
    }

    @Override
    public T loadDataFromCache(Object object, long l2) throws CacheLoadingException {
        File file = this.getCacheFile(object);
        if (this.isCachedAndNotExpired(file, l2)) {
            return this.readCacheDataFromFile(file);
        }
        return null;
    }

    protected abstract T readCacheDataFromFile(File var1) throws CacheLoadingException;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void removeAllDataFromCache() {
        File[] fileArray = this.getCacheFolder().listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith(InFileObjectPersister.this.getCachePrefix());
            }
        });
        boolean bl2 = true;
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            bl2 = fileArray[i2].delete() && bl2;
        }
        if (bl2 || fileArray.length == 0) {
            Ln.d("Some file could not be deleted from cache.", new Object[0]);
        }
    }

    @Override
    public boolean removeDataFromCache(Object object) {
        return this.getCacheFile(object).delete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCacheFolder(File file) throws CacheCreationException {
        if (file == null) {
            file = new File(this.getApplication().getCacheDir(), DEFAULT_ROOT_CACHE_DIR);
        }
        String string2 = file.getAbsolutePath().intern();
        synchronized (string2) {
            if (!file.exists() && !file.mkdirs()) {
                throw new CacheCreationException("The cache folder " + file.getAbsolutePath() + " could not be created.");
            }
        }
        this.cacheFolder = file;
    }

    void setFactoryCachePrefix(String string2) {
        this.factoryCachePrefix = string2;
    }

    public void setKeySanitizer(KeySanitizer keySanitizer) {
        this.keySanitizer = keySanitizer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final String toKey(String string2) {
        if (!this.isUsingKeySanitizer()) return string2;
        try {
            String string3 = (String)this.keySanitizer.sanitizeKey(string2);
            return string3;
        }
        catch (KeySanitationExcepion keySanitationExcepion) {
            Ln.e(keySanitationExcepion, (Object)"Key could not be sanitized, falling back on original key.", new Object[0]);
            return string2;
        }
    }
}

