/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.persistence.binary;

import android.app.Application;
import com.octo.android.robospice.persistence.exception.CacheCreationException;
import com.octo.android.robospice.persistence.exception.CacheLoadingException;
import com.octo.android.robospice.persistence.exception.CacheSavingException;
import com.octo.android.robospice.persistence.file.InFileObjectPersister;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import roboguice.util.temp.Ln;

public class InFileInputStreamObjectPersister
extends InFileObjectPersister<InputStream> {
    public InFileInputStreamObjectPersister(Application application) throws CacheCreationException {
        super(application, InputStream.class);
    }

    public InFileInputStreamObjectPersister(Application application, File file) throws CacheCreationException {
        super(application, InputStream.class, file);
    }

    @Override
    public boolean canHandleClass(Class<?> clazz) {
        try {
            clazz.asSubclass(InputStream.class);
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    protected InputStream readCacheDataFromFile(File file) throws CacheLoadingException {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            return fileInputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Ln.w("file " + file.getAbsolutePath() + " does not exists", fileNotFoundException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InputStream saveDataToCacheAndReturnData(InputStream inputStream, final Object object) throws CacheSavingException {
        try {
            final byte[] byArray = IOUtils.toByteArray(inputStream);
            if (this.isAsyncSaveEnabled()) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            FileUtils.writeByteArrayToFile(InFileInputStreamObjectPersister.this.getCacheFile(object), byArray);
                            return;
                        }
                        catch (IOException iOException) {
                            Ln.e(iOException, (Object)("An error occured on saving request " + object + " data asynchronously"), new Object[0]);
                            return;
                        }
                    }
                }.start();
                return new ByteArrayInputStream(byArray);
            }
            FileUtils.writeByteArrayToFile(this.getCacheFile(object), byArray);
            return new ByteArrayInputStream(byArray);
        }
        catch (IOException iOException) {
            throw new CacheSavingException(iOException);
        }
    }
}

