/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.persistence;

import com.octo.android.robospice.persistence.CacheCleaner;
import com.octo.android.robospice.persistence.ICacheManager;
import com.octo.android.robospice.persistence.ObjectPersister;
import com.octo.android.robospice.persistence.ObjectPersisterFactory;
import com.octo.android.robospice.persistence.Persister;
import com.octo.android.robospice.persistence.exception.CacheCreationException;
import com.octo.android.robospice.persistence.exception.CacheLoadingException;
import com.octo.android.robospice.persistence.exception.CacheSavingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import roboguice.util.temp.Ln;

public class CacheManager
implements ICacheManager {
    private Collection<Persister> listPersister = new ArrayList<Persister>();
    private Map<ObjectPersisterFactory, List<ObjectPersister<?>>> mapFactoryToPersister = new HashMap();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void addPersister(Persister persister) {
        this.listPersister.add(persister);
        if (persister instanceof ObjectPersisterFactory) {
            this.mapFactoryToPersister.put((ObjectPersisterFactory)persister, new CopyOnWriteArrayList());
            return;
        } else {
            if (persister instanceof ObjectPersister) return;
            throw new RuntimeException(this.getClass().getSimpleName() + " only supports " + ObjectPersister.class.getSimpleName() + " or " + ObjectPersisterFactory.class.getSimpleName() + " instances.");
        }
    }

    @Override
    public <T> List<Object> getAllCacheKeys(Class<T> clazz) {
        try {
            List<Object> list = this.getObjectPersister(clazz).getAllCacheKeys();
            return list;
        }
        catch (CacheCreationException cacheCreationException) {
            Ln.e(cacheCreationException);
            return Collections.emptyList();
        }
    }

    @Override
    public Date getDateOfDataInCache(Class<?> clazz, Object object) throws CacheLoadingException, CacheCreationException {
        return new Date(this.getObjectPersister(clazz).getCreationDateInCache(object));
    }

    protected <T> ObjectPersister<T> getObjectPersister(Class<T> clazz) throws CacheCreationException {
        for (Persister persister : this.listPersister) {
            ObjectPersisterFactory objectPersisterFactory;
            if (!persister.canHandleClass(clazz)) continue;
            if (persister instanceof ObjectPersister) {
                return (ObjectPersister)persister;
            }
            if (!(persister instanceof ObjectPersisterFactory) || !(objectPersisterFactory = (ObjectPersisterFactory)persister).canHandleClass(clazz)) continue;
            List<ObjectPersister<?>> list = this.mapFactoryToPersister.get(objectPersisterFactory);
            for (ObjectPersister<T> objectPersister : list) {
                if (!objectPersister.canHandleClass(clazz)) continue;
                return objectPersister;
            }
            ObjectPersister<T> objectPersister = objectPersisterFactory.createObjectPersister(clazz);
            objectPersister.setAsyncSaveEnabled(objectPersisterFactory.isAsyncSaveEnabled());
            list.add(objectPersister);
            return objectPersister;
        }
        throw new RuntimeException("Class " + clazz.getName() + " is not handled by any registered ObjectPersister. Please add a Persister for this class inside the CacheManager of your SpiceService.");
    }

    @Override
    public boolean isDataInCache(Class<?> clazz, Object object, long l2) throws CacheCreationException {
        return this.getObjectPersister(clazz).isDataInCache(object, l2);
    }

    @Override
    public <T> List<T> loadAllDataFromCache(Class<T> clazz) throws CacheLoadingException, CacheCreationException {
        return this.getObjectPersister(clazz).loadAllDataFromCache();
    }

    @Override
    public <T> T loadDataFromCache(Class<T> clazz, Object object, long l2) throws CacheLoadingException, CacheCreationException {
        return this.getObjectPersister(clazz).loadDataFromCache(object, l2);
    }

    @Override
    public void removeAllDataFromCache() {
        for (Persister persister : this.listPersister) {
            if (persister instanceof CacheCleaner) {
                ((CacheCleaner)((Object)persister)).removeAllDataFromCache();
            }
            if (!(persister instanceof ObjectPersisterFactory)) continue;
            ObjectPersisterFactory objectPersisterFactory = (ObjectPersisterFactory)persister;
            Iterator<ObjectPersister<?>> iterator = this.mapFactoryToPersister.get(objectPersisterFactory).iterator();
            while (iterator.hasNext()) {
                iterator.next().removeAllDataFromCache();
            }
        }
    }

    @Override
    public void removeAllDataFromCache(Class<?> clazz) {
        try {
            this.getObjectPersister(clazz).removeAllDataFromCache();
            return;
        }
        catch (CacheCreationException cacheCreationException) {
            Ln.e(cacheCreationException);
            return;
        }
    }

    @Override
    public boolean removeDataFromCache(Class<?> clazz, Object object) {
        try {
            boolean bl2 = this.getObjectPersister(clazz).removeDataFromCache(object);
            return bl2;
        }
        catch (CacheCreationException cacheCreationException) {
            Ln.e(cacheCreationException);
            return false;
        }
    }

    @Override
    public void removePersister(Persister persister) {
        this.listPersister.remove(persister);
        if (persister instanceof ObjectPersisterFactory) {
            this.mapFactoryToPersister.remove(persister);
        }
    }

    @Override
    public <T> T saveDataToCacheAndReturnData(T t2, Object object) throws CacheSavingException, CacheCreationException {
        return (T)this.getObjectPersister(t2.getClass()).saveDataToCacheAndReturnData(t2, object);
    }
}

