/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.notification;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import com.octo.android.robospice.SpiceManager;
import com.octo.android.robospice.SpiceService;
import com.octo.android.robospice.request.CachedSpiceRequest;
import com.octo.android.robospice.request.listener.SpiceServiceListener;
import roboguice.util.temp.Ln;

public abstract class SpiceServiceListenerNotificationService
extends Service {
    public static final String BUNDLE_KEY_FOREGROUND = "BUNDLE_KEY_FOREGROUND";
    public static final String BUNDLE_KEY_NOTIFICATION_ID = "BUNDLE_KEY_NOTIFICATION_ID";
    public static final String BUNDLE_KEY_REQUEST_CACHE_KEY = "BUNDLE_KEY_REQUEST_CACHE_KEY";
    public static final String BUNDLE_KEY_REQUEST_CLASS = "BUNDLE_KEY_REQUEST_CLASS";
    public static final String BUNDLE_KEY_SERVICE_CLASS = "BUNDLE_KEY_SERVICE_CLASS";
    public static final int DEFAULT_ROBOSPICE_NOTIFICATION_ID = 700;
    private boolean foreground;
    private int notificationId = 700;
    private NotificationManager notificationManager;
    private SpiceManager spiceManager;
    private Class<? extends SpiceService> spiceServiceClass;

    public static Intent createIntent(Context context, Class<? extends SpiceServiceListenerNotificationService> clazz, Class<? extends SpiceService> clazz2, int n2, boolean bl2) {
        Intent intent = new Intent(context, clazz);
        intent.putExtra(BUNDLE_KEY_NOTIFICATION_ID, n2);
        intent.putExtra(BUNDLE_KEY_SERVICE_CLASS, clazz2);
        intent.putExtra(BUNDLE_KEY_FOREGROUND, bl2);
        return intent;
    }

    public Class<? extends SpiceService> getSpiceServiceClass() {
        return this.spiceServiceClass;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public Notification onCreateForegroundNotification() {
        throw new RuntimeException("If you use foreground = true, then you must override onCreateForegroundNotification().");
    }

    public abstract SpiceNotification onCreateNotificationForRequestAdded(CachedSpiceRequest<?> var1, SpiceServiceListener.RequestProcessingContext var2);

    public abstract SpiceNotification onCreateNotificationForRequestAggregated(CachedSpiceRequest<?> var1, SpiceServiceListener.RequestProcessingContext var2);

    public abstract SpiceNotification onCreateNotificationForRequestCancelled(CachedSpiceRequest<?> var1, SpiceServiceListener.RequestProcessingContext var2);

    public abstract SpiceNotification onCreateNotificationForRequestFailed(CachedSpiceRequest<?> var1, SpiceServiceListener.RequestProcessingContext var2);

    public abstract SpiceNotification onCreateNotificationForRequestNotFound(CachedSpiceRequest<?> var1, SpiceServiceListener.RequestProcessingContext var2);

    public abstract SpiceNotification onCreateNotificationForRequestProcessed(CachedSpiceRequest<?> var1, SpiceServiceListener.RequestProcessingContext var2);

    public abstract SpiceNotification onCreateNotificationForRequestProgressUpdate(CachedSpiceRequest<?> var1, SpiceServiceListener.RequestProcessingContext var2);

    public abstract SpiceNotification onCreateNotificationForRequestSucceeded(CachedSpiceRequest<?> var1, SpiceServiceListener.RequestProcessingContext var2);

    public abstract SpiceNotification onCreateNotificationForServiceStopped();

    public final void onDestroy() {
        this.spiceManager.shouldStop();
        super.onDestroy();
    }

    public final void onStart(Intent intent, int n2) {
        super.onStart(intent, n2);
        if (intent == null) {
            return;
        }
        this.notificationId = intent.getIntExtra(BUNDLE_KEY_NOTIFICATION_ID, 700);
        this.spiceServiceClass = (Class)intent.getSerializableExtra(BUNDLE_KEY_SERVICE_CLASS);
        if (this.spiceServiceClass == null) {
            throw new RuntimeException("Please specify a service class to monitor. Use #createIntent as helper.");
        }
        this.foreground = intent.getBooleanExtra(BUNDLE_KEY_FOREGROUND, true);
        this.spiceManager = new SpiceManager(this.spiceServiceClass);
        this.notificationManager = (NotificationManager)this.getSystemService("notification");
        this.spiceManager.start((Context)this);
        this.spiceManager.addSpiceServiceListener(new NotificationSpiceServiceListener());
        if (this.foreground) {
            this.startForeground(this.notificationId, this.onCreateForegroundNotification());
        }
        Ln.d(((Object)((Object)this)).getClass().getSimpleName() + " started.", new Object[0]);
    }

    public class NotificationSpiceServiceListener
    implements SpiceServiceListener {
        @Override
        public void onRequestAdded(CachedSpiceRequest<?> cachedSpiceRequest, SpiceServiceListener.RequestProcessingContext requestProcessingContext) {
            SpiceNotification spiceNotification = SpiceServiceListenerNotificationService.this.onCreateNotificationForRequestAdded(cachedSpiceRequest, requestProcessingContext);
            SpiceServiceListenerNotificationService.this.notificationManager.notify(spiceNotification.getId(), spiceNotification.getNotification());
        }

        @Override
        public void onRequestAggregated(CachedSpiceRequest<?> cachedSpiceRequest, SpiceServiceListener.RequestProcessingContext requestProcessingContext) {
            SpiceNotification spiceNotification = SpiceServiceListenerNotificationService.this.onCreateNotificationForRequestAdded(cachedSpiceRequest, requestProcessingContext);
            SpiceServiceListenerNotificationService.this.notificationManager.notify(spiceNotification.getId(), spiceNotification.getNotification());
        }

        @Override
        public void onRequestCancelled(CachedSpiceRequest<?> cachedSpiceRequest, SpiceServiceListener.RequestProcessingContext requestProcessingContext) {
            SpiceNotification spiceNotification = SpiceServiceListenerNotificationService.this.onCreateNotificationForRequestCancelled(cachedSpiceRequest, requestProcessingContext);
            SpiceServiceListenerNotificationService.this.notificationManager.notify(spiceNotification.getId(), spiceNotification.getNotification());
        }

        @Override
        public void onRequestFailed(CachedSpiceRequest<?> cachedSpiceRequest, SpiceServiceListener.RequestProcessingContext requestProcessingContext) {
            SpiceNotification spiceNotification = SpiceServiceListenerNotificationService.this.onCreateNotificationForRequestFailed(cachedSpiceRequest, requestProcessingContext);
            SpiceServiceListenerNotificationService.this.notificationManager.notify(spiceNotification.getId(), spiceNotification.getNotification());
        }

        @Override
        public void onRequestNotFound(CachedSpiceRequest<?> cachedSpiceRequest, SpiceServiceListener.RequestProcessingContext requestProcessingContext) {
            SpiceNotification spiceNotification = SpiceServiceListenerNotificationService.this.onCreateNotificationForRequestNotFound(cachedSpiceRequest, requestProcessingContext);
            SpiceServiceListenerNotificationService.this.notificationManager.notify(spiceNotification.getId(), spiceNotification.getNotification());
        }

        @Override
        public void onRequestProcessed(CachedSpiceRequest<?> cachedSpiceRequest, SpiceServiceListener.RequestProcessingContext requestProcessingContext) {
            SpiceNotification spiceNotification = SpiceServiceListenerNotificationService.this.onCreateNotificationForRequestProcessed(cachedSpiceRequest, requestProcessingContext);
            SpiceServiceListenerNotificationService.this.notificationManager.notify(spiceNotification.getId(), spiceNotification.getNotification());
        }

        @Override
        public void onRequestProgressUpdated(CachedSpiceRequest<?> cachedSpiceRequest, SpiceServiceListener.RequestProcessingContext requestProcessingContext) {
            SpiceNotification spiceNotification = SpiceServiceListenerNotificationService.this.onCreateNotificationForRequestProgressUpdate(cachedSpiceRequest, requestProcessingContext);
            SpiceServiceListenerNotificationService.this.notificationManager.notify(spiceNotification.getId(), spiceNotification.getNotification());
        }

        @Override
        public void onRequestSucceeded(CachedSpiceRequest<?> cachedSpiceRequest, SpiceServiceListener.RequestProcessingContext requestProcessingContext) {
            SpiceNotification spiceNotification = SpiceServiceListenerNotificationService.this.onCreateNotificationForRequestSucceeded(cachedSpiceRequest, requestProcessingContext);
            SpiceServiceListenerNotificationService.this.notificationManager.notify(spiceNotification.getId(), spiceNotification.getNotification());
        }

        @Override
        public void onServiceStopped() {
            SpiceNotification spiceNotification = SpiceServiceListenerNotificationService.this.onCreateNotificationForServiceStopped();
            SpiceServiceListenerNotificationService.this.notificationManager.notify(spiceNotification.getId(), spiceNotification.getNotification());
            SpiceServiceListenerNotificationService.this.stopSelf();
        }
    }

    public static class SpiceNotification {
        private int id;
        private Notification notification;

        public SpiceNotification(int n2, Notification notification) {
            this.id = n2;
            this.notification = notification;
        }

        public int getId() {
            return this.id;
        }

        public Notification getNotification() {
            return this.notification;
        }
    }
}

