/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.notification;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import com.octo.android.robospice.SpiceManager;
import com.octo.android.robospice.SpiceService;
import com.octo.android.robospice.persistence.exception.SpiceException;
import com.octo.android.robospice.request.listener.RequestListener;
import com.octo.android.robospice.request.listener.RequestProgress;
import com.octo.android.robospice.request.listener.RequestProgressListener;
import com.octo.android.robospice.request.listener.RequestStatus;

public abstract class SpiceNotificationService
extends Service {
    public static final String BUNDLE_KEY_FOREGROUND = "BUNDLE_KEY_FOREGROUND";
    public static final String BUNDLE_KEY_NOTIFICATION_ID = "BUNDLE_KEY_NOTIFICATION_ID";
    public static final String BUNDLE_KEY_REQUEST_CACHE_KEY = "BUNDLE_KEY_REQUEST_CACHE_KEY";
    public static final String BUNDLE_KEY_REQUEST_CLASS = "BUNDLE_KEY_REQUEST_CLASS";
    public static final String BUNDLE_KEY_SERVICE_CLASS = "BUNDLE_KEY_SERVICE_CLASS";
    private static final int DEFAULT_ROBOSPICE_NOTIFICATION_ID = 70;
    private boolean foreground;
    private int notificationId = 70;
    private NotificationManager notificationManager;
    private String requestCacheKey;
    private Class<?> requestClass;
    private SpiceManager spiceManager;
    private Class<? extends SpiceService> spiceServiceClass;

    public static Intent createIntent(Context context, Class<? extends SpiceNotificationService> clazz, Class<? extends SpiceService> clazz2, int n2, Class<?> clazz3, String string2, boolean bl2) {
        Intent intent = new Intent(context, clazz);
        intent.putExtra(BUNDLE_KEY_NOTIFICATION_ID, n2);
        intent.putExtra(BUNDLE_KEY_SERVICE_CLASS, clazz2);
        intent.putExtra(BUNDLE_KEY_REQUEST_CLASS, clazz3);
        intent.putExtra(BUNDLE_KEY_REQUEST_CACHE_KEY, string2);
        intent.putExtra(BUNDLE_KEY_FOREGROUND, bl2);
        return intent;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public Notification onCreateForegroundNotification() {
        throw new RuntimeException("If you use foreground = true, then you must override onCreateForegroundNotification().");
    }

    public abstract Notification onCreateNotificationForRequestFailure(SpiceException var1);

    public abstract Notification onCreateNotificationForRequestProgress(RequestProgress var1);

    public abstract Notification onCreateNotificationForRequestSuccess();

    public final void onDestroy() {
        this.spiceManager.shouldStop();
        super.onDestroy();
    }

    public final void onStart(Intent intent, int n2) {
        super.onStart(intent, n2);
        this.notificationId = intent.getIntExtra(BUNDLE_KEY_NOTIFICATION_ID, 70);
        this.requestClass = (Class)intent.getSerializableExtra(BUNDLE_KEY_REQUEST_CLASS);
        if (this.spiceServiceClass == null) {
            throw new RuntimeException("Please specify a service class to monitor. Use #createIntent as helper.");
        }
        this.requestCacheKey = intent.getStringExtra(BUNDLE_KEY_REQUEST_CACHE_KEY);
        this.spiceServiceClass = (Class)intent.getSerializableExtra(BUNDLE_KEY_SERVICE_CLASS);
        this.foreground = intent.getBooleanExtra(BUNDLE_KEY_FOREGROUND, true);
        this.spiceManager = new SpiceManager(this.spiceServiceClass);
        this.notificationManager = (NotificationManager)this.getSystemService("notification");
        this.spiceManager.start((Context)this);
        this.spiceManager.addListenerIfPending(this.requestClass, (Object)this.requestCacheKey, new NotificationRequestListener());
        if (this.foreground) {
            this.startForeground(this.notificationId, this.onCreateForegroundNotification());
        }
    }

    private class NotificationRequestListener<T>
    implements RequestListener<T>,
    RequestProgressListener {
        private NotificationRequestListener() {
        }

        @Override
        public void onRequestFailure(SpiceException spiceException) {
            Notification notification = SpiceNotificationService.this.onCreateNotificationForRequestFailure(spiceException);
            SpiceNotificationService.this.notificationManager.notify(SpiceNotificationService.this.notificationId, notification);
            SpiceNotificationService.this.stopSelf();
        }

        @Override
        public void onRequestProgressUpdate(RequestProgress requestProgress) {
            Notification notification = SpiceNotificationService.this.onCreateNotificationForRequestProgress(requestProgress);
            SpiceNotificationService.this.notificationManager.notify(SpiceNotificationService.this.notificationId, notification);
            if (requestProgress.getStatus() == RequestStatus.COMPLETE) {
                SpiceNotificationService.this.stopSelf();
            }
        }

        @Override
        public void onRequestSuccess(T t2) {
            Notification notification = SpiceNotificationService.this.onCreateNotificationForRequestSuccess();
            SpiceNotificationService.this.notificationManager.notify(SpiceNotificationService.this.notificationId, notification);
            SpiceNotificationService.this.stopSelf();
        }
    }
}

