/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.networkstate;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.octo.android.robospice.networkstate.NetworkStateChecker;

public class DefaultNetworkStateChecker
implements NetworkStateChecker {
    /*
     * Enabled aggressive block sorting
     */
    private boolean checkHasPermission(Context context, String string2) {
        if (context.getPackageManager().checkPermission(string2, context.getPackageName()) == 0) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        throw new SecurityException("Application doesn't declare <uses-permission android:name=\"" + string2 + "\" />");
    }

    @Override
    public void checkPermissions(Context context) {
        this.checkHasPermission(context, "android.permission.ACCESS_NETWORK_STATE");
        this.checkHasPermission(context, "android.permission.INTERNET");
    }

    @Override
    public boolean isNetworkAvailable(Context context) {
        for (NetworkInfo networkInfo : ((ConnectivityManager)context.getSystemService("connectivity")).getAllNetworkInfo()) {
            if (networkInfo.getState() != NetworkInfo.State.CONNECTED && networkInfo.getState() != NetworkInfo.State.CONNECTING) continue;
            return true;
        }
        return false;
    }
}

