/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice;

import android.app.Application;
import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import com.octo.android.robospice.networkstate.DefaultNetworkStateChecker;
import com.octo.android.robospice.networkstate.NetworkStateChecker;
import com.octo.android.robospice.persistence.CacheManager;
import com.octo.android.robospice.persistence.exception.CacheCreationException;
import com.octo.android.robospice.persistence.exception.CacheLoadingException;
import com.octo.android.robospice.persistence.exception.CacheSavingException;
import com.octo.android.robospice.priority.PriorityThreadPoolExecutor;
import com.octo.android.robospice.request.CachedSpiceRequest;
import com.octo.android.robospice.request.DefaultRequestRunner;
import com.octo.android.robospice.request.RequestProcessor;
import com.octo.android.robospice.request.RequestProcessorListener;
import com.octo.android.robospice.request.RequestProgressManager;
import com.octo.android.robospice.request.RequestRunner;
import com.octo.android.robospice.request.listener.RequestListener;
import com.octo.android.robospice.request.listener.SpiceServiceListener;
import com.octo.android.robospice.request.notifier.DefaultRequestListenerNotifier;
import com.octo.android.robospice.request.notifier.RequestListenerNotifier;
import com.octo.android.robospice.request.notifier.SpiceServiceListenerNotifier;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import roboguice.util.temp.Ln;

public abstract class SpiceService
extends Service {
    private static final boolean DEFAULT_FAIL_ON_CACHE_ERROR = false;
    protected static final int DEFAULT_NOTIFICATION_ID = 42;
    protected static final int DEFAULT_THREAD_COUNT = 1;
    protected static final int DEFAULT_THREAD_PRIORITY = 1;
    private static boolean isJUnit = false;
    private CacheManager cacheManager;
    private int currentPendingRequestCount = 0;
    private boolean isBound;
    private SpiceServiceBinder mSpiceServiceBinder = new SpiceServiceBinder(this);
    private Notification notification;
    private RequestProcessor requestProcessor;

    static /* synthetic */ int access$002(SpiceService spiceService, int n2) {
        spiceService.currentPendingRequestCount = n2;
        return n2;
    }

    private RequestProgressManager createRequestProgressManager(RequestProcessorListener requestProcessorListener, RequestListenerNotifier requestListenerNotifier, SpiceServiceListenerNotifier spiceServiceListenerNotifier) {
        return new RequestProgressManager(requestProcessorListener, requestListenerNotifier, spiceServiceListenerNotifier);
    }

    private RequestRunner createRequestRunner(ExecutorService executorService, NetworkStateChecker networkStateChecker, RequestProgressManager requestProgressManager) {
        return new DefaultRequestRunner(this.getApplicationContext(), this.cacheManager, executorService, requestProgressManager, networkStateChecker);
    }

    public static final void setIsJunit(boolean bl2) {
        isJUnit = bl2;
    }

    private void showNotificationIfNotBoundAndHasPendingRequestsOtherwiseHideNotification() {
        if (this.notification == null || isJUnit) {
            return;
        }
        Ln.v("Pending requests : " + this.currentPendingRequestCount, new Object[0]);
        if (this.isBound || this.currentPendingRequestCount == 0) {
            Ln.v("Stop foreground", new Object[0]);
            this.stopForeground(true);
            return;
        }
        Ln.v("Start foreground", new Object[0]);
        this.startForeground(this.notification);
    }

    private void startForeground(Notification notification) {
        try {
            Class[] classArray = new Class[]{Integer.TYPE, Notification.class};
            Method method = Service.class.getMethod("startForeground", classArray);
            Object[] objectArray = new Object[]{this.getNotificationId(), notification};
            method.invoke((Object)this, objectArray);
            return;
        }
        catch (SecurityException securityException) {
            Ln.e(securityException, (Object)"Unable to start a service in foreground", new Object[0]);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Ln.e(noSuchMethodException, (Object)"Unable to start a service in foreground", new Object[0]);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Ln.e(illegalArgumentException, (Object)"Unable to start a service in foreground", new Object[0]);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            Ln.e(illegalAccessException, (Object)"Unable to start a service in foreground", new Object[0]);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            Ln.e(invocationTargetException, (Object)"Unable to start a service in foreground", new Object[0]);
            return;
        }
    }

    private void stopIfNotBoundAndHasNoPendingRequests() {
        Ln.v("Pending requests : " + this.currentPendingRequestCount, new Object[0]);
        if (this.currentPendingRequestCount == 0 && !this.isBound) {
            this.stopSelf();
        }
    }

    public void addRequest(CachedSpiceRequest<?> cachedSpiceRequest, Set<RequestListener<?>> set) {
        this.currentPendingRequestCount = 1 + this.currentPendingRequestCount;
        this.requestProcessor.addRequest(cachedSpiceRequest, set);
        this.showNotificationIfNotBoundAndHasPendingRequestsOtherwiseHideNotification();
    }

    public void addSpiceServiceListener(SpiceServiceListener spiceServiceListener) {
        this.requestProcessor.addSpiceServiceListener(spiceServiceListener);
    }

    public abstract CacheManager createCacheManager(Application var1) throws CacheCreationException;

    /*
     * Enabled aggressive block sorting
     */
    public Notification createDefaultNotification() {
        Notification notification;
        if (Build.VERSION.SDK_INT >= 16) {
            notification = new Notification.Builder((Context)this).setSmallIcon(this.getApplicationInfo().icon).build();
        } else if (Build.VERSION.SDK_INT >= 11) {
            notification = new Notification.Builder((Context)this).setSmallIcon(this.getApplicationInfo().icon).getNotification();
        } else {
            notification = new Notification();
            notification.icon = this.getApplicationInfo().icon;
            notification.setLatestEventInfo((Context)this, (CharSequence)"", (CharSequence)"", PendingIntent.getActivity((Context)this.getApplicationContext(), (int)0, (Intent)new Intent(), (int)0));
            notification.tickerText = null;
            notification.when = System.currentTimeMillis();
        }
        if (Build.VERSION.SDK_INT >= 16) {
            notification.priority = -2;
        }
        return notification;
    }

    protected RequestProcessor createRequestProcessor(CacheManager cacheManager, RequestProgressManager requestProgressManager, RequestRunner requestRunner) {
        return new RequestProcessor(cacheManager, requestProgressManager, requestRunner);
    }

    protected RequestProcessorListener createRequestProcessorListener() {
        return new SelfStopperRequestProcessorListener();
    }

    protected RequestListenerNotifier createRequestRequestListenerNotifier() {
        return new DefaultRequestListenerNotifier();
    }

    protected SpiceServiceListenerNotifier createSpiceServiceListenerNotifier() {
        return new SpiceServiceListenerNotifier();
    }

    public void dontNotifyRequestListenersForRequest(CachedSpiceRequest<?> cachedSpiceRequest, Collection<RequestListener<?>> collection) {
        this.requestProcessor.dontNotifyRequestListenersForRequest(cachedSpiceRequest, collection);
    }

    public void dumpState() {
        Ln.v(this.requestProcessor.toString(), new Object[0]);
    }

    public <T> List<Object> getAllCacheKeys(Class<T> clazz) {
        return this.cacheManager.getAllCacheKeys(clazz);
    }

    public <T> T getDataFromCache(Class<T> clazz, Object object) throws CacheLoadingException, CacheCreationException {
        return this.cacheManager.loadDataFromCache(clazz, object, 0L);
    }

    public Date getDateOfDataInCache(Class<?> clazz, Object object) throws CacheLoadingException, CacheCreationException {
        return this.cacheManager.getDateOfDataInCache(clazz, object);
    }

    protected ExecutorService getExecutorService() {
        int n2 = this.getThreadCount();
        int n3 = this.getThreadPriority();
        if (n2 <= 0) {
            throw new IllegalArgumentException("Thread count must be >= 1");
        }
        return PriorityThreadPoolExecutor.getPriorityExecutor(n2, n3);
    }

    protected NetworkStateChecker getNetworkStateChecker() {
        return new DefaultNetworkStateChecker();
    }

    protected int getNotificationId() {
        return 42;
    }

    protected RequestProcessor getRequestProcessor() {
        return this.requestProcessor;
    }

    public int getThreadCount() {
        return 1;
    }

    public int getThreadPriority() {
        return 1;
    }

    public boolean isDataInCache(Class<?> clazz, Object object, long l2) throws CacheCreationException {
        return this.cacheManager.isDataInCache(clazz, object, l2);
    }

    public boolean isFailOnCacheError() {
        return this.requestProcessor.isFailOnCacheError();
    }

    public <T> List<T> loadAllDataFromCache(Class<T> clazz) throws CacheLoadingException, CacheCreationException {
        return this.cacheManager.loadAllDataFromCache(clazz);
    }

    public IBinder onBind(Intent intent) {
        this.isBound = true;
        this.showNotificationIfNotBoundAndHasPendingRequestsOtherwiseHideNotification();
        return this.mSpiceServiceBinder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onCreate() {
        block2: {
            super.onCreate();
            try {
                this.cacheManager = this.createCacheManager(this.getApplication());
                if (this.cacheManager != null) break block2;
            }
            catch (CacheCreationException cacheCreationException) {
                Ln.e(cacheCreationException);
                this.stopSelf();
                return;
            }
            Ln.e(new CacheCreationException("createCacheManager() can't create a null cacheManager"));
            this.stopSelf();
            return;
        }
        RequestListenerNotifier requestListenerNotifier = this.createRequestRequestListenerNotifier();
        SpiceServiceListenerNotifier spiceServiceListenerNotifier = this.createSpiceServiceListenerNotifier();
        RequestProcessorListener requestProcessorListener = this.createRequestProcessorListener();
        ExecutorService executorService = this.getExecutorService();
        NetworkStateChecker networkStateChecker = this.getNetworkStateChecker();
        RequestProgressManager requestProgressManager = this.createRequestProgressManager(requestProcessorListener, requestListenerNotifier, spiceServiceListenerNotifier);
        RequestRunner requestRunner = this.createRequestRunner(executorService, networkStateChecker, requestProgressManager);
        this.requestProcessor = this.createRequestProcessor(this.cacheManager, requestProgressManager, requestRunner);
        this.requestProcessor.setFailOnCacheError(false);
        this.notification = this.createDefaultNotification();
        Ln.d("SpiceService instance created.", new Object[0]);
    }

    public void onDestroy() {
        this.requestProcessor.shouldStop();
        Ln.d("SpiceService instance destroyed.", new Object[0]);
        super.onDestroy();
    }

    public void onRebind(Intent intent) {
        this.isBound = true;
        this.showNotificationIfNotBoundAndHasPendingRequestsOtherwiseHideNotification();
        super.onRebind(intent);
    }

    public int onStartCommand(Intent intent, int n2, int n3) {
        super.onStartCommand(intent, n2, n3);
        return 2;
    }

    public boolean onUnbind(Intent intent) {
        this.isBound = false;
        this.showNotificationIfNotBoundAndHasPendingRequestsOtherwiseHideNotification();
        this.stopIfNotBoundAndHasNoPendingRequests();
        return true;
    }

    public <T> T putDataInCache(Object object, T t2) throws CacheSavingException, CacheCreationException {
        return this.cacheManager.saveDataToCacheAndReturnData(t2, object);
    }

    public void removeAllDataFromCache() {
        this.requestProcessor.removeAllDataFromCache();
    }

    public void removeAllDataFromCache(Class<?> clazz) {
        this.requestProcessor.removeAllDataFromCache(clazz);
    }

    public boolean removeDataFromCache(Class<?> clazz, Object object) {
        return this.requestProcessor.removeDataFromCache(clazz, object);
    }

    public void removeSpiceServiceListener(SpiceServiceListener spiceServiceListener) {
        this.requestProcessor.removeSpiceServiceListener(spiceServiceListener);
    }

    public void setFailOnCacheError(boolean bl2) {
        this.requestProcessor.setFailOnCacheError(bl2);
    }

    protected final class SelfStopperRequestProcessorListener
    implements RequestProcessorListener {
        protected SelfStopperRequestProcessorListener() {
        }

        @Override
        public void allRequestComplete() {
            SpiceService.access$002(SpiceService.this, 0);
            SpiceService.this.stopIfNotBoundAndHasNoPendingRequests();
        }

        @Override
        public void requestsInProgress() {
        }
    }

    public static class SpiceServiceBinder
    extends Binder {
        private final SpiceService spiceService;

        public SpiceServiceBinder(SpiceService spiceService) {
            this.spiceService = spiceService;
        }

        public SpiceService getSpiceService() {
            return this.spiceService;
        }
    }
}

