/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import com.octo.android.robospice.SpiceService;
import com.octo.android.robospice.command.AddSpiceServiceListenerCommand;
import com.octo.android.robospice.command.GetAllCacheKeysCommand;
import com.octo.android.robospice.command.GetAllDataFromCacheCommand;
import com.octo.android.robospice.command.GetDataFromCacheCommand;
import com.octo.android.robospice.command.GetDateOfDataInCacheCommand;
import com.octo.android.robospice.command.IsDataInCacheCommand;
import com.octo.android.robospice.command.PutDataInCacheCommand;
import com.octo.android.robospice.command.RemoveAllDataFromCacheCommand;
import com.octo.android.robospice.command.RemoveDataClassFromCacheCommand;
import com.octo.android.robospice.command.RemoveDataFromCacheCommand;
import com.octo.android.robospice.command.RemoveSpiceServiceListenerCommand;
import com.octo.android.robospice.command.SetFailOnCacheErrorCommand;
import com.octo.android.robospice.persistence.exception.CacheCreationException;
import com.octo.android.robospice.persistence.exception.CacheLoadingException;
import com.octo.android.robospice.persistence.exception.CacheSavingException;
import com.octo.android.robospice.request.CachedSpiceRequest;
import com.octo.android.robospice.request.SpiceRequest;
import com.octo.android.robospice.request.listener.PendingRequestListener;
import com.octo.android.robospice.request.listener.RequestListener;
import com.octo.android.robospice.request.listener.SpiceServiceAdapter;
import com.octo.android.robospice.request.listener.SpiceServiceListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import roboguice.util.temp.Ln;

public class SpiceManager
implements Runnable {
    private static final int DEFAULT_THREAD_COUNT = 3;
    private static final int DELAY_WAIT_FOR_RUNNER_TO_STOP = 500;
    protected static final String SPICE_MANAGER_THREAD_NAM_PREFIX = "SpiceManagerThread ";
    private final Condition conditionServiceBound;
    private final Condition conditionServiceUnbound;
    private WeakReference<Context> contextWeakReference;
    private ExecutorService executorService;
    private volatile boolean isStopped = true;
    private volatile boolean isUnbinding = false;
    private final ReentrantLock lockAcquireService;
    private final ReentrantLock lockSendRequestsToService;
    private final Map<CachedSpiceRequest<?>, Set<RequestListener<?>>> mapPendingRequestToRequestListener;
    private final Map<CachedSpiceRequest<?>, Set<RequestListener<?>>> mapRequestToLaunchToRequestListener;
    private final PendingRequestHandlerSpiceServiceListener removerSpiceServiceListener;
    protected final BlockingQueue<CachedSpiceRequest<?>> requestQueue;
    protected Thread runner;
    private int spiceManagerThreadIndex;
    private SpiceService spiceService;
    private final Class<? extends SpiceService> spiceServiceClass;
    private SpiceServiceConnection spiceServiceConnection = new SpiceServiceConnection();

    public SpiceManager(Class<? extends SpiceService> clazz) {
        this.requestQueue = new PriorityBlockingQueue();
        this.mapRequestToLaunchToRequestListener = Collections.synchronizedMap(new IdentityHashMap());
        this.mapPendingRequestToRequestListener = Collections.synchronizedMap(new HashMap());
        this.lockAcquireService = new ReentrantLock();
        this.conditionServiceBound = this.lockAcquireService.newCondition();
        this.conditionServiceUnbound = this.lockAcquireService.newCondition();
        this.lockSendRequestsToService = new ReentrantLock();
        this.removerSpiceServiceListener = new PendingRequestHandlerSpiceServiceListener();
        this.spiceServiceClass = clazz;
    }

    static /* synthetic */ boolean access$1102(SpiceManager spiceManager, boolean bl2) {
        spiceManager.isUnbinding = bl2;
        return bl2;
    }

    static /* synthetic */ SpiceService access$702(SpiceManager spiceManager, SpiceService spiceService) {
        spiceManager.spiceService = spiceService;
        return spiceService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> void addRequestListenerToListOfRequestListeners(CachedSpiceRequest<T> cachedSpiceRequest, RequestListener<T> requestListener) {
        Map<CachedSpiceRequest<?>, Set<RequestListener<?>>> map = this.mapRequestToLaunchToRequestListener;
        synchronized (map) {
            Set<RequestListener<?>> set = this.mapRequestToLaunchToRequestListener.get(cachedSpiceRequest);
            if (set == null) {
                set = new HashSet();
                this.mapRequestToLaunchToRequestListener.put(cachedSpiceRequest, set);
            }
            set.add(requestListener);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void bindToService(Context context) {
        if (context == null || this.requestQueue.isEmpty() && this.isStopped) {
            return;
        }
        this.lockAcquireService.lock();
        this.lockSendRequestsToService.lock();
        try {
            block12: {
                block11: {
                    if (this.spiceService != null) break block11;
                    Intent intent = new Intent(context, this.spiceServiceClass);
                    Ln.v("Binding to service.", new Object[0]);
                    this.spiceServiceConnection = new SpiceServiceConnection();
                    if (context.getApplicationContext().bindService(intent, (ServiceConnection)this.spiceServiceConnection, 1)) break block12;
                    Ln.v("Binding to service failed.", new Object[0]);
                }
                return;
            }
            Ln.v("Binding to service succeeded.", new Object[0]);
            return;
        }
        catch (Exception exception) {
            Ln.d(exception, (Object)"Binding to service failed.", new Object[0]);
            Ln.d("Context is" + context, new Object[0]);
            Ln.d("ApplicationContext is " + context.getApplicationContext() + context.getApplicationContext(), new Object[0]);
            return;
        }
        finally {
            this.lockSendRequestsToService.unlock();
            this.lockAcquireService.unlock();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cancelAllRequestsInternal() {
        Iterator<CachedSpiceRequest<?>> iterator;
        this.lockSendRequestsToService.lock();
        try {
            Map<CachedSpiceRequest<?>, Set<RequestListener<?>>> map = this.mapRequestToLaunchToRequestListener;
            synchronized (map) {
                iterator = this.mapRequestToLaunchToRequestListener.keySet().iterator();
            }
        }
        catch (Throwable throwable) {
            this.lockSendRequestsToService.unlock();
            throw throwable;
        }
        {
            while (iterator.hasNext()) {
                iterator.next().cancel();
            }
        }
        {
            Iterator iterator2 = new ArrayList(this.mapPendingRequestToRequestListener.keySet()).iterator();
            while (true) {
                if (!iterator2.hasNext()) {
                    this.lockSendRequestsToService.unlock();
                    return;
                }
                ((CachedSpiceRequest)iterator2.next()).cancel();
            }
        }
    }

    private void checkServiceIsProperlyDeclaredInAndroidManifest(Context context) {
        Intent intent = new Intent(context, this.spiceServiceClass);
        if (context.getPackageManager().queryIntentServices(intent, 0).isEmpty()) {
            this.shouldStop();
            throw new RuntimeException("Impossible to start SpiceManager as no service of class : " + this.spiceServiceClass.getName() + " is registered in AndroidManifest.xml file !");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dumpMap(StringBuilder stringBuilder, Map<CachedSpiceRequest<?>, Set<RequestListener<?>>> map) {
        synchronized (map) {
            stringBuilder.append(" request count= ");
            stringBuilder.append(this.mapRequestToLaunchToRequestListener.keySet().size());
            stringBuilder.append(", listeners per requests = [");
            Iterator<Map.Entry<CachedSpiceRequest<?>, Set<RequestListener<?>>>> iterator = map.entrySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    stringBuilder.append(']');
                    stringBuilder.append('\n');
                    return;
                }
                Map.Entry<CachedSpiceRequest<?>, Set<RequestListener<?>>> entry = iterator.next();
                stringBuilder.append(entry.getKey().getClass().getName());
                stringBuilder.append(":");
                stringBuilder.append(entry.getKey());
                stringBuilder.append(" --> ");
                if (entry.getValue() == null) {
                    stringBuilder.append(entry.getValue());
                } else {
                    stringBuilder.append(entry.getValue().size());
                }
                stringBuilder.append(" listeners");
                stringBuilder.append('\n');
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean match(CachedSpiceRequest<?> cachedSpiceRequest, SpiceRequest<?> spiceRequest) {
        if (spiceRequest instanceof CachedSpiceRequest) {
            if (spiceRequest == cachedSpiceRequest) return true;
            return false;
        }
        if (cachedSpiceRequest.getSpiceRequest() != spiceRequest) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeListenersOfAllPendingCachedRequests() throws InterruptedException {
        Map<CachedSpiceRequest<?>, Set<RequestListener<?>>> map = this.mapPendingRequestToRequestListener;
        synchronized (map) {
            if (!this.mapPendingRequestToRequestListener.isEmpty()) {
                for (CachedSpiceRequest<?> cachedSpiceRequest : this.mapPendingRequestToRequestListener.keySet()) {
                    Set<RequestListener<?>> set = this.mapPendingRequestToRequestListener.get(cachedSpiceRequest);
                    if (set == null) continue;
                    Ln.d("Removing listeners of pending request : " + cachedSpiceRequest.toString() + " : " + set.size(), new Object[0]);
                    this.spiceService.dontNotifyRequestListenersForRequest(cachedSpiceRequest, set);
                }
                this.mapPendingRequestToRequestListener.clear();
            }
        }
        Ln.v("Cleared listeners of all pending requests", new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean removeListenersOfCachedRequestToLaunch(SpiceRequest<?> spiceRequest) {
        Map<CachedSpiceRequest<?>, Set<RequestListener<?>>> map = this.mapRequestToLaunchToRequestListener;
        synchronized (map) {
            CachedSpiceRequest<?> cachedSpiceRequest;
            Iterator<CachedSpiceRequest<?>> iterator = this.mapRequestToLaunchToRequestListener.keySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!this.match(cachedSpiceRequest = iterator.next(), spiceRequest));
            this.mapRequestToLaunchToRequestListener.get(cachedSpiceRequest).clear();
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeListenersOfPendingCachedRequest(SpiceRequest<?> spiceRequest) throws InterruptedException {
        Map<CachedSpiceRequest<?>, Set<RequestListener<?>>> map = this.mapPendingRequestToRequestListener;
        synchronized (map) {
            for (CachedSpiceRequest<?> cachedSpiceRequest : this.mapPendingRequestToRequestListener.keySet()) {
                if (!this.match(cachedSpiceRequest, spiceRequest)) continue;
                this.waitForServiceToBeBound();
                if (this.spiceService == null) {
                    return;
                }
                Set<RequestListener<?>> set = this.mapPendingRequestToRequestListener.get(cachedSpiceRequest);
                this.spiceService.dontNotifyRequestListenersForRequest(cachedSpiceRequest, set);
                this.mapPendingRequestToRequestListener.remove(cachedSpiceRequest);
                break;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendRequestToService(CachedSpiceRequest<?> cachedSpiceRequest) {
        this.lockSendRequestsToService.lock();
        if (cachedSpiceRequest == null) return;
        try {
            if (this.spiceService == null) return;
            if (this.isStopped) {
                this.spiceService.addRequest(cachedSpiceRequest, null);
                return;
            }
            Set<RequestListener<?>> set = this.mapRequestToLaunchToRequestListener.get(cachedSpiceRequest);
            Ln.d("Sending request to service : " + cachedSpiceRequest.getClass().getSimpleName(), new Object[0]);
            this.spiceService.addRequest(cachedSpiceRequest, set);
            return;
        }
        finally {
            this.lockSendRequestsToService.unlock();
        }
    }

    private boolean tryToStartService() {
        Context context = (Context)this.contextWeakReference.get();
        boolean bl2 = false;
        if (context != null) {
            this.checkServiceIsProperlyDeclaredInAndroidManifest(context);
            context.startService(new Intent(context, this.spiceServiceClass));
            bl2 = true;
        }
        return bl2;
    }

    private void unbindFromService(Context context) {
        if (context == null) {
            return;
        }
        this.lockAcquireService.lock();
        this.lockSendRequestsToService.lock();
        try {
            Ln.v("Unbinding from service start.", new Object[0]);
            if (this.spiceService != null && !this.isUnbinding) {
                this.isUnbinding = true;
                this.spiceService.removeSpiceServiceListener(this.removerSpiceServiceListener);
                Ln.v("Unbinding from service.", new Object[0]);
                context.getApplicationContext().unbindService((ServiceConnection)this.spiceServiceConnection);
                Ln.d("Unbound from service : " + ((Object)((Object)this.spiceService)).getClass().getSimpleName(), new Object[0]);
                this.spiceService = null;
                this.isUnbinding = false;
            }
            return;
        }
        catch (Exception exception) {
            Ln.e(exception, (Object)"Could not unbind from service.", new Object[0]);
            return;
        }
        finally {
            this.lockSendRequestsToService.unlock();
            this.lockAcquireService.unlock();
        }
    }

    public <T> void addListenerIfPending(Class<T> clazz, Object object, PendingRequestListener<T> pendingRequestListener) {
        this.addListenerIfPending(clazz, object, (RequestListener<T>)pendingRequestListener);
    }

    @Deprecated
    public <T> void addListenerIfPending(Class<T> clazz, Object object, RequestListener<T> requestListener) {
        CachedSpiceRequest cachedSpiceRequest = new CachedSpiceRequest(new SpiceRequest<T>(clazz){

            @Override
            public T loadDataFromNetwork() throws Exception {
                return null;
            }
        }, object, -1L);
        cachedSpiceRequest.setProcessable(false);
        this.execute(cachedSpiceRequest, requestListener);
    }

    public void addSpiceServiceListener(SpiceServiceListener spiceServiceListener) {
        this.executeCommand(new AddSpiceServiceListenerCommand(this, spiceServiceListener));
    }

    public void cancel(final SpiceRequest<?> spiceRequest) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                spiceRequest.cancel();
            }
        });
    }

    public <T> void cancel(Class<T> clazz, Object object) {
        CachedSpiceRequest cachedSpiceRequest = new CachedSpiceRequest(new SpiceRequest<T>(clazz){

            @Override
            public T loadDataFromNetwork() throws Exception {
                return null;
            }
        }, object, -1L);
        cachedSpiceRequest.setProcessable(false);
        cachedSpiceRequest.setOffline(true);
        cachedSpiceRequest.cancel();
        this.execute(cachedSpiceRequest, (RequestListener<T>)null);
    }

    public void cancelAllRequests() {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                SpiceManager.this.cancelAllRequestsInternal();
            }
        });
    }

    public void dontNotifyAnyRequestListeners() {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                SpiceManager.this.dontNotifyAnyRequestListenersInternal();
            }
        });
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void dontNotifyAnyRequestListenersInternal() {
        block13: {
            this.lockSendRequestsToService.lock();
            SpiceService spiceService = this.spiceService;
            if (spiceService == null) {
                this.lockSendRequestsToService.unlock();
                return;
            }
            Map<CachedSpiceRequest<?>, Set<RequestListener<?>>> map = this.mapRequestToLaunchToRequestListener;
            // MONITORENTER : map
            if (this.mapRequestToLaunchToRequestListener.isEmpty()) break block13;
            for (CachedSpiceRequest<?> cachedSpiceRequest : this.mapRequestToLaunchToRequestListener.keySet()) {
                Set<RequestListener<?>> set = this.mapRequestToLaunchToRequestListener.get(cachedSpiceRequest);
                if (set == null) continue;
                Ln.d("Removing listeners of request to launch : " + cachedSpiceRequest.toString() + " : " + set.size(), new Object[0]);
                this.spiceService.dontNotifyRequestListenersForRequest(cachedSpiceRequest, set);
            }
        }
        this.mapRequestToLaunchToRequestListener.clear();
        // MONITOREXIT : map
        try {
            Ln.v("Cleared listeners of all requests to launch", new Object[0]);
            this.removeListenersOfAllPendingCachedRequests();
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.lockSendRequestsToService.unlock();
        }
        {
            catch (InterruptedException interruptedException) {
                Ln.e(interruptedException, (Object)"Interrupted while removing listeners.", new Object[0]);
                return;
            }
        }
    }

    public void dontNotifyRequestListenersForRequest(final SpiceRequest<?> spiceRequest) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                SpiceManager.this.dontNotifyRequestListenersForRequestInternal(spiceRequest);
            }
        });
    }

    protected void dontNotifyRequestListenersForRequestInternal(SpiceRequest<?> spiceRequest) {
        block6: {
            this.lockSendRequestsToService.lock();
            boolean bl2 = this.removeListenersOfCachedRequestToLaunch(spiceRequest);
            Ln.v("Removed from requests to launch list : " + bl2, new Object[0]);
            if (bl2) break block6;
            try {
                this.removeListenersOfPendingCachedRequest(spiceRequest);
                Ln.v("Removed from pending requests list", new Object[0]);
            }
            catch (InterruptedException interruptedException) {
                Ln.e(interruptedException, (Object)"Interrupted while removing listeners.", new Object[0]);
                return;
            }
            finally {
                this.lockSendRequestsToService.unlock();
            }
        }
        this.lockSendRequestsToService.unlock();
        return;
    }

    public void dumpState() {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                block6: {
                    SpiceManager.this.lockSendRequestsToService.lock();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("[SpiceManager : ");
                    stringBuilder.append("Requests to be launched : \n");
                    SpiceManager.this.dumpMap(stringBuilder, SpiceManager.this.mapRequestToLaunchToRequestListener);
                    stringBuilder.append("Pending requests : \n");
                    SpiceManager.this.dumpMap(stringBuilder, SpiceManager.this.mapPendingRequestToRequestListener);
                    stringBuilder.append(']');
                    SpiceManager.this.waitForServiceToBeBound();
                    SpiceService spiceService = SpiceManager.this.spiceService;
                    if (spiceService != null) break block6;
                    SpiceManager.this.lockSendRequestsToService.unlock();
                    return;
                }
                try {
                    SpiceManager.this.spiceService.dumpState();
                    SpiceManager.this.lockSendRequestsToService.unlock();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    Ln.e(interruptedException, (Object)"Interrupted while waiting for acquiring service.", new Object[0]);
                    return;
                }
                finally {
                    SpiceManager.this.lockSendRequestsToService.unlock();
                }
            }
        });
    }

    public <T> void execute(CachedSpiceRequest<T> cachedSpiceRequest, RequestListener<T> requestListener) {
        this.addRequestListenerToListOfRequestListeners(cachedSpiceRequest, requestListener);
        System.out.println("adding request to request queue");
        this.requestQueue.add(cachedSpiceRequest);
    }

    public <T> void execute(SpiceRequest<T> spiceRequest, RequestListener<T> requestListener) {
        this.execute(new CachedSpiceRequest<T>(spiceRequest, null, 0L), requestListener);
    }

    public <T> void execute(SpiceRequest<T> spiceRequest, Object object, long l2, RequestListener<T> requestListener) {
        this.execute(new CachedSpiceRequest<T>(spiceRequest, object, l2), requestListener);
    }

    protected <T> Future<T> executeCommand(SpiceManagerCommand<T> spiceManagerCommand) {
        if (this.executorService == null || this.executorService.isShutdown()) {
            return null;
        }
        return this.executorService.submit(spiceManagerCommand);
    }

    public Future<List<Object>> getAllCacheKeys(Class<?> clazz) {
        return this.executeCommand(new GetAllCacheKeysCommand(this, clazz));
    }

    public <T> Future<List<T>> getAllDataFromCache(Class<T> clazz) throws CacheLoadingException {
        return this.executeCommand(new GetAllDataFromCacheCommand<T>(this, clazz));
    }

    public <T> Future<T> getDataFromCache(Class<T> clazz, Object object) throws CacheLoadingException {
        return this.executeCommand(new GetDataFromCacheCommand<T>(this, clazz, object));
    }

    public Future<Date> getDateOfDataInCache(Class<?> clazz, Object object) throws CacheCreationException {
        return this.executeCommand(new GetDateOfDataInCacheCommand(this, clazz, object));
    }

    public <T> void getFromCache(Class<T> clazz, Object object, long l2, RequestListener<T> requestListener) {
        CachedSpiceRequest cachedSpiceRequest = new CachedSpiceRequest(new SpiceRequest<T>(clazz){

            @Override
            public boolean isAggregatable() {
                return false;
            }

            @Override
            public T loadDataFromNetwork() throws Exception {
                return null;
            }
        }, object, l2);
        cachedSpiceRequest.setOffline(true);
        this.execute(cachedSpiceRequest, requestListener);
    }

    public <T> void getFromCacheAndLoadFromNetworkIfExpired(SpiceRequest<T> spiceRequest, Object object, long l2, RequestListener<T> requestListener) {
        CachedSpiceRequest<T> cachedSpiceRequest = new CachedSpiceRequest<T>(spiceRequest, object, l2);
        cachedSpiceRequest.setAcceptingDirtyCache(true);
        this.execute(cachedSpiceRequest, requestListener);
    }

    public int getPendingRequestCount() {
        return this.mapPendingRequestToRequestListener.size();
    }

    public int getRequestToLaunchCount() {
        return this.mapRequestToLaunchToRequestListener.size();
    }

    protected int getThreadCount() {
        return 3;
    }

    protected boolean isBound() {
        return this.spiceService != null;
    }

    public Future<Boolean> isDataInCache(Class<?> clazz, Object object, long l2) throws CacheCreationException {
        return this.executeCommand(new IsDataInCacheCommand(this, clazz, object, l2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isStarted() {
        synchronized (this) {
            boolean bl2 = this.isStopped;
            if (bl2) return false;
            return true;
        }
    }

    public <T> Future<T> putDataInCache(Object object, T t2) throws CacheSavingException, CacheCreationException {
        return this.executeCommand(new PutDataInCacheCommand<T>(this, t2, object));
    }

    public <T> void putInCache(Class<? super T> clazz, Object object, T t2) {
        this.putInCache(clazz, object, t2, null);
    }

    public <U, T extends U> void putInCache(Class<U> clazz, Object object, final T t2, RequestListener<U> requestListener) {
        CachedSpiceRequest cachedSpiceRequest = new CachedSpiceRequest(new SpiceRequest(clazz){

            public U loadDataFromNetwork() throws Exception {
                return t2;
            }
        }, object, -1L);
        cachedSpiceRequest.setOffline(true);
        this.execute(cachedSpiceRequest, requestListener);
    }

    public <T> void putInCache(Object object, T t2) {
        this.putInCache(t2.getClass(), object, t2);
    }

    public <T> void putInCache(Object object, T t2, RequestListener<T> requestListener) {
        this.putInCache(t2.getClass(), object, t2, requestListener);
    }

    public Future<?> removeAllDataFromCache() {
        return this.executeCommand(new RemoveAllDataFromCacheCommand(this));
    }

    public <T> Future<?> removeDataFromCache(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Clazz must be non null.");
        }
        return this.executeCommand(new RemoveDataClassFromCacheCommand(this, clazz));
    }

    public <T> Future<?> removeDataFromCache(Class<T> clazz, Object object) {
        if (clazz == null || object == null) {
            throw new IllegalArgumentException("Both parameters must be non null.");
        }
        return this.executeCommand(new RemoveDataFromCacheCommand(this, clazz, object));
    }

    public void removeSpiceServiceListener(SpiceServiceListener spiceServiceListener) {
        this.executeCommand(new RemoveSpiceServiceListenerCommand(this, spiceServiceListener));
    }

    @Override
    public void run() {
        block12: {
            if (!this.tryToStartService()) {
                Ln.d("Service was not started as Activity died prematurely", new Object[0]);
                this.isStopped = true;
                return;
            }
            this.bindToService((Context)this.contextWeakReference.get());
            this.waitForServiceToBeBound();
            SpiceService spiceService = this.spiceService;
            if (spiceService != null) break block12;
            this.unbindFromService((Context)this.contextWeakReference.get());
            return;
        }
        try {
            boolean bl2;
            while (!this.requestQueue.isEmpty() || !this.isStopped && !(bl2 = Thread.interrupted())) {
                this.sendRequestToService(this.requestQueue.take());
            }
            this.unbindFromService((Context)this.contextWeakReference.get());
            return;
        }
        catch (InterruptedException interruptedException) {
            Ln.d(interruptedException, (Object)"Interrupted while waiting for acquiring service.", new Object[0]);
        }
        finally {
            this.unbindFromService((Context)this.contextWeakReference.get());
        }
    }

    public void setFailOnCacheError(boolean bl2) {
        this.executeCommand(new SetFailOnCacheErrorCommand(this, bl2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void shouldStop() {
        synchronized (this) {
            try {
                this.shouldStopAndJoin(500L);
                return;
            }
            catch (InterruptedException interruptedException) {
                Ln.e(interruptedException, (Object)"Exception when joining the runner that was stopping.", new Object[0]);
                return;
            }
            finally {
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shouldStopAndJoin(long l2) throws InterruptedException {
        synchronized (this) {
            if (!this.isStarted()) {
                throw new IllegalStateException("Not started yet");
            }
            Ln.d("SpiceManager stopping. Joining", new Object[0]);
            this.isStopped = true;
            this.dontNotifyAnyRequestListenersInternal();
            if (this.requestQueue.isEmpty()) {
                this.runner.interrupt();
            }
            long l3 = System.currentTimeMillis();
            try {
                this.runner.join(l2);
            }
            catch (InterruptedException interruptedException) {
                try {
                    throw interruptedException;
                }
                catch (Throwable throwable) {
                    long l4 = System.currentTimeMillis();
                    Object[] objectArray = new Object[]{l4 - l3};
                    Ln.d("Runner join time (ms) when should stop %d", objectArray);
                    throw throwable;
                }
            }
            long l5 = System.currentTimeMillis();
            Object[] objectArray = new Object[]{l5 - l3};
            Ln.d("Runner join time (ms) when should stop %d", objectArray);
            this.isUnbinding = false;
            this.unbindFromService((Context)this.contextWeakReference.get());
            this.runner = null;
            this.executorService.shutdown();
            this.contextWeakReference.clear();
            Ln.d("SpiceManager stopped.", new Object[0]);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(Context context) {
        synchronized (this) {
            this.contextWeakReference = new WeakReference<Context>(context);
            if (this.isStarted()) {
                throw new IllegalStateException("Already started.");
            }
            this.executorService = Executors.newFixedThreadPool(this.getThreadCount(), new MinPriorityThreadFactory());
            StringBuilder stringBuilder = new StringBuilder().append(SPICE_MANAGER_THREAD_NAM_PREFIX);
            int n2 = this.spiceManagerThreadIndex;
            this.spiceManagerThreadIndex = n2 + 1;
            this.runner = new Thread((Runnable)this, stringBuilder.append(n2).toString());
            this.runner.setPriority(1);
            this.isStopped = false;
            this.runner.start();
            Ln.d("SpiceManager started.", new Object[0]);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitForServiceToBeBound() throws InterruptedException {
        Ln.d("Waiting for service to be bound.", new Object[0]);
        this.lockAcquireService.lock();
        try {
            while (!(this.spiceService != null || this.requestQueue.isEmpty() && this.isStopped)) {
                this.conditionServiceBound.await();
            }
            Ln.d("Bound ok.", new Object[0]);
            return;
        }
        finally {
            this.lockAcquireService.unlock();
        }
    }

    protected void waitForServiceToBeUnbound() throws InterruptedException {
        Ln.d("Waiting for service to be unbound.", new Object[0]);
        this.lockAcquireService.lock();
        try {
            while (this.spiceService != null) {
                this.conditionServiceUnbound.await();
            }
        }
        finally {
            this.lockAcquireService.unlock();
        }
    }

    private static final class MinPriorityThreadFactory
    implements ThreadFactory {
        private MinPriorityThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setPriority(1);
            return thread;
        }
    }

    private class PendingRequestHandlerSpiceServiceListener
    extends SpiceServiceAdapter {
        private PendingRequestHandlerSpiceServiceListener() {
        }

        @Override
        public void onRequestAdded(CachedSpiceRequest<?> cachedSpiceRequest, SpiceServiceListener.RequestProcessingContext requestProcessingContext) {
            Set set = (Set)SpiceManager.this.mapRequestToLaunchToRequestListener.remove(cachedSpiceRequest);
            if (set != null) {
                SpiceManager.this.mapPendingRequestToRequestListener.put(cachedSpiceRequest, set);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onRequestAggregated(CachedSpiceRequest<?> cachedSpiceRequest, SpiceServiceListener.RequestProcessingContext requestProcessingContext) {
            Set set;
            Set set2 = (Set)SpiceManager.this.mapPendingRequestToRequestListener.get(cachedSpiceRequest);
            if (set2 == null) {
                set2 = Collections.synchronizedSet(new HashSet());
                SpiceManager.this.mapPendingRequestToRequestListener.put(cachedSpiceRequest, set2);
            }
            if ((set = (Set)SpiceManager.this.mapRequestToLaunchToRequestListener.remove(cachedSpiceRequest)) != null) {
                Map map = SpiceManager.this.mapPendingRequestToRequestListener;
                synchronized (map) {
                    set2.addAll(set);
                    return;
                }
            }
        }

        @Override
        public void onRequestNotFound(CachedSpiceRequest<?> cachedSpiceRequest, SpiceServiceListener.RequestProcessingContext requestProcessingContext) {
            SpiceManager.this.mapRequestToLaunchToRequestListener.remove(cachedSpiceRequest);
        }

        @Override
        public void onRequestProcessed(CachedSpiceRequest<?> cachedSpiceRequest, SpiceServiceListener.RequestProcessingContext requestProcessingContext) {
            SpiceManager.this.mapPendingRequestToRequestListener.remove(cachedSpiceRequest);
        }
    }

    public static abstract class SpiceManagerCommand<T>
    implements Callable<T> {
        private Exception exception;
        protected SpiceManager spiceManager;
        private boolean successFull;

        public SpiceManagerCommand(SpiceManager spiceManager) {
            this.spiceManager = spiceManager;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public T call() {
            SpiceManager spiceManager = this.spiceManager;
            synchronized (spiceManager) {
                block8: {
                    if (this.spiceManager.isStopped) {
                        return null;
                    }
                    try {
                        this.spiceManager.waitForServiceToBeBound();
                        SpiceService spiceService = this.spiceManager.spiceService;
                        if (spiceService != null) break block8;
                    }
                    catch (InterruptedException interruptedException) {
                        Object[] objectArray = new Object[]{this.getClass().getName()};
                        Ln.e(interruptedException, (Object)"Spice command %s couldn't bind to service.", objectArray);
                        break block8;
                    }
                    return null;
                }
                try {
                    T t2 = this.executeWhenBound(this.spiceManager.spiceService);
                    this.successFull = true;
                    return t2;
                }
                catch (Exception exception) {
                    Ln.e(exception);
                    this.exception = exception;
                    return null;
                }
            }
        }

        protected abstract T executeWhenBound(SpiceService var1) throws Exception;

        public Exception getException() {
            return this.exception;
        }

        public boolean isSuccessFull() {
            return this.successFull;
        }
    }

    public class SpiceServiceConnection
    implements ServiceConnection {
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            SpiceManager.this.lockAcquireService.lock();
            try {
                SpiceManager.access$702(SpiceManager.this, ((SpiceService.SpiceServiceBinder)iBinder).getSpiceService());
                SpiceManager.this.spiceService.addSpiceServiceListener(SpiceManager.this.removerSpiceServiceListener);
                Ln.d("Bound to service : " + ((Object)((Object)SpiceManager.this.spiceService)).getClass().getSimpleName(), new Object[0]);
                SpiceManager.this.conditionServiceBound.signalAll();
                return;
            }
            finally {
                SpiceManager.this.lockAcquireService.unlock();
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
            SpiceManager.this.lockAcquireService.lock();
            try {
                Ln.d("Unbound from service start : " + ((Object)((Object)SpiceManager.this.spiceService)).getClass().getSimpleName(), new Object[0]);
                SpiceManager.access$702(SpiceManager.this, null);
                SpiceManager.access$1102(SpiceManager.this, false);
                SpiceManager.this.conditionServiceUnbound.signalAll();
                return;
            }
            finally {
                SpiceManager.this.lockAcquireService.unlock();
            }
        }
    }
}

