/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.utils;

import android.content.Context;
import android.os.Environment;
import com.nostra13.universalimageloader.utils.L;
import java.io.File;
import java.io.IOException;

public final class StorageUtils {
    private static final String EXTERNAL_STORAGE_PERMISSION = "android.permission.WRITE_EXTERNAL_STORAGE";
    private static final String INDIVIDUAL_DIR_NAME = "uil-images";

    private StorageUtils() {
    }

    public static File getCacheDirectory(Context context) {
        boolean bl2 = "mounted".equals(Environment.getExternalStorageState());
        File file = null;
        if (bl2) {
            boolean bl3 = StorageUtils.hasExternalStoragePermission(context);
            file = null;
            if (bl3) {
                file = StorageUtils.getExternalCacheDir(context);
            }
        }
        if (file == null) {
            file = context.getCacheDir();
        }
        if (file == null) {
            L.w("Can't define system cache directory! The app should be re-installed.", new Object[0]);
        }
        return file;
    }

    private static File getExternalCacheDir(Context context) {
        File file;
        block5: {
            block4: {
                file = new File(new File(new File(new File(Environment.getExternalStorageDirectory(), "Android"), "data"), context.getPackageName()), "cache");
                if (file.exists()) break block4;
                if (file.mkdirs()) break block5;
                L.w("Unable to create external cache directory", new Object[0]);
                file = null;
            }
            return file;
        }
        try {
            new File(file, ".nomedia").createNewFile();
            return file;
        }
        catch (IOException iOException) {
            L.i("Can't create \".nomedia\" file in application external cache directory", new Object[0]);
            return file;
        }
    }

    public static File getIndividualCacheDirectory(Context context) {
        File file = StorageUtils.getCacheDirectory(context);
        File file2 = new File(file, INDIVIDUAL_DIR_NAME);
        if (!file2.exists() && !file2.mkdir()) {
            file2 = file;
        }
        return file2;
    }

    public static File getOwnCacheDirectory(Context context, String string2) {
        boolean bl2 = "mounted".equals(Environment.getExternalStorageState());
        File file = null;
        if (bl2) {
            boolean bl3 = StorageUtils.hasExternalStoragePermission(context);
            file = null;
            if (bl3) {
                file = new File(Environment.getExternalStorageDirectory(), string2);
            }
        }
        if (file == null || !file.exists() && !file.mkdirs()) {
            file = context.getCacheDir();
        }
        return file;
    }

    private static boolean hasExternalStoragePermission(Context context) {
        return context.checkCallingOrSelfPermission(EXTERNAL_STORAGE_PERMISSION) == 0;
    }
}

