/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core.download;

import java.io.IOException;
import java.io.InputStream;

public interface ImageDownloader {
    public InputStream getStream(String var1, Object var2) throws IOException;

    public static final class Scheme
    extends Enum<Scheme> {
        private static final /* synthetic */ Scheme[] $VALUES;
        public static final /* enum */ Scheme ASSETS;
        public static final /* enum */ Scheme CONTENT;
        public static final /* enum */ Scheme DRAWABLE;
        public static final /* enum */ Scheme FILE;
        public static final /* enum */ Scheme HTTP;
        public static final /* enum */ Scheme HTTPS;
        public static final /* enum */ Scheme UNKNOWN;
        private String scheme;
        private String uriPrefix;

        static {
            HTTP = new Scheme("http");
            HTTPS = new Scheme("https");
            FILE = new Scheme("file");
            CONTENT = new Scheme("content");
            ASSETS = new Scheme("assets");
            DRAWABLE = new Scheme("drawable");
            UNKNOWN = new Scheme("");
            Scheme[] schemeArray = new Scheme[]{HTTP, HTTPS, FILE, CONTENT, ASSETS, DRAWABLE, UNKNOWN};
            $VALUES = schemeArray;
        }

        private Scheme(String string3) {
            this.scheme = string3;
            this.uriPrefix = string3 + "://";
        }

        private boolean belongsTo(String string2) {
            return string2.startsWith(this.uriPrefix);
        }

        public static Scheme ofUri(String string2) {
            if (string2 != null) {
                for (Scheme scheme : Scheme.values()) {
                    if (!scheme.belongsTo(string2)) continue;
                    return scheme;
                }
            }
            return UNKNOWN;
        }

        public static Scheme valueOf(String string2) {
            return Enum.valueOf(Scheme.class, string2);
        }

        public static Scheme[] values() {
            return (Scheme[])$VALUES.clone();
        }

        public String crop(String string2) {
            if (!this.belongsTo(string2)) {
                Object[] objectArray = new Object[]{string2, this.scheme};
                throw new IllegalArgumentException(String.format("URI [%1$s] doesn't have expected scheme [%2$s]", objectArray));
            }
            return string2.substring(this.uriPrefix.length());
        }

        public String wrap(String string2) {
            return this.uriPrefix + string2;
        }
    }
}

