/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core.download;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.net.Uri;
import com.nostra13.universalimageloader.core.download.ImageDownloader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class BaseImageDownloader
implements ImageDownloader {
    protected static final String ALLOWED_URI_CHARS = "@#&=*+-_.,:!?()/~'%";
    protected static final int BUFFER_SIZE = 32768;
    public static final int DEFAULT_HTTP_CONNECT_TIMEOUT = 5000;
    public static final int DEFAULT_HTTP_READ_TIMEOUT = 20000;
    private static final String ERROR_UNSUPPORTED_SCHEME = "UIL doesn't support scheme(protocol) by default [%s]. You should implement this support yourself (BaseImageDownloader.getStreamFromOtherSource(...))";
    protected static final int MAX_REDIRECT_COUNT = 5;
    protected final int connectTimeout;
    protected final Context context;
    protected final int readTimeout;

    public BaseImageDownloader(Context context) {
        this.context = context.getApplicationContext();
        this.connectTimeout = 5000;
        this.readTimeout = 20000;
    }

    public BaseImageDownloader(Context context, int n2, int n3) {
        this.context = context.getApplicationContext();
        this.connectTimeout = n2;
        this.readTimeout = n3;
    }

    protected HttpURLConnection createConnection(String string2) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(Uri.encode((String)string2, (String)ALLOWED_URI_CHARS)).openConnection();
        httpURLConnection.setConnectTimeout(this.connectTimeout);
        httpURLConnection.setReadTimeout(this.readTimeout);
        return httpURLConnection;
    }

    @Override
    public InputStream getStream(String string2, Object object) throws IOException {
        switch (ImageDownloader.Scheme.ofUri(string2)) {
            default: {
                return this.getStreamFromOtherSource(string2, object);
            }
            case HTTP: 
            case HTTPS: {
                return this.getStreamFromNetwork(string2, object);
            }
            case FILE: {
                return this.getStreamFromFile(string2, object);
            }
            case CONTENT: {
                return this.getStreamFromContent(string2, object);
            }
            case ASSETS: {
                return this.getStreamFromAssets(string2, object);
            }
            case DRAWABLE: 
        }
        return this.getStreamFromDrawable(string2, object);
    }

    protected InputStream getStreamFromAssets(String string2, Object object) throws IOException {
        String string3 = ImageDownloader.Scheme.ASSETS.crop(string2);
        return this.context.getAssets().open(string3);
    }

    protected InputStream getStreamFromContent(String string2, Object object) throws FileNotFoundException {
        return this.context.getContentResolver().openInputStream(Uri.parse((String)string2));
    }

    protected InputStream getStreamFromDrawable(String string2, Object object) {
        int n2 = Integer.parseInt(ImageDownloader.Scheme.DRAWABLE.crop(string2));
        Bitmap bitmap = ((BitmapDrawable)this.context.getResources().getDrawable(n2)).getBitmap();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)byteArrayOutputStream);
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    protected InputStream getStreamFromFile(String string2, Object object) throws IOException {
        return new BufferedInputStream(new FileInputStream(ImageDownloader.Scheme.FILE.crop(string2)), 32768);
    }

    protected InputStream getStreamFromNetwork(String string2, Object object) throws IOException {
        HttpURLConnection httpURLConnection = this.createConnection(string2);
        for (int i2 = 0; httpURLConnection.getResponseCode() / 100 == 3 && i2 < 5; ++i2) {
            httpURLConnection = this.createConnection(httpURLConnection.getHeaderField("Location"));
        }
        return new BufferedInputStream(httpURLConnection.getInputStream(), 32768);
    }

    protected InputStream getStreamFromOtherSource(String string2, Object object) throws IOException {
        throw new UnsupportedOperationException(String.format(ERROR_UNSUPPORTED_SCHEME, string2));
    }
}

