/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core.decode;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.os.Build;
import com.nostra13.universalimageloader.core.assist.ImageScaleType;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import com.nostra13.universalimageloader.core.assist.ViewScaleType;
import com.nostra13.universalimageloader.core.decode.ImageDecoder;
import com.nostra13.universalimageloader.core.decode.ImageDecodingInfo;
import com.nostra13.universalimageloader.core.download.ImageDownloader;
import com.nostra13.universalimageloader.utils.ImageSizeUtils;
import com.nostra13.universalimageloader.utils.IoUtils;
import com.nostra13.universalimageloader.utils.L;
import java.io.IOException;
import java.io.InputStream;

public class BaseImageDecoder
implements ImageDecoder {
    protected static final String ERROR_CANT_DECODE_IMAGE = "Image can't be decoded [%s]";
    protected static final String LOG_FLIP_IMAGE = "Flip image horizontally [%s]";
    protected static final String LOG_ROTATE_IMAGE = "Rotate image on %1$d\u00b0 [%2$s]";
    protected static final String LOG_SABSAMPLE_IMAGE = "Subsample original image (%1$s) to %2$s (scale = %3$d) [%4$s]";
    protected static final String LOG_SCALE_IMAGE = "Scale subsampled image (%1$s) to %2$s (scale = %3$.5f) [%4$s]";
    protected final boolean loggingEnabled;

    public BaseImageDecoder(boolean bl2) {
        this.loggingEnabled = bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Bitmap considerExactScaleAndOrientaiton(Bitmap bitmap, ImageDecodingInfo imageDecodingInfo, int n2, boolean bl2) {
        Bitmap bitmap2;
        boolean bl3;
        ViewScaleType viewScaleType;
        ImageSize imageSize;
        ImageSize imageSize2;
        float f2;
        Matrix matrix = new Matrix();
        ImageScaleType imageScaleType = imageDecodingInfo.getImageScaleType();
        if ((imageScaleType == ImageScaleType.EXACTLY || imageScaleType == ImageScaleType.EXACTLY_STRETCHED) && Float.compare(f2 = ImageSizeUtils.computeImageScale(imageSize2 = new ImageSize(bitmap.getWidth(), bitmap.getHeight(), n2), imageSize = imageDecodingInfo.getTargetSize(), viewScaleType = imageDecodingInfo.getViewScaleType(), bl3 = imageScaleType == ImageScaleType.EXACTLY_STRETCHED), 1.0f) != 0) {
            matrix.setScale(f2, f2);
            if (this.loggingEnabled) {
                Object[] objectArray = new Object[]{imageSize2, imageSize2.scale(f2), Float.valueOf(f2), imageDecodingInfo.getImageKey()};
                L.d(LOG_SCALE_IMAGE, objectArray);
            }
        }
        if (bl2) {
            matrix.postScale(-1.0f, 1.0f);
            if (this.loggingEnabled) {
                Object[] objectArray = new Object[]{imageDecodingInfo.getImageKey()};
                L.d(LOG_FLIP_IMAGE, objectArray);
            }
        }
        if (n2 != 0) {
            matrix.postRotate((float)n2);
            if (this.loggingEnabled) {
                Object[] objectArray = new Object[]{n2, imageDecodingInfo.getImageKey()};
                L.d(LOG_ROTATE_IMAGE, objectArray);
            }
        }
        if ((bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true)) != bitmap) {
            bitmap.recycle();
        }
        return bitmap2;
    }

    @Override
    public Bitmap decode(ImageDecodingInfo imageDecodingInfo) throws IOException {
        ImageFileInfo imageFileInfo = this.defineImageSizeAndRotation(this.getImageStream(imageDecodingInfo), imageDecodingInfo.getImageUri());
        BitmapFactory.Options options = this.prepareDecodingOptions(imageFileInfo.imageSize, imageDecodingInfo);
        Bitmap bitmap = this.decodeStream(this.getImageStream(imageDecodingInfo), options);
        if (bitmap == null) {
            Object[] objectArray = new Object[]{imageDecodingInfo.getImageKey()};
            L.e(ERROR_CANT_DECODE_IMAGE, objectArray);
            return bitmap;
        }
        return this.considerExactScaleAndOrientaiton(bitmap, imageDecodingInfo, imageFileInfo.exif.rotation, imageFileInfo.exif.flipHorizontal);
    }

    protected Bitmap decodeStream(InputStream inputStream, BitmapFactory.Options options) throws IOException {
        try {
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        finally {
            IoUtils.closeSilently(inputStream);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected ExifInfo defineExifOrientation(String var1_1, String var2_2) {
        var3_3 = "image/jpeg".equalsIgnoreCase(var2_2);
        var4_4 = false;
        var5_5 = 0;
        if (!var3_3) ** GOTO lbl-1000
        var6_6 = ImageDownloader.Scheme.ofUri(var1_1);
        var7_7 = ImageDownloader.Scheme.FILE;
        var4_4 = false;
        var5_5 = 0;
        if (var6_6 != var7_7) ** GOTO lbl-1000
        try {
            var9_8 = new ExifInterface(ImageDownloader.Scheme.FILE.crop(var1_1)).getAttributeInt("Orientation", 1);
            var5_5 = 0;
            var4_4 = false;
        }
        catch (IOException var8_9) {
            L.w("Can't read EXIF tags from file [%s]", new Object[]{var1_1});
            var4_4 = false;
            var5_5 = 0;
            ** continue;
        }
        switch (var9_8) lbl-1000:
        // 4 sources

        {
            default: lbl-1000:
            // 5 sources

            {
                return new ExifInfo(var5_5, var4_4);
            }
            case 2: {
                var4_4 = true;
            }
            case 1: {
                var5_5 = 0;
                ** GOTO lbl-1000
            }
            case 7: {
                var4_4 = true;
            }
            case 6: {
                var5_5 = 90;
                ** GOTO lbl-1000
            }
            case 4: {
                var4_4 = true;
            }
            case 3: {
                var5_5 = 180;
                ** GOTO lbl-1000
            }
            case 5: {
                var4_4 = true;
            }
            case 8: 
        }
        var5_5 = 270;
        ** GOTO lbl-1000
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ImageFileInfo defineImageSizeAndRotation(InputStream inputStream, String string2) throws IOException {
        ExifInfo exifInfo;
        BitmapFactory.Options options;
        block4: {
            options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            if (Build.VERSION.SDK_INT < 5) break block4;
            exifInfo = this.defineExifOrientation(string2, options.outMimeType);
            return new ImageFileInfo(new ImageSize(options.outWidth, options.outHeight, exifInfo.rotation), exifInfo);
            finally {
                IoUtils.closeSilently(inputStream);
            }
        }
        exifInfo = new ExifInfo();
        return new ImageFileInfo(new ImageSize(options.outWidth, options.outHeight, exifInfo.rotation), exifInfo);
    }

    protected InputStream getImageStream(ImageDecodingInfo imageDecodingInfo) throws IOException {
        return imageDecodingInfo.getDownloader().getStream(imageDecodingInfo.getImageUri(), imageDecodingInfo.getExtraForDownloader());
    }

    /*
     * Enabled aggressive block sorting
     */
    protected BitmapFactory.Options prepareDecodingOptions(ImageSize imageSize, ImageDecodingInfo imageDecodingInfo) {
        ImageScaleType imageScaleType = imageDecodingInfo.getImageScaleType();
        ImageSize imageSize2 = imageDecodingInfo.getTargetSize();
        int n2 = 1;
        if (imageScaleType != ImageScaleType.NONE) {
            boolean bl2 = imageScaleType == ImageScaleType.IN_SAMPLE_POWER_OF_2;
            n2 = ImageSizeUtils.computeImageSampleSize(imageSize, imageSize2, imageDecodingInfo.getViewScaleType(), bl2);
            if (this.loggingEnabled) {
                Object[] objectArray = new Object[]{imageSize, imageSize.scaleDown(n2), n2, imageDecodingInfo.getImageKey()};
                L.d(LOG_SABSAMPLE_IMAGE, objectArray);
            }
        }
        BitmapFactory.Options options = imageDecodingInfo.getDecodingOptions();
        options.inSampleSize = n2;
        return options;
    }

    protected static class ExifInfo {
        protected final boolean flipHorizontal;
        protected final int rotation;

        protected ExifInfo() {
            this.rotation = 0;
            this.flipHorizontal = false;
        }

        protected ExifInfo(int n2, boolean bl2) {
            this.rotation = n2;
            this.flipHorizontal = bl2;
        }
    }

    protected static class ImageFileInfo {
        protected final ExifInfo exif;
        protected final ImageSize imageSize;

        protected ImageFileInfo(ImageSize imageSize, ExifInfo exifInfo) {
            this.imageSize = imageSize;
            this.exif = exifInfo;
        }
    }
}

