/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core.assist.deque;

import com.nostra13.universalimageloader.core.assist.deque.BlockingDeque;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class LinkedBlockingDeque<E>
extends AbstractQueue<E>
implements BlockingDeque<E>,
Serializable {
    private static final long serialVersionUID = -387911632671998426L;
    private final int capacity;
    private transient int count;
    transient Node<E> first;
    transient Node<E> last;
    final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final Condition notFull = this.lock.newCondition();

    public LinkedBlockingDeque() {
        this(Integer.MAX_VALUE);
    }

    public LinkedBlockingDeque(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LinkedBlockingDeque(Collection<? extends E> collection) {
        this(Integer.MAX_VALUE);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e2;
            Iterator<E> iterator = collection.iterator();
            do {
                if (!iterator.hasNext()) return;
                e2 = iterator.next();
                if (e2 != null) continue;
                throw new NullPointerException();
            } while (super.linkLast(new Node<E>(e2)));
            throw new IllegalStateException("Deque full");
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean linkFirst(Node<E> node) {
        if (this.count >= this.capacity) {
            return false;
        }
        Node<E> node2 = this.first;
        node.next = node2;
        this.first = node;
        if (this.last == null) {
            this.last = node;
        } else {
            node2.prev = node;
        }
        this.count = 1 + this.count;
        this.notEmpty.signal();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean linkLast(Node<E> node) {
        if (this.count >= this.capacity) {
            return false;
        }
        Node<E> node2 = this.last;
        node.prev = node2;
        this.last = node;
        if (this.first == null) {
            this.first = node;
        } else {
            node2.next = node;
        }
        this.count = 1 + this.count;
        this.notEmpty.signal();
        return true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.count = 0;
        this.first = null;
        this.last = null;
        Object object;
        while ((object = objectInputStream.readObject()) != null) {
            this.add(object);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private E unlinkFirst() {
        Node<E> node = this.first;
        if (node == null) {
            return null;
        }
        Node node2 = node.next;
        Object e2 = node.item;
        node.item = null;
        node.next = node;
        this.first = node2;
        if (node2 == null) {
            this.last = null;
        } else {
            node2.prev = null;
        }
        this.count = -1 + this.count;
        this.notFull.signal();
        return e2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private E unlinkLast() {
        Node<E> node = this.last;
        if (node == null) {
            return null;
        }
        Node node2 = node.prev;
        Object e2 = node.item;
        node.item = null;
        node.prev = node;
        this.last = node2;
        if (node2 == null) {
            this.first = null;
        } else {
            node2.next = null;
        }
        this.count = -1 + this.count;
        this.notFull.signal();
        return e2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            objectOutputStream.defaultWriteObject();
            Node<E> node = this.first;
            while (node != null) {
                objectOutputStream.writeObject(node.item);
                node = node.next;
            }
            objectOutputStream.writeObject(null);
            return;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public boolean add(E e2) {
        this.addLast(e2);
        return true;
    }

    @Override
    public void addFirst(E e2) {
        if (!this.offerFirst(e2)) {
            throw new IllegalStateException("Deque full");
        }
    }

    @Override
    public void addLast(E e2) {
        if (!this.offerLast(e2)) {
            throw new IllegalStateException("Deque full");
        }
    }

    @Override
    public void clear() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        Node<E> node = this.first;
        while (node != null) {
            node.item = null;
            Node node2 = node.next;
            node.prev = null;
            node.next = null;
            node = node2;
        }
        try {
            this.last = null;
            this.first = null;
            this.count = 0;
            this.notFull.signalAll();
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public boolean contains(Object object) {
        Node<E> node;
        if (object == null) {
            return false;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            node = this.first;
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw throwable;
        }
        while (node != null) {
            block6: {
                boolean bl2 = object.equals(node.item);
                if (!bl2) break block6;
                reentrantLock.unlock();
                return true;
            }
            node = node.next;
        }
        reentrantLock.unlock();
        return false;
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingItr();
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        return this.drainTo(collection, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super E> collection, int n2) {
        int n3;
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            n3 = Math.min(n2, this.count);
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw throwable;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            collection.add(this.first.item);
            this.unlinkFirst();
            continue;
        }
        reentrantLock.unlock();
        return n3;
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E getFirst() {
        E e2 = this.peekFirst();
        if (e2 == null) {
            throw new NoSuchElementException();
        }
        return e2;
    }

    @Override
    public E getLast() {
        E e2 = this.peekLast();
        if (e2 == null) {
            throw new NoSuchElementException();
        }
        return e2;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public boolean offer(E e2) {
        return this.offerLast(e2);
    }

    @Override
    public boolean offer(E e2, long l2, TimeUnit timeUnit) throws InterruptedException {
        return this.offerLast(e2, l2, timeUnit);
    }

    @Override
    public boolean offerFirst(E e2) {
        if (e2 == null) {
            throw new NullPointerException();
        }
        Node<E> node = new Node<E>(e2);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl2 = this.linkFirst(node);
            return bl2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean offerFirst(E e2, long l2, TimeUnit timeUnit) throws InterruptedException {
        if (e2 == null) {
            throw new NullPointerException();
        }
        Node<E> node = new Node<E>(e2);
        long l3 = timeUnit.toNanos(l2);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        while (true) {
            try {
                boolean bl2 = this.linkFirst(node);
                if (bl2) break;
                if (l3 <= 0L) {
                    reentrantLock.unlock();
                    return false;
                }
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw throwable;
            }
            {
                long l4;
                l3 = l4 = this.notFull.awaitNanos(l3);
                continue;
            }
            break;
        }
        reentrantLock.unlock();
        return true;
    }

    @Override
    public boolean offerLast(E e2) {
        if (e2 == null) {
            throw new NullPointerException();
        }
        Node<E> node = new Node<E>(e2);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl2 = this.linkLast(node);
            return bl2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean offerLast(E e2, long l2, TimeUnit timeUnit) throws InterruptedException {
        if (e2 == null) {
            throw new NullPointerException();
        }
        Node<E> node = new Node<E>(e2);
        long l3 = timeUnit.toNanos(l2);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        while (true) {
            try {
                boolean bl2 = this.linkLast(node);
                if (bl2) break;
                if (l3 <= 0L) {
                    reentrantLock.unlock();
                    return false;
                }
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw throwable;
            }
            {
                long l4;
                l3 = l4 = this.notFull.awaitNanos(l3);
                continue;
            }
            break;
        }
        reentrantLock.unlock();
        return true;
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public E peekFirst() {
        E e2;
        ReentrantLock reentrantLock;
        block5: {
            reentrantLock = this.lock;
            reentrantLock.lock();
            Node<E> node = this.first;
            if (node != null) break block5;
            e2 = null;
            return e2;
        }
        try {
            e2 = this.first.item;
            return e2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public E peekLast() {
        E e2;
        ReentrantLock reentrantLock;
        block5: {
            reentrantLock = this.lock;
            reentrantLock.lock();
            Node<E> node = this.last;
            if (node != null) break block5;
            e2 = null;
            return e2;
        }
        try {
            e2 = this.last.item;
            return e2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E poll(long l2, TimeUnit timeUnit) throws InterruptedException {
        return this.pollFirst(l2, timeUnit);
    }

    @Override
    public E pollFirst() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e2 = this.unlinkFirst();
            return e2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E pollFirst(long l2, TimeUnit timeUnit) throws InterruptedException {
        E e2;
        long l3 = timeUnit.toNanos(l2);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        while (true) {
            try {
                e2 = this.unlinkFirst();
                if (e2 != null) break;
                if (l3 <= 0L) {
                    reentrantLock.unlock();
                    return null;
                }
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw throwable;
            }
            {
                long l4;
                l3 = l4 = this.notEmpty.awaitNanos(l3);
                continue;
            }
            break;
        }
        reentrantLock.unlock();
        return e2;
    }

    @Override
    public E pollLast() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e2 = this.unlinkLast();
            return e2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E pollLast(long l2, TimeUnit timeUnit) throws InterruptedException {
        E e2;
        long l3 = timeUnit.toNanos(l2);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        while (true) {
            try {
                e2 = this.unlinkLast();
                if (e2 != null) break;
                if (l3 <= 0L) {
                    reentrantLock.unlock();
                    return null;
                }
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw throwable;
            }
            {
                long l4;
                l3 = l4 = this.notEmpty.awaitNanos(l3);
                continue;
            }
            break;
        }
        reentrantLock.unlock();
        return e2;
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public void push(E e2) {
        this.addFirst(e2);
    }

    @Override
    public void put(E e2) throws InterruptedException {
        this.putLast(e2);
    }

    @Override
    public void putFirst(E e2) throws InterruptedException {
        if (e2 == null) {
            throw new NullPointerException();
        }
        Node<E> node = new Node<E>(e2);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            while (!this.linkFirst(node)) {
                this.notFull.await();
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public void putLast(E e2) throws InterruptedException {
        if (e2 == null) {
            throw new NullPointerException();
        }
        Node<E> node = new Node<E>(e2);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            while (!this.linkLast(node)) {
                this.notFull.await();
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n2 = this.capacity;
            int n3 = this.count;
            int n4 = n2 - n3;
            reentrantLock.unlock();
            return n4;
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw throwable;
        }
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public boolean remove(Object object) {
        return this.removeFirstOccurrence(object);
    }

    @Override
    public E removeFirst() {
        E e2 = this.pollFirst();
        if (e2 == null) {
            throw new NoSuchElementException();
        }
        return e2;
    }

    @Override
    public boolean removeFirstOccurrence(Object object) {
        Node<E> node;
        if (object == null) {
            return false;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            node = this.first;
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw throwable;
        }
        while (node != null) {
            block6: {
                if (!object.equals(node.item)) break block6;
                this.unlink(node);
                reentrantLock.unlock();
                return true;
            }
            node = node.next;
        }
        reentrantLock.unlock();
        return false;
    }

    @Override
    public E removeLast() {
        E e2 = this.pollLast();
        if (e2 == null) {
            throw new NoSuchElementException();
        }
        return e2;
    }

    @Override
    public boolean removeLastOccurrence(Object object) {
        Node<E> node;
        if (object == null) {
            return false;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            node = this.last;
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw throwable;
        }
        while (node != null) {
            block6: {
                if (!object.equals(node.item)) break block6;
                this.unlink(node);
                reentrantLock.unlock();
                return true;
            }
            node = node.prev;
        }
        reentrantLock.unlock();
        return false;
    }

    @Override
    public int size() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n2 = this.count;
            return n2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public E take() throws InterruptedException {
        return this.takeFirst();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E takeFirst() throws InterruptedException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e2;
            while ((e2 = this.unlinkFirst()) == null) {
                this.notEmpty.await();
            }
            return e2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E takeLast() throws InterruptedException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e2;
            while ((e2 = this.unlinkLast()) == null) {
                this.notEmpty.await();
            }
            return e2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public Object[] toArray() {
        int n2;
        Node<E> node;
        Object[] objectArray;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            objectArray = new Object[this.count];
            node = this.first;
            n2 = 0;
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw throwable;
        }
        while (node != null) {
            int n3 = n2 + 1;
            objectArray[n2] = node.item;
            node = node.next;
            n2 = n3;
        }
        reentrantLock.unlock();
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        if (objectArray.length < this.count) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.count);
        }
        Node<E> node = this.first;
        int n2 = 0;
        while (node != null) {
            int n3 = n2 + 1;
            objectArray[n2] = node.item;
            node = node.next;
            n2 = n3;
        }
        try {
            if (objectArray.length > n2) {
                objectArray[n2] = null;
            }
            return objectArray;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public String toString() {
        block8: {
            var1_1 = this.lock;
            var1_1.lock();
            var3_2 = this.first;
            if (var3_2 != null) break block8;
            var1_1.unlock();
            return "[]";
        }
        var4_3 = new StringBuilder();
        var4_3.append('[');
        while (true) {
            if ((var6_4 /* !! */  = var3_2.item) != this) ** break block9
            var6_4 /* !! */  = "(this Collection)";
            break;
        }
        {
            block10: {
                var4_3.append(var6_4 /* !! */ );
                var3_2 = var3_2.next;
                if (var3_2 != null) break block10;
                var8_5 = var4_3.append(']').toString();
                return var8_5;
            }
            var4_3.append(',').append(' ');
            continue;
        }
        finally {
            var1_1.unlock();
        }
    }

    void unlink(Node<E> node) {
        Node node2 = node.prev;
        Node node3 = node.next;
        if (node2 == null) {
            this.unlinkFirst();
            return;
        }
        if (node3 == null) {
            this.unlinkLast();
            return;
        }
        node2.next = node3;
        node3.prev = node2;
        node.item = null;
        this.count = -1 + this.count;
        this.notFull.signal();
    }

    private abstract class AbstractItr
    implements Iterator<E> {
        private Node<E> lastRet;
        Node<E> next;
        E nextItem;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        AbstractItr() {
            ReentrantLock reentrantLock = LinkedBlockingDeque.this.lock;
            reentrantLock.lock();
            try {
                this.next = this.firstNode();
                Object var4_3 = this.next == null ? null : this.next.item;
                this.nextItem = var4_3;
                return;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Node<E> succ(Node<E> node) {
            Node node2;
            while ((node2 = this.nextNode(node)) != null) {
                if (node2.item != null) return node2;
                if (node2 == node) {
                    return this.firstNode();
                }
                node = node2;
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void advance() {
            ReentrantLock reentrantLock = LinkedBlockingDeque.this.lock;
            reentrantLock.lock();
            try {
                this.next = this.succ(this.next);
                Object var3_2 = this.next == null ? null : this.next.item;
                this.nextItem = var3_2;
                return;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        abstract Node<E> firstNode();

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.next;
            Object e2 = this.nextItem;
            this.advance();
            return e2;
        }

        abstract Node<E> nextNode(Node<E> var1);

        @Override
        public void remove() {
            Node node = this.lastRet;
            if (node == null) {
                throw new IllegalStateException();
            }
            this.lastRet = null;
            ReentrantLock reentrantLock = LinkedBlockingDeque.this.lock;
            reentrantLock.lock();
            try {
                if (node.item != null) {
                    LinkedBlockingDeque.this.unlink(node);
                }
                return;
            }
            finally {
                reentrantLock.unlock();
            }
        }
    }

    private class DescendingItr
    extends AbstractItr {
        private DescendingItr() {
        }

        @Override
        Node<E> firstNode() {
            return LinkedBlockingDeque.this.last;
        }

        @Override
        Node<E> nextNode(Node<E> node) {
            return node.prev;
        }
    }

    private class Itr
    extends AbstractItr {
        private Itr() {
        }

        @Override
        Node<E> firstNode() {
            return LinkedBlockingDeque.this.first;
        }

        @Override
        Node<E> nextNode(Node<E> node) {
            return node.next;
        }
    }

    static final class Node<E> {
        E item;
        Node<E> next;
        Node<E> prev;

        Node(E e2) {
            this.item = e2;
        }
    }
}

