/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core.assist;

import android.graphics.Bitmap;
import com.nostra13.universalimageloader.cache.memory.MemoryCacheAware;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public final class MemoryCacheUtil {
    private static final String URI_AND_SIZE_SEPARATOR = "_";
    private static final String WIDTH_AND_HEIGHT_SEPARATOR = "x";

    private MemoryCacheUtil() {
    }

    public static Comparator<String> createFuzzyKeyComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String string2, String string3) {
                return string2.substring(0, string2.lastIndexOf(MemoryCacheUtil.URI_AND_SIZE_SEPARATOR)).compareTo(string3.substring(0, string3.lastIndexOf(MemoryCacheUtil.URI_AND_SIZE_SEPARATOR)));
            }
        };
    }

    public static List<String> findCacheKeysForImageUri(String string2, MemoryCacheAware<String, Bitmap> memoryCacheAware) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : memoryCacheAware.keys()) {
            if (!string3.startsWith(string2)) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public static List<Bitmap> findCachedBitmapsForImageUri(String string2, MemoryCacheAware<String, Bitmap> memoryCacheAware) {
        ArrayList<Bitmap> arrayList = new ArrayList<Bitmap>();
        for (String string3 : memoryCacheAware.keys()) {
            if (!string3.startsWith(string2)) continue;
            arrayList.add(memoryCacheAware.get(string3));
        }
        return arrayList;
    }

    public static String generateKey(String string2, ImageSize imageSize) {
        return string2 + URI_AND_SIZE_SEPARATOR + imageSize.getWidth() + WIDTH_AND_HEIGHT_SEPARATOR + imageSize.getHeight();
    }

    public static void removeFromCache(String string2, MemoryCacheAware<String, Bitmap> memoryCacheAware) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : memoryCacheAware.keys()) {
            if (!string3.startsWith(string2)) continue;
            arrayList.add(string3);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            memoryCacheAware.remove((String)iterator.next());
        }
    }
}

