/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core;

import android.graphics.Bitmap;
import android.os.Handler;
import com.nostra13.universalimageloader.core.DisplayBitmapTask;
import com.nostra13.universalimageloader.core.ImageLoaderEngine;
import com.nostra13.universalimageloader.core.ImageLoadingInfo;
import com.nostra13.universalimageloader.core.assist.LoadedFrom;
import com.nostra13.universalimageloader.utils.L;

class ProcessAndDisplayImageTask
implements Runnable {
    private static final String LOG_POSTPROCESS_IMAGE = "PostProcess image before displaying [%s]";
    private final Bitmap bitmap;
    private final ImageLoaderEngine engine;
    private final Handler handler;
    private final ImageLoadingInfo imageLoadingInfo;

    public ProcessAndDisplayImageTask(ImageLoaderEngine imageLoaderEngine, Bitmap bitmap, ImageLoadingInfo imageLoadingInfo, Handler handler) {
        this.engine = imageLoaderEngine;
        this.bitmap = bitmap;
        this.imageLoadingInfo = imageLoadingInfo;
        this.handler = handler;
    }

    @Override
    public void run() {
        if (this.engine.configuration.writeLogs) {
            Object[] objectArray = new Object[]{this.imageLoadingInfo.memoryCacheKey};
            L.d(LOG_POSTPROCESS_IMAGE, objectArray);
        }
        Bitmap bitmap = this.imageLoadingInfo.options.getPostProcessor().process(this.bitmap);
        this.handler.post((Runnable)new DisplayBitmapTask(bitmap, this.imageLoadingInfo, this.engine, LoadedFrom.MEMORY_CACHE));
    }
}

