/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core;

import android.graphics.Bitmap;
import android.os.Handler;
import android.view.View;
import android.widget.ImageView;
import com.nostra13.universalimageloader.core.DisplayBitmapTask;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.ImageLoaderEngine;
import com.nostra13.universalimageloader.core.ImageLoadingInfo;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.assist.ImageLoadingListener;
import com.nostra13.universalimageloader.core.assist.ImageScaleType;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import com.nostra13.universalimageloader.core.assist.LoadedFrom;
import com.nostra13.universalimageloader.core.assist.ViewScaleType;
import com.nostra13.universalimageloader.core.decode.ImageDecoder;
import com.nostra13.universalimageloader.core.decode.ImageDecodingInfo;
import com.nostra13.universalimageloader.core.download.ImageDownloader;
import com.nostra13.universalimageloader.utils.IoUtils;
import com.nostra13.universalimageloader.utils.L;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.util.concurrent.atomic.AtomicBoolean;

final class LoadAndDisplayImageTask
implements Runnable {
    private static final int BUFFER_SIZE = 32768;
    private static final String ERROR_POST_PROCESSOR_NULL = "Pre-processor returned null [%s]";
    private static final String ERROR_PRE_PROCESSOR_NULL = "Pre-processor returned null [%s]";
    private static final String ERROR_PROCESSOR_FOR_DISC_CACHE_NULL = "Bitmap processor for disc cache returned null [%s]";
    private static final String LOG_CACHE_IMAGE_IN_MEMORY = "Cache image in memory [%s]";
    private static final String LOG_CACHE_IMAGE_ON_DISC = "Cache image on disc [%s]";
    private static final String LOG_DELAY_BEFORE_LOADING = "Delay %d ms before loading...  [%s]";
    private static final String LOG_GET_IMAGE_FROM_MEMORY_CACHE_AFTER_WAITING = "...Get cached bitmap from memory after waiting. [%s]";
    private static final String LOG_LOAD_IMAGE_FROM_DISC_CACHE = "Load image from disc cache [%s]";
    private static final String LOG_LOAD_IMAGE_FROM_NETWORK = "Load image from network [%s]";
    private static final String LOG_POSTPROCESS_IMAGE = "PostProcess image before displaying [%s]";
    private static final String LOG_PREPROCESS_IMAGE = "PreProcess image before caching in memory [%s]";
    private static final String LOG_PROCESS_IMAGE_BEFORE_CACHE_ON_DISC = "Process image before cache on disc [%s]";
    private static final String LOG_RESUME_AFTER_PAUSE = ".. Resume loading [%s]";
    private static final String LOG_START_DISPLAY_IMAGE_TASK = "Start display image task [%s]";
    private static final String LOG_TASK_CANCELLED_IMAGEVIEW_LOST = "ImageView was collected by GC. Task is cancelled. [%s]";
    private static final String LOG_TASK_CANCELLED_IMAGEVIEW_REUSED = "ImageView is reused for another image. Task is cancelled. [%s]";
    private static final String LOG_TASK_INTERRUPTED = "Task was interrupted [%s]";
    private static final String LOG_WAITING_FOR_IMAGE_LOADED = "Image already is loading. Waiting... [%s]";
    private static final String LOG_WAITING_FOR_RESUME = "ImageLoader is paused. Waiting...  [%s]";
    private final ImageLoaderConfiguration configuration;
    private final ImageDecoder decoder;
    private final ImageDownloader downloader;
    private final ImageLoaderEngine engine;
    private final Handler handler;
    private final ImageLoadingInfo imageLoadingInfo;
    private boolean imageViewCollected = false;
    final Reference<ImageView> imageViewRef;
    final ImageLoadingListener listener;
    private LoadedFrom loadedFrom = LoadedFrom.NETWORK;
    private final String memoryCacheKey;
    private final ImageDownloader networkDeniedDownloader;
    final DisplayImageOptions options;
    private final ImageDownloader slowNetworkDownloader;
    private final ImageSize targetSize;
    final String uri;
    private final boolean writeLogs;

    public LoadAndDisplayImageTask(ImageLoaderEngine imageLoaderEngine, ImageLoadingInfo imageLoadingInfo, Handler handler) {
        this.engine = imageLoaderEngine;
        this.imageLoadingInfo = imageLoadingInfo;
        this.handler = handler;
        this.configuration = imageLoaderEngine.configuration;
        this.downloader = this.configuration.downloader;
        this.networkDeniedDownloader = this.configuration.networkDeniedDownloader;
        this.slowNetworkDownloader = this.configuration.slowNetworkDownloader;
        this.decoder = this.configuration.decoder;
        this.writeLogs = this.configuration.writeLogs;
        this.uri = imageLoadingInfo.uri;
        this.memoryCacheKey = imageLoadingInfo.memoryCacheKey;
        this.imageViewRef = imageLoadingInfo.imageViewRef;
        this.targetSize = imageLoadingInfo.targetSize;
        this.options = imageLoadingInfo.options;
        this.listener = imageLoadingInfo.listener;
    }

    private ImageView checkImageViewRef() {
        ImageView imageView = this.imageViewRef.get();
        if (imageView == null) {
            this.imageViewCollected = true;
            this.log(LOG_TASK_CANCELLED_IMAGEVIEW_LOST);
            this.fireCancelEvent();
        }
        return imageView;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkImageViewReused(ImageView imageView) {
        String string2 = this.engine.getLoadingUriForView(imageView);
        if (this.memoryCacheKey.equals(string2)) return false;
        boolean bl2 = true;
        if (!bl2) return bl2;
        this.log(LOG_TASK_CANCELLED_IMAGEVIEW_REUSED);
        this.fireCancelEvent();
        return bl2;
    }

    private boolean checkTaskIsInterrupted() {
        boolean bl2 = Thread.interrupted();
        if (bl2) {
            this.log(LOG_TASK_INTERRUPTED);
        }
        return bl2;
    }

    private boolean checkTaskIsNotActual() {
        ImageView imageView = this.checkImageViewRef();
        return imageView == null || this.checkImageViewReused(imageView);
    }

    private Bitmap decodeImage(String string2) throws IOException {
        ImageView imageView = this.checkImageViewRef();
        if (imageView == null) {
            return null;
        }
        ViewScaleType viewScaleType = ViewScaleType.fromImageView(imageView);
        ImageDecodingInfo imageDecodingInfo = new ImageDecodingInfo(this.memoryCacheKey, string2, this.targetSize, viewScaleType, this.getDownloader(), this.options);
        return this.decoder.decode(imageDecodingInfo);
    }

    private boolean delayIfNeed() {
        if (this.options.shouldDelayBeforeLoading()) {
            Object[] objectArray = new Object[]{this.options.getDelayBeforeLoading(), this.memoryCacheKey};
            this.log(LOG_DELAY_BEFORE_LOADING, objectArray);
            try {
                Thread.sleep(this.options.getDelayBeforeLoading());
                return this.checkTaskIsNotActual();
            }
            catch (InterruptedException interruptedException) {
                Object[] objectArray2 = new Object[]{this.memoryCacheKey};
                L.e(LOG_TASK_INTERRUPTED, objectArray2);
                return true;
            }
        }
        return false;
    }

    /*
     * Loose catch block
     */
    private void downloadImage(File file) throws IOException {
        InputStream inputStream = this.getDownloader().getStream(this.uri, this.options.getExtraForDownloader());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), 32768);
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        try {
            IoUtils.copyStream(inputStream, bufferedOutputStream);
        }
        catch (Throwable throwable) {
            IoUtils.closeSilently(bufferedOutputStream);
            throw throwable;
        }
        try {
            IoUtils.closeSilently(bufferedOutputStream);
            return;
        }
        finally {
            IoUtils.closeSilently(inputStream);
        }
    }

    private boolean downloadSizedImage(File file, int n2, int n3) throws IOException {
        ImageSize imageSize = new ImageSize(n2, n3);
        DisplayImageOptions displayImageOptions = new DisplayImageOptions.Builder().cloneFrom(this.options).imageScaleType(ImageScaleType.IN_SAMPLE_INT).build();
        ImageDecodingInfo imageDecodingInfo = new ImageDecodingInfo(this.memoryCacheKey, this.uri, imageSize, ViewScaleType.FIT_INSIDE, this.getDownloader(), displayImageOptions);
        Bitmap bitmap = this.decoder.decode(imageDecodingInfo);
        if (bitmap == null) {
            return false;
        }
        if (this.configuration.processorForDiscCache != null) {
            this.log(LOG_PROCESS_IMAGE_BEFORE_CACHE_ON_DISC);
            bitmap = this.configuration.processorForDiscCache.process(bitmap);
            if (bitmap == null) {
                Object[] objectArray = new Object[]{this.memoryCacheKey};
                L.e(ERROR_PROCESSOR_FOR_DISC_CACHE_NULL, objectArray);
                return false;
            }
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), 32768);
        try {
            boolean bl2 = bitmap.compress(this.configuration.imageCompressFormatForDiscCache, this.configuration.imageQualityForDiscCache, (OutputStream)bufferedOutputStream);
            bitmap.recycle();
            return bl2;
        }
        finally {
            IoUtils.closeSilently(bufferedOutputStream);
        }
    }

    private void fireCancelEvent() {
        if (!Thread.interrupted()) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    LoadAndDisplayImageTask.this.listener.onLoadingCancelled(LoadAndDisplayImageTask.this.uri, (View)LoadAndDisplayImageTask.this.imageViewRef.get());
                }
            });
        }
    }

    private void fireFailEvent(final FailReason.FailType failType, final Throwable throwable) {
        if (!Thread.interrupted()) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    ImageView imageView = LoadAndDisplayImageTask.this.imageViewRef.get();
                    if (imageView != null && LoadAndDisplayImageTask.this.options.shouldShowImageOnFail()) {
                        imageView.setImageResource(LoadAndDisplayImageTask.this.options.getImageOnFail());
                    }
                    LoadAndDisplayImageTask.this.listener.onLoadingFailed(LoadAndDisplayImageTask.this.uri, (View)imageView, new FailReason(failType, throwable));
                }
            });
        }
    }

    private ImageDownloader getDownloader() {
        if (this.engine.isNetworkDenied()) {
            return this.networkDeniedDownloader;
        }
        if (this.engine.isSlowNetwork()) {
            return this.slowNetworkDownloader;
        }
        return this.downloader;
    }

    private File getImageFileInDiscCache() {
        File file;
        File file2 = this.configuration.discCache.get(this.uri);
        File file3 = file2.getParentFile();
        if (!(file3 != null && (file3.exists() || file3.mkdirs()) || (file = (file2 = this.configuration.reserveDiscCache.get(this.uri)).getParentFile()) == null || file.exists())) {
            file.mkdirs();
        }
        return file2;
    }

    private void log(String string2) {
        if (this.writeLogs) {
            Object[] objectArray = new Object[]{this.memoryCacheKey};
            L.d(string2, objectArray);
        }
    }

    private void log(String string2, Object ... objectArray) {
        if (this.writeLogs) {
            L.d(string2, objectArray);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String tryCacheImageOnDisc(File file) {
        this.log(LOG_CACHE_IMAGE_ON_DISC);
        try {
            boolean bl2;
            block7: {
                int n2;
                int n3;
                block6: {
                    n3 = this.configuration.maxImageWidthForDiscCache;
                    n2 = this.configuration.maxImageHeightForDiscCache;
                    if (n3 > 0) break block6;
                    bl2 = false;
                    if (n2 <= 0) break block7;
                }
                bl2 = this.downloadSizedImage(file, n3, n2);
            }
            if (!bl2) {
                this.downloadImage(file);
            }
            this.configuration.discCache.put(this.uri, file);
            return ImageDownloader.Scheme.FILE.wrap(file.getAbsolutePath());
        }
        catch (IOException iOException) {
            L.e(iOException);
            return this.uri;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Bitmap tryLoadBitmap() {
        File file = this.getImageFileInDiscCache();
        Bitmap bitmap = null;
        try {
            boolean bl2 = file.exists();
            bitmap = null;
            if (bl2) {
                this.log(LOG_LOAD_IMAGE_FROM_DISC_CACHE);
                this.loadedFrom = LoadedFrom.DISC_CACHE;
                bitmap = this.decodeImage(ImageDownloader.Scheme.FILE.wrap(file.getAbsolutePath()));
                if (this.imageViewCollected) {
                    return null;
                }
            }
            if (bitmap != null && bitmap.getWidth() > 0) {
                if (bitmap.getHeight() > 0) return bitmap;
            }
            this.log(LOG_LOAD_IMAGE_FROM_NETWORK);
            this.loadedFrom = LoadedFrom.NETWORK;
            String string2 = this.options.isCacheOnDisc() ? this.tryCacheImageOnDisc(file) : this.uri;
            if (this.checkTaskIsNotActual()) return bitmap;
            bitmap = this.decodeImage(string2);
            if (this.imageViewCollected) return null;
            if (bitmap != null && bitmap.getWidth() > 0) {
                if (bitmap.getHeight() > 0) return bitmap;
            }
            this.fireFailEvent(FailReason.FailType.DECODING_ERROR, null);
            return bitmap;
        }
        catch (IllegalStateException illegalStateException) {
            this.fireFailEvent(FailReason.FailType.NETWORK_DENIED, null);
            return bitmap;
        }
        catch (IOException iOException) {
            L.e(iOException);
            this.fireFailEvent(FailReason.FailType.IO_ERROR, iOException);
            if (!file.exists()) return bitmap;
            file.delete();
            return bitmap;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            L.e(outOfMemoryError);
            this.fireFailEvent(FailReason.FailType.OUT_OF_MEMORY, outOfMemoryError);
            return bitmap;
        }
        catch (Throwable throwable) {
            L.e(throwable);
            this.fireFailEvent(FailReason.FailType.UNKNOWN, throwable);
            return bitmap;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean waitIfPaused() {
        AtomicBoolean atomicBoolean = this.engine.getPause();
        synchronized (atomicBoolean) {
            if (atomicBoolean.get()) {
                this.log(LOG_WAITING_FOR_RESUME);
                try {
                    atomicBoolean.wait();
                    this.log(LOG_RESUME_AFTER_PAUSE);
                }
                catch (InterruptedException interruptedException) {
                    Object[] objectArray = new Object[]{this.memoryCacheKey};
                    L.e(LOG_TASK_INTERRUPTED, objectArray);
                    return true;
                }
            }
            return this.checkTaskIsNotActual();
        }
    }

    String getLoadingUri() {
        return this.uri;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block20: {
            block24: {
                block23: {
                    block22: {
                        block21: {
                            block19: {
                                if (this.waitIfPaused()) lbl-1000:
                                // 3 sources

                                {
                                    return;
                                }
                                if (this.delayIfNeed()) ** GOTO lbl-1000
                                var1_1 = this.imageLoadingInfo.loadFromUriLock;
                                this.log("Start display image task [%s]");
                                if (var1_1.isLocked()) {
                                    this.log("Image already is loading. Waiting... [%s]");
                                }
                                var1_1.lock();
                                var3_2 = this.checkTaskIsNotActual();
                                if (!var3_2) break block19;
                                var1_1.unlock();
                                return;
                            }
                            var4_3 = this.configuration.memoryCache.get(this.memoryCacheKey);
                            if (var4_3 != null) break block20;
                            var4_3 = this.tryLoadBitmap();
                            var5_4 = this.imageViewCollected;
                            if (var5_4) {
                                var1_1.unlock();
                                return;
                            }
                            if (var4_3 != null) break block21;
                            var1_1.unlock();
                            return;
                        }
                        if (!this.checkTaskIsNotActual() && !(var6_5 = this.checkTaskIsInterrupted())) break block22;
                        var1_1.unlock();
                        return;
                    }
                    if (!this.options.shouldPreProcess()) break block23;
                    this.log("PreProcess image before caching in memory [%s]");
                    var4_3 = this.options.getPreProcessor().process(var4_3);
                    if (var4_3 != null) break block23;
                    L.e("Pre-processor returned null [%s]", new Object[0]);
                }
                if (var4_3 != null) {
                    if (!this.options.isCacheInMemory()) break block24;
                    this.log("Cache image in memory [%s]");
                    this.configuration.memoryCache.put(this.memoryCacheKey, var4_3);
                }
            }
lbl49:
            // 2 sources

            while (true) {
                block25: {
                    if (var4_3 != null) {
                        if (!this.options.shouldPostProcess()) break block25;
                        this.log("PostProcess image before displaying [%s]");
                        var4_3 = this.options.getPostProcessor().process(var4_3);
                        if (var4_3 != null) break block25;
                        var9_6 = new Object[]{this.memoryCacheKey};
                        L.e("Pre-processor returned null [%s]", var9_6);
                    }
                }
                if (!this.checkTaskIsNotActual() && !this.checkTaskIsInterrupted()) ** break;
                ** continue;
                var7_7 = new DisplayBitmapTask(var4_3, this.imageLoadingInfo, this.engine, this.loadedFrom);
                var7_7.setLoggingEnabled(this.writeLogs);
                this.handler.post((Runnable)var7_7);
                return;
            }
        }
        try {
            this.loadedFrom = LoadedFrom.MEMORY_CACHE;
            this.log("...Get cached bitmap from memory after waiting. [%s]");
            ** continue;
        }
        catch (Throwable var2_8) {
            throw var2_8;
        }
        finally {
            var1_1.unlock();
        }
    }
}

