/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core;

import android.widget.ImageView;
import com.nostra13.universalimageloader.core.DefaultConfigurationFactory;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.LoadAndDisplayImageTask;
import com.nostra13.universalimageloader.core.ProcessAndDisplayImageTask;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

class ImageLoaderEngine {
    private final Map<Integer, String> cacheKeysForImageViews = Collections.synchronizedMap(new HashMap());
    final ImageLoaderConfiguration configuration;
    private final AtomicBoolean networkDenied;
    private final AtomicBoolean paused;
    private final AtomicBoolean slowNetwork;
    private ExecutorService taskDistributor;
    private Executor taskExecutor;
    private Executor taskExecutorForCachedImages;
    private final Map<String, ReentrantLock> uriLocks = new WeakHashMap<String, ReentrantLock>();

    ImageLoaderEngine(ImageLoaderConfiguration imageLoaderConfiguration) {
        this.paused = new AtomicBoolean(false);
        this.networkDenied = new AtomicBoolean(false);
        this.slowNetwork = new AtomicBoolean(false);
        this.configuration = imageLoaderConfiguration;
        this.taskExecutor = imageLoaderConfiguration.taskExecutor;
        this.taskExecutorForCachedImages = imageLoaderConfiguration.taskExecutorForCachedImages;
        this.taskDistributor = Executors.newCachedThreadPool();
    }

    private Executor createTaskExecutor() {
        return DefaultConfigurationFactory.createExecutor(this.configuration.threadPoolSize, this.configuration.threadPriority, this.configuration.tasksProcessingType);
    }

    private void initExecutorsIfNeed() {
        if (!this.configuration.customExecutor && ((ExecutorService)this.taskExecutor).isShutdown()) {
            this.taskExecutor = this.createTaskExecutor();
        }
        if (!this.configuration.customExecutorForCachedImages && ((ExecutorService)this.taskExecutorForCachedImages).isShutdown()) {
            this.taskExecutorForCachedImages = this.createTaskExecutor();
        }
    }

    void cancelDisplayTaskFor(ImageView imageView) {
        this.cacheKeysForImageViews.remove(imageView.hashCode());
    }

    void denyNetworkDownloads(boolean bl2) {
        this.networkDenied.set(bl2);
    }

    String getLoadingUriForView(ImageView imageView) {
        return this.cacheKeysForImageViews.get(imageView.hashCode());
    }

    ReentrantLock getLockForUri(String string2) {
        ReentrantLock reentrantLock = this.uriLocks.get(string2);
        if (reentrantLock == null) {
            reentrantLock = new ReentrantLock();
            this.uriLocks.put(string2, reentrantLock);
        }
        return reentrantLock;
    }

    AtomicBoolean getPause() {
        return this.paused;
    }

    void handleSlowNetwork(boolean bl2) {
        this.slowNetwork.set(bl2);
    }

    boolean isNetworkDenied() {
        return this.networkDenied.get();
    }

    boolean isSlowNetwork() {
        return this.slowNetwork.get();
    }

    void pause() {
        this.paused.set(true);
    }

    void prepareDisplayTaskFor(ImageView imageView, String string2) {
        this.cacheKeysForImageViews.put(imageView.hashCode(), string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void resume() {
        AtomicBoolean atomicBoolean = this.paused;
        synchronized (atomicBoolean) {
            this.paused.set(false);
            this.paused.notifyAll();
            return;
        }
    }

    void stop() {
        if (!this.configuration.customExecutor) {
            ((ExecutorService)this.taskExecutor).shutdownNow();
        }
        if (!this.configuration.customExecutorForCachedImages) {
            ((ExecutorService)this.taskExecutorForCachedImages).shutdownNow();
        }
        this.cacheKeysForImageViews.clear();
        this.uriLocks.clear();
    }

    void submit(final LoadAndDisplayImageTask loadAndDisplayImageTask) {
        this.taskDistributor.execute(new Runnable(){

            @Override
            public void run() {
                boolean bl2 = ImageLoaderEngine.this.configuration.discCache.get(loadAndDisplayImageTask.getLoadingUri()).exists();
                ImageLoaderEngine.this.initExecutorsIfNeed();
                if (bl2) {
                    ImageLoaderEngine.this.taskExecutorForCachedImages.execute(loadAndDisplayImageTask);
                    return;
                }
                ImageLoaderEngine.this.taskExecutor.execute(loadAndDisplayImageTask);
            }
        });
    }

    void submit(ProcessAndDisplayImageTask processAndDisplayImageTask) {
        this.initExecutorsIfNeed();
        this.taskExecutorForCachedImages.execute(processAndDisplayImageTask);
    }
}

