/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core;

import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.nostra13.universalimageloader.cache.disc.DiscCacheAware;
import com.nostra13.universalimageloader.cache.memory.MemoryCacheAware;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.ImageLoaderEngine;
import com.nostra13.universalimageloader.core.ImageLoadingInfo;
import com.nostra13.universalimageloader.core.LoadAndDisplayImageTask;
import com.nostra13.universalimageloader.core.ProcessAndDisplayImageTask;
import com.nostra13.universalimageloader.core.assist.ImageLoadingListener;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import com.nostra13.universalimageloader.core.assist.LoadedFrom;
import com.nostra13.universalimageloader.core.assist.MemoryCacheUtil;
import com.nostra13.universalimageloader.core.assist.SimpleImageLoadingListener;
import com.nostra13.universalimageloader.core.display.BitmapDisplayer;
import com.nostra13.universalimageloader.core.display.FakeBitmapDisplayer;
import com.nostra13.universalimageloader.utils.ImageSizeUtils;
import com.nostra13.universalimageloader.utils.L;
import java.util.concurrent.locks.ReentrantLock;

public class ImageLoader {
    private static final String ERROR_INIT_CONFIG_WITH_NULL = "ImageLoader configuration can not be initialized with null";
    private static final String ERROR_NOT_INIT = "ImageLoader must be init with configuration before using";
    private static final String ERROR_WRONG_ARGUMENTS = "Wrong arguments were passed to displayImage() method (ImageView reference must not be null)";
    static final String LOG_DESTROY = "Destroy ImageLoader";
    static final String LOG_INIT_CONFIG = "Initialize ImageLoader with configuration";
    static final String LOG_LOAD_IMAGE_FROM_MEMORY_CACHE = "Load image from memory cache [%s]";
    public static final String TAG = ImageLoader.class.getSimpleName();
    private static final String WARNING_RE_INIT_CONFIG = "Try to initialize ImageLoader which had already been initialized before. To re-init ImageLoader with new configuration call ImageLoader.destroy() at first.";
    private static volatile ImageLoader instance;
    private ImageLoaderConfiguration configuration;
    private final ImageLoadingListener emptyListener = new SimpleImageLoadingListener();
    private ImageLoaderEngine engine;
    private final BitmapDisplayer fakeBitmapDisplayer = new FakeBitmapDisplayer();

    protected ImageLoader() {
    }

    private void checkConfiguration() {
        if (this.configuration == null) {
            throw new IllegalStateException(ERROR_NOT_INIT);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImageLoader getInstance() {
        if (instance == null) {
            synchronized (ImageLoader.class) {
                if (instance == null) {
                    instance = new ImageLoader();
                }
            }
        }
        return instance;
    }

    public void cancelDisplayTask(ImageView imageView) {
        this.engine.cancelDisplayTaskFor(imageView);
    }

    public void clearDiscCache() {
        this.checkConfiguration();
        this.configuration.discCache.clear();
    }

    public void clearMemoryCache() {
        this.checkConfiguration();
        this.configuration.memoryCache.clear();
    }

    public void denyNetworkDownloads(boolean bl2) {
        this.engine.denyNetworkDownloads(bl2);
    }

    public void destroy() {
        if (this.configuration != null && this.configuration.writeLogs) {
            L.d(LOG_DESTROY, new Object[0]);
        }
        this.stop();
        this.engine = null;
        this.configuration = null;
    }

    public void displayImage(String string2, ImageView imageView) {
        this.displayImage(string2, imageView, null, null);
    }

    public void displayImage(String string2, ImageView imageView, DisplayImageOptions displayImageOptions) {
        this.displayImage(string2, imageView, displayImageOptions, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void displayImage(String string2, ImageView imageView, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener) {
        this.checkConfiguration();
        if (imageView == null) {
            throw new IllegalArgumentException(ERROR_WRONG_ARGUMENTS);
        }
        if (imageLoadingListener == null) {
            imageLoadingListener = this.emptyListener;
        }
        if (displayImageOptions == null) {
            displayImageOptions = this.configuration.defaultDisplayImageOptions;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.engine.cancelDisplayTaskFor(imageView);
            imageLoadingListener.onLoadingStarted(string2, (View)imageView);
            if (displayImageOptions.shouldShowImageForEmptyUri()) {
                imageView.setImageResource(displayImageOptions.getImageForEmptyUri());
            } else {
                imageView.setImageDrawable(null);
            }
            imageLoadingListener.onLoadingComplete(string2, (View)imageView, null);
            return;
        }
        ImageSize imageSize = ImageSizeUtils.defineTargetSizeForView(imageView, this.configuration.maxImageWidthForMemoryCache, this.configuration.maxImageHeightForMemoryCache);
        String string3 = MemoryCacheUtil.generateKey(string2, imageSize);
        this.engine.prepareDisplayTaskFor(imageView, string3);
        imageLoadingListener.onLoadingStarted(string2, (View)imageView);
        Bitmap bitmap = this.configuration.memoryCache.get(string3);
        if (bitmap != null && !bitmap.isRecycled()) {
            if (this.configuration.writeLogs) {
                L.d(LOG_LOAD_IMAGE_FROM_MEMORY_CACHE, string3);
            }
            if (displayImageOptions.shouldPostProcess()) {
                ReentrantLock reentrantLock = this.engine.getLockForUri(string2);
                ImageLoadingInfo imageLoadingInfo = new ImageLoadingInfo(string2, imageView, imageSize, string3, displayImageOptions, imageLoadingListener, reentrantLock);
                ProcessAndDisplayImageTask processAndDisplayImageTask = new ProcessAndDisplayImageTask(this.engine, bitmap, imageLoadingInfo, displayImageOptions.getHandler());
                this.engine.submit(processAndDisplayImageTask);
                return;
            }
            displayImageOptions.getDisplayer().display(bitmap, imageView, LoadedFrom.MEMORY_CACHE);
            imageLoadingListener.onLoadingComplete(string2, (View)imageView, bitmap);
            return;
        }
        if (displayImageOptions.shouldShowStubImage()) {
            imageView.setImageResource(displayImageOptions.getStubImage());
        } else if (displayImageOptions.isResetViewBeforeLoading()) {
            imageView.setImageDrawable(null);
        }
        ReentrantLock reentrantLock = this.engine.getLockForUri(string2);
        ImageLoadingInfo imageLoadingInfo = new ImageLoadingInfo(string2, imageView, imageSize, string3, displayImageOptions, imageLoadingListener, reentrantLock);
        LoadAndDisplayImageTask loadAndDisplayImageTask = new LoadAndDisplayImageTask(this.engine, imageLoadingInfo, displayImageOptions.getHandler());
        this.engine.submit(loadAndDisplayImageTask);
    }

    public void displayImage(String string2, ImageView imageView, ImageLoadingListener imageLoadingListener) {
        this.displayImage(string2, imageView, null, imageLoadingListener);
    }

    public DiscCacheAware getDiscCache() {
        this.checkConfiguration();
        return this.configuration.discCache;
    }

    public String getLoadingUriForView(ImageView imageView) {
        return this.engine.getLoadingUriForView(imageView);
    }

    public MemoryCacheAware<String, Bitmap> getMemoryCache() {
        this.checkConfiguration();
        return this.configuration.memoryCache;
    }

    public void handleSlowNetwork(boolean bl2) {
        this.engine.handleSlowNetwork(bl2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(ImageLoaderConfiguration imageLoaderConfiguration) {
        synchronized (this) {
            if (imageLoaderConfiguration == null) {
                throw new IllegalArgumentException(ERROR_INIT_CONFIG_WITH_NULL);
            }
            if (this.configuration == null) {
                if (imageLoaderConfiguration.writeLogs) {
                    L.d(LOG_INIT_CONFIG, new Object[0]);
                }
                this.engine = new ImageLoaderEngine(imageLoaderConfiguration);
                this.configuration = imageLoaderConfiguration;
            } else {
                L.w(WARNING_RE_INIT_CONFIG, new Object[0]);
            }
            return;
        }
    }

    public boolean isInited() {
        return this.configuration != null;
    }

    public void loadImage(String string2, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener) {
        this.loadImage(string2, null, displayImageOptions, imageLoadingListener);
    }

    public void loadImage(String string2, ImageLoadingListener imageLoadingListener) {
        this.loadImage(string2, null, null, imageLoadingListener);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void loadImage(String string2, ImageSize imageSize, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener) {
        this.checkConfiguration();
        if (imageSize == null) {
            imageSize = new ImageSize(this.configuration.maxImageWidthForMemoryCache, this.configuration.maxImageHeightForMemoryCache);
        }
        if (displayImageOptions == null) {
            displayImageOptions = this.configuration.defaultDisplayImageOptions;
        }
        DisplayImageOptions displayImageOptions2 = displayImageOptions.getDisplayer() instanceof FakeBitmapDisplayer ? displayImageOptions : new DisplayImageOptions.Builder().cloneFrom(displayImageOptions).displayer(this.fakeBitmapDisplayer).build();
        ImageView imageView = new ImageView(this.configuration.context);
        imageView.setLayoutParams(new ViewGroup.LayoutParams(imageSize.getWidth(), imageSize.getHeight()));
        imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.displayImage(string2, imageView, displayImageOptions2, imageLoadingListener);
    }

    public void loadImage(String string2, ImageSize imageSize, ImageLoadingListener imageLoadingListener) {
        this.loadImage(string2, imageSize, null, imageLoadingListener);
    }

    public void pause() {
        this.engine.pause();
    }

    public void resume() {
        this.engine.resume();
    }

    public void stop() {
        this.engine.stop();
    }
}

