/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core;

import android.graphics.Bitmap;
import android.view.View;
import android.widget.ImageView;
import com.nostra13.universalimageloader.core.ImageLoaderEngine;
import com.nostra13.universalimageloader.core.ImageLoadingInfo;
import com.nostra13.universalimageloader.core.assist.ImageLoadingListener;
import com.nostra13.universalimageloader.core.assist.LoadedFrom;
import com.nostra13.universalimageloader.core.display.BitmapDisplayer;
import com.nostra13.universalimageloader.utils.L;
import java.lang.ref.Reference;

final class DisplayBitmapTask
implements Runnable {
    private static final String LOG_DISPLAY_IMAGE_IN_IMAGEVIEW = "Display image in ImageView (loaded from %1$s) [%2$s]";
    private static final String LOG_TASK_CANCELLED_IMAGEVIEW_LOST = "ImageView was collected by GC. Task is cancelled. [%s]";
    private static final String LOG_TASK_CANCELLED_IMAGEVIEW_REUSED = "ImageView is reused for another image. Task is cancelled. [%s]";
    private final Bitmap bitmap;
    private final BitmapDisplayer displayer;
    private final ImageLoaderEngine engine;
    private final String imageUri;
    private final Reference<ImageView> imageViewRef;
    private final ImageLoadingListener listener;
    private final LoadedFrom loadedFrom;
    private boolean loggingEnabled;
    private final String memoryCacheKey;

    public DisplayBitmapTask(Bitmap bitmap, ImageLoadingInfo imageLoadingInfo, ImageLoaderEngine imageLoaderEngine, LoadedFrom loadedFrom) {
        this.bitmap = bitmap;
        this.imageUri = imageLoadingInfo.uri;
        this.imageViewRef = imageLoadingInfo.imageViewRef;
        this.memoryCacheKey = imageLoadingInfo.memoryCacheKey;
        this.displayer = imageLoadingInfo.options.getDisplayer();
        this.listener = imageLoadingInfo.listener;
        this.engine = imageLoaderEngine;
        this.loadedFrom = loadedFrom;
    }

    private boolean isViewWasReused(ImageView imageView) {
        String string2 = this.engine.getLoadingUriForView(imageView);
        return !this.memoryCacheKey.equals(string2);
    }

    @Override
    public void run() {
        ImageView imageView = this.imageViewRef.get();
        if (imageView == null) {
            if (this.loggingEnabled) {
                Object[] objectArray = new Object[]{this.memoryCacheKey};
                L.d(LOG_TASK_CANCELLED_IMAGEVIEW_LOST, objectArray);
            }
            this.listener.onLoadingCancelled(this.imageUri, (View)imageView);
            return;
        }
        if (this.isViewWasReused(imageView)) {
            if (this.loggingEnabled) {
                Object[] objectArray = new Object[]{this.memoryCacheKey};
                L.d(LOG_TASK_CANCELLED_IMAGEVIEW_REUSED, objectArray);
            }
            this.listener.onLoadingCancelled(this.imageUri, (View)imageView);
            return;
        }
        if (this.loggingEnabled) {
            Object[] objectArray = new Object[]{this.loadedFrom, this.memoryCacheKey};
            L.d(LOG_DISPLAY_IMAGE_IN_IMAGEVIEW, objectArray);
        }
        Bitmap bitmap = this.displayer.display(this.bitmap, imageView, this.loadedFrom);
        this.listener.onLoadingComplete(this.imageUri, (View)imageView, bitmap);
        this.engine.cancelDisplayTaskFor(imageView);
    }

    void setLoggingEnabled(boolean bl2) {
        this.loggingEnabled = bl2;
    }
}

