/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import com.nostra13.universalimageloader.cache.disc.DiscCacheAware;
import com.nostra13.universalimageloader.cache.disc.impl.FileCountLimitedDiscCache;
import com.nostra13.universalimageloader.cache.disc.impl.TotalSizeLimitedDiscCache;
import com.nostra13.universalimageloader.cache.disc.impl.UnlimitedDiscCache;
import com.nostra13.universalimageloader.cache.disc.naming.FileNameGenerator;
import com.nostra13.universalimageloader.cache.disc.naming.HashCodeFileNameGenerator;
import com.nostra13.universalimageloader.cache.memory.MemoryCacheAware;
import com.nostra13.universalimageloader.cache.memory.impl.LRULimitedMemoryCache;
import com.nostra13.universalimageloader.cache.memory.impl.LruMemoryCache;
import com.nostra13.universalimageloader.core.assist.QueueProcessingType;
import com.nostra13.universalimageloader.core.assist.deque.LIFOLinkedBlockingDeque;
import com.nostra13.universalimageloader.core.decode.BaseImageDecoder;
import com.nostra13.universalimageloader.core.decode.ImageDecoder;
import com.nostra13.universalimageloader.core.display.BitmapDisplayer;
import com.nostra13.universalimageloader.core.display.SimpleBitmapDisplayer;
import com.nostra13.universalimageloader.core.download.BaseImageDownloader;
import com.nostra13.universalimageloader.core.download.ImageDownloader;
import com.nostra13.universalimageloader.utils.StorageUtils;
import java.io.File;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultConfigurationFactory {
    public static BitmapDisplayer createBitmapDisplayer() {
        return new SimpleBitmapDisplayer();
    }

    public static DiscCacheAware createDiscCache(Context context, FileNameGenerator fileNameGenerator, int n2, int n3) {
        if (n2 > 0) {
            return new TotalSizeLimitedDiscCache(StorageUtils.getIndividualCacheDirectory(context), fileNameGenerator, n2);
        }
        if (n3 > 0) {
            return new FileCountLimitedDiscCache(StorageUtils.getIndividualCacheDirectory(context), fileNameGenerator, n3);
        }
        return new UnlimitedDiscCache(StorageUtils.getCacheDirectory(context), fileNameGenerator);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Executor createExecutor(int n2, int n3, QueueProcessingType queueProcessingType) {
        void var4_5;
        boolean bl2 = queueProcessingType == QueueProcessingType.LIFO;
        if (bl2) {
            LIFOLinkedBlockingDeque lIFOLinkedBlockingDeque = new LIFOLinkedBlockingDeque();
        } else {
            LinkedBlockingQueue linkedBlockingQueue = new LinkedBlockingQueue();
        }
        BlockingQueue blockingQueue = (BlockingQueue)var4_5;
        return new ThreadPoolExecutor(n2, n2, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)blockingQueue, DefaultConfigurationFactory.createThreadFactory(n3));
    }

    public static FileNameGenerator createFileNameGenerator() {
        return new HashCodeFileNameGenerator();
    }

    public static ImageDecoder createImageDecoder(boolean bl2) {
        return new BaseImageDecoder(bl2);
    }

    public static ImageDownloader createImageDownloader(Context context) {
        return new BaseImageDownloader(context);
    }

    public static MemoryCacheAware<String, Bitmap> createMemoryCache(int n2) {
        if (n2 == 0) {
            n2 = (int)(Runtime.getRuntime().maxMemory() / 8L);
        }
        if (Build.VERSION.SDK_INT >= 9) {
            return new LruMemoryCache(n2);
        }
        return new LRULimitedMemoryCache(n2);
    }

    public static DiscCacheAware createReserveDiscCache(Context context) {
        File file = context.getCacheDir();
        File file2 = new File(file, "uil-images");
        if (file2.exists() || file2.mkdir()) {
            file = file2;
        }
        return new TotalSizeLimitedDiscCache(file, 0x200000);
    }

    private static ThreadFactory createThreadFactory(int n2) {
        return new DefaultThreadFactory(n2);
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final String namePrefix;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final int threadPriority;

        /*
         * Enabled aggressive block sorting
         */
        DefaultThreadFactory(int n2) {
            this.threadPriority = n2;
            SecurityManager securityManager = System.getSecurityManager();
            ThreadGroup threadGroup = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.group = threadGroup;
            this.namePrefix = "pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            thread.setPriority(this.threadPriority);
            return thread;
        }
    }
}

