/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.memory.impl;

import android.graphics.Bitmap;
import com.nostra13.universalimageloader.cache.memory.LimitedMemoryCache;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class UsingFreqLimitedMemoryCache
extends LimitedMemoryCache<String, Bitmap> {
    private final Map<Bitmap, Integer> usingCounts = Collections.synchronizedMap(new HashMap());

    public UsingFreqLimitedMemoryCache(int n2) {
        super(n2);
    }

    @Override
    public void clear() {
        this.usingCounts.clear();
        super.clear();
    }

    @Override
    protected Reference<Bitmap> createReference(Bitmap bitmap) {
        return new WeakReference<Bitmap>(bitmap);
    }

    @Override
    public Bitmap get(String string2) {
        Integer n2;
        Bitmap bitmap = (Bitmap)super.get(string2);
        if (bitmap != null && (n2 = this.usingCounts.get(bitmap)) != null) {
            this.usingCounts.put(bitmap, 1 + n2);
        }
        return bitmap;
    }

    @Override
    protected int getSize(Bitmap bitmap) {
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    @Override
    public boolean put(String string2, Bitmap bitmap) {
        boolean bl2 = super.put(string2, bitmap);
        boolean bl3 = false;
        if (bl2) {
            this.usingCounts.put(bitmap, 0);
            bl3 = true;
        }
        return bl3;
    }

    @Override
    public void remove(String string2) {
        Bitmap bitmap = (Bitmap)super.get(string2);
        if (bitmap != null) {
            this.usingCounts.remove(bitmap);
        }
        super.remove(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Bitmap removeNext() {
        Integer n2 = null;
        Bitmap bitmap = null;
        Set<Map.Entry<Bitmap, Integer>> set = this.usingCounts.entrySet();
        Map<Bitmap, Integer> map = this.usingCounts;
        synchronized (map) {
            Iterator<Map.Entry<Bitmap, Integer>> iterator = set.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    // MONITOREXIT @DISABLED, blocks:[2, 3, 5] lbl9 : MonitorExitStatement: MONITOREXIT : var4_4
                    this.usingCounts.remove(bitmap);
                    return bitmap;
                }
                Map.Entry<Bitmap, Integer> entry = iterator.next();
                if (bitmap == null) {
                    bitmap = entry.getKey();
                    n2 = entry.getValue();
                    continue;
                }
                Integer n3 = entry.getValue();
                if (n3 >= n2) continue;
                n2 = n3;
                bitmap = entry.getKey();
            }
        }
    }
}

