/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.memory.impl;

import com.nostra13.universalimageloader.cache.memory.MemoryCacheAware;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LimitedAgeMemoryCache<K, V>
implements MemoryCacheAware<K, V> {
    private final MemoryCacheAware<K, V> cache;
    private final Map<K, Long> loadingDates = Collections.synchronizedMap(new HashMap());
    private final long maxAge;

    public LimitedAgeMemoryCache(MemoryCacheAware<K, V> memoryCacheAware, long l2) {
        this.cache = memoryCacheAware;
        this.maxAge = 1000L * l2;
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.loadingDates.clear();
    }

    @Override
    public V get(K k2) {
        Long l2 = this.loadingDates.get(k2);
        if (l2 != null && System.currentTimeMillis() - l2 > this.maxAge) {
            this.cache.remove(k2);
            this.loadingDates.remove(k2);
        }
        return this.cache.get(k2);
    }

    @Override
    public Collection<K> keys() {
        return this.cache.keys();
    }

    @Override
    public boolean put(K k2, V v2) {
        boolean bl2 = this.cache.put(k2, v2);
        if (bl2) {
            this.loadingDates.put(k2, System.currentTimeMillis());
        }
        return bl2;
    }

    @Override
    public void remove(K k2) {
        this.cache.remove(k2);
        this.loadingDates.remove(k2);
    }
}

