/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.memory.impl;

import android.graphics.Bitmap;
import com.nostra13.universalimageloader.cache.memory.LimitedMemoryCache;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRULimitedMemoryCache
extends LimitedMemoryCache<String, Bitmap> {
    private static final int INITIAL_CAPACITY = 10;
    private static final float LOAD_FACTOR = 1.1f;
    private final Map<String, Bitmap> lruCache = Collections.synchronizedMap(new LinkedHashMap(10, 1.1f, true));

    public LRULimitedMemoryCache(int n2) {
        super(n2);
    }

    @Override
    public void clear() {
        this.lruCache.clear();
        super.clear();
    }

    @Override
    protected Reference<Bitmap> createReference(Bitmap bitmap) {
        return new WeakReference<Bitmap>(bitmap);
    }

    @Override
    public Bitmap get(String string2) {
        this.lruCache.get(string2);
        return (Bitmap)super.get(string2);
    }

    @Override
    protected int getSize(Bitmap bitmap) {
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    @Override
    public boolean put(String string2, Bitmap bitmap) {
        if (super.put(string2, bitmap)) {
            this.lruCache.put(string2, bitmap);
            return true;
        }
        return false;
    }

    @Override
    public void remove(String string2) {
        this.lruCache.remove(string2);
        super.remove(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Bitmap removeNext() {
        Map<String, Bitmap> map = this.lruCache;
        synchronized (map) {
            Iterator<Map.Entry<String, Bitmap>> iterator = this.lruCache.entrySet().iterator();
            boolean bl2 = iterator.hasNext();
            Bitmap bitmap = null;
            if (bl2) {
                bitmap = iterator.next().getValue();
                iterator.remove();
            }
            return bitmap;
        }
    }
}

