/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.memory;

import com.nostra13.universalimageloader.cache.memory.BaseMemoryCache;
import com.nostra13.universalimageloader.utils.L;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class LimitedMemoryCache<K, V>
extends BaseMemoryCache<K, V> {
    private static final int MAX_NORMAL_CACHE_SIZE = 0x1000000;
    private static final int MAX_NORMAL_CACHE_SIZE_IN_MB = 16;
    private final AtomicInteger cacheSize;
    private final List<V> hardCache = Collections.synchronizedList(new LinkedList());
    private final int sizeLimit;

    public LimitedMemoryCache(int n2) {
        this.sizeLimit = n2;
        this.cacheSize = new AtomicInteger();
        if (n2 > 0x1000000) {
            Object[] objectArray = new Object[]{16};
            L.w("You set too large memory cache size (more than %1$d Mb)", objectArray);
        }
    }

    @Override
    public void clear() {
        this.hardCache.clear();
        this.cacheSize.set(0);
        super.clear();
    }

    protected abstract int getSize(V var1);

    protected int getSizeLimit() {
        return this.sizeLimit;
    }

    @Override
    public boolean put(K k2, V v2) {
        int n2 = this.getSize(v2);
        int n3 = this.getSizeLimit();
        int n4 = this.cacheSize.get();
        boolean bl2 = false;
        if (n2 < n3) {
            while (n4 + n2 > n3) {
                V v3 = this.removeNext();
                if (!this.hardCache.remove(v3)) continue;
                n4 = this.cacheSize.addAndGet(-this.getSize(v3));
            }
            this.hardCache.add(v2);
            this.cacheSize.addAndGet(n2);
            bl2 = true;
        }
        super.put(k2, v2);
        return bl2;
    }

    @Override
    public void remove(K k2) {
        Object v2 = super.get(k2);
        if (v2 != null && this.hardCache.remove(v2)) {
            this.cacheSize.addAndGet(-this.getSize(v2));
        }
        super.remove(k2);
    }

    protected abstract V removeNext();
}

