/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.memory;

import com.nostra13.universalimageloader.cache.memory.MemoryCacheAware;
import java.lang.ref.Reference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class BaseMemoryCache<K, V>
implements MemoryCacheAware<K, V> {
    private final Map<K, Reference<V>> softMap = Collections.synchronizedMap(new HashMap());

    @Override
    public void clear() {
        this.softMap.clear();
    }

    protected abstract Reference<V> createReference(V var1);

    @Override
    public V get(K k2) {
        Reference<V> reference = this.softMap.get(k2);
        V v2 = null;
        if (reference != null) {
            v2 = reference.get();
        }
        return v2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<K> keys() {
        Map<K, Reference<V>> map = this.softMap;
        synchronized (map) {
            return new HashSet<K>(this.softMap.keySet());
        }
    }

    @Override
    public boolean put(K k2, V v2) {
        this.softMap.put(k2, this.createReference(v2));
        return true;
    }

    @Override
    public void remove(K k2) {
        this.softMap.remove(k2);
    }
}

