/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.disc.impl;

import com.nostra13.universalimageloader.cache.disc.BaseDiscCache;
import com.nostra13.universalimageloader.cache.disc.naming.FileNameGenerator;
import com.nostra13.universalimageloader.core.DefaultConfigurationFactory;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LimitedAgeDiscCache
extends BaseDiscCache {
    private final Map<File, Long> loadingDates = Collections.synchronizedMap(new HashMap());
    private final long maxFileAge;

    public LimitedAgeDiscCache(File file, long l2) {
        this(file, DefaultConfigurationFactory.createFileNameGenerator(), l2);
    }

    public LimitedAgeDiscCache(File file, FileNameGenerator fileNameGenerator, long l2) {
        super(file, fileNameGenerator);
        this.maxFileAge = 1000L * l2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public File get(String string2) {
        boolean bl2;
        File file = super.get(string2);
        if (!file.exists()) return file;
        Long l2 = this.loadingDates.get(file);
        if (l2 == null) {
            bl2 = false;
            l2 = file.lastModified();
        } else {
            bl2 = true;
        }
        if (System.currentTimeMillis() - l2 > this.maxFileAge) {
            file.delete();
            this.loadingDates.remove(file);
            return file;
        } else {
            if (bl2) return file;
            this.loadingDates.put(file, l2);
            return file;
        }
    }

    @Override
    public void put(String string2, File file) {
        long l2 = System.currentTimeMillis();
        file.setLastModified(l2);
        this.loadingDates.put(file, l2);
    }
}

