/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.disc;

import com.nostra13.universalimageloader.cache.disc.BaseDiscCache;
import com.nostra13.universalimageloader.cache.disc.naming.FileNameGenerator;
import com.nostra13.universalimageloader.core.DefaultConfigurationFactory;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class LimitedDiscCache
extends BaseDiscCache {
    private static final int INVALID_SIZE = -1;
    private final AtomicInteger cacheSize;
    private final Map<File, Long> lastUsageDates = Collections.synchronizedMap(new HashMap());
    private final int sizeLimit;

    public LimitedDiscCache(File file, int n2) {
        this(file, DefaultConfigurationFactory.createFileNameGenerator(), n2);
    }

    public LimitedDiscCache(File file, FileNameGenerator fileNameGenerator, int n2) {
        super(file, fileNameGenerator);
        this.sizeLimit = n2;
        this.cacheSize = new AtomicInteger();
        this.calculateCacheSizeAndFillUsageMap();
    }

    private void calculateCacheSizeAndFillUsageMap() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                int n2 = 0;
                File[] fileArray = LimitedDiscCache.this.cacheDir.listFiles();
                if (fileArray != null) {
                    for (File file : fileArray) {
                        n2 += LimitedDiscCache.this.getSize(file);
                        LimitedDiscCache.this.lastUsageDates.put(file, file.lastModified());
                    }
                    LimitedDiscCache.this.cacheSize.set(n2);
                }
            }
        }).start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int removeNext() {
        if (this.lastUsageDates.isEmpty()) {
            return -1;
        }
        Long l2 = null;
        File file = null;
        Set<Map.Entry<File, Long>> set = this.lastUsageDates.entrySet();
        Map<File, Long> map = this.lastUsageDates;
        synchronized (map) {
            for (Map.Entry<File, Long> entry : set) {
                if (file == null) {
                    file = entry.getKey();
                    l2 = entry.getValue();
                    continue;
                }
                Long l3 = entry.getValue();
                if (l3 >= l2) continue;
                l2 = l3;
                file = entry.getKey();
            }
        }
        int n2 = 0;
        if (file == null) return n2;
        if (!file.exists()) {
            this.lastUsageDates.remove(file);
            return 0;
        }
        n2 = this.getSize(file);
        if (!file.delete()) return n2;
        this.lastUsageDates.remove(file);
        return n2;
    }

    @Override
    public void clear() {
        this.lastUsageDates.clear();
        this.cacheSize.set(0);
        super.clear();
    }

    @Override
    public File get(String string2) {
        File file = super.get(string2);
        Long l2 = System.currentTimeMillis();
        file.setLastModified(l2);
        this.lastUsageDates.put(file, l2);
        return file;
    }

    protected abstract int getSize(File var1);

    @Override
    public void put(String string2, File file) {
        int n2 = this.getSize(file);
        int n3 = this.cacheSize.get();
        while (true) {
            int n4;
            if (n3 + n2 <= this.sizeLimit || (n4 = this.removeNext()) == -1) {
                this.cacheSize.addAndGet(n2);
                Long l2 = System.currentTimeMillis();
                file.setLastModified(l2);
                this.lastUsageDates.put(file, l2);
                return;
            }
            n3 = this.cacheSize.addAndGet(-n4);
        }
    }
}

