/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.disc;

import com.nostra13.universalimageloader.cache.disc.DiscCacheAware;
import com.nostra13.universalimageloader.cache.disc.naming.FileNameGenerator;
import com.nostra13.universalimageloader.core.DefaultConfigurationFactory;
import java.io.File;

public abstract class BaseDiscCache
implements DiscCacheAware {
    private static final String ERROR_ARG_NULL = "\"%s\" argument must be not null";
    protected File cacheDir;
    private FileNameGenerator fileNameGenerator;

    public BaseDiscCache(File file) {
        this(file, DefaultConfigurationFactory.createFileNameGenerator());
    }

    public BaseDiscCache(File file, FileNameGenerator fileNameGenerator) {
        if (file == null) {
            throw new IllegalArgumentException(String.format(ERROR_ARG_NULL, "cacheDir"));
        }
        if (fileNameGenerator == null) {
            throw new IllegalArgumentException(String.format(ERROR_ARG_NULL, "fileNameGenerator"));
        }
        this.cacheDir = file;
        this.fileNameGenerator = fileNameGenerator;
    }

    @Override
    public void clear() {
        File[] fileArray = this.cacheDir.listFiles();
        if (fileArray != null) {
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                fileArray[i2].delete();
            }
        }
    }

    @Override
    public File get(String string2) {
        String string3 = this.fileNameGenerator.generate(string2);
        return new File(this.cacheDir, string3);
    }
}

