/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads.util.vast;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class VastXmlManager {
    private static final String ROOT_TAG = "MPMoVideoXMLDocRoot";
    private static final String ROOT_TAG_CLOSE = "</MPMoVideoXMLDocRoot>";
    private static final String ROOT_TAG_OPEN = "<MPMoVideoXMLDocRoot>";
    private Document mVastDoc;

    VastXmlManager() {
    }

    private List<String> getStringDataAsList(VastElementName vastElementName) {
        return this.getStringDataAsList(vastElementName, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<String> getStringDataAsList(VastElementName vastElementName, VastElementAttributeName vastElementAttributeName, VastElementAttributeValue vastElementAttributeValue) {
        NodeList nodeList;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.mVastDoc != null && (nodeList = this.mVastDoc.getElementsByTagName(vastElementName.getName())) != null) {
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                String string2;
                Node node;
                Node node2 = nodeList.item(i2);
                if (node2 == null || !this.nodeMatchesFilter(node2, vastElementAttributeName, vastElementAttributeValue) || (node = node2.getFirstChild()) == null || (string2 = node.getNodeValue()) == null) continue;
                arrayList.add(string2.trim());
            }
        }
        return arrayList;
    }

    private List<String> getVideoTrackerByAttribute(VastElementAttributeValue vastElementAttributeValue) {
        return this.getStringDataAsList(VastElementName.VIDEO_TRACKER, VastElementAttributeName.EVENT, vastElementAttributeValue);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean nodeMatchesFilter(Node node, VastElementAttributeName vastElementAttributeName, VastElementAttributeValue vastElementAttributeValue) {
        Node node2;
        NamedNodeMap namedNodeMap;
        return vastElementAttributeName == null || vastElementAttributeValue == null || (namedNodeMap = node.getAttributes()) != null && (node2 = namedNodeMap.getNamedItem(vastElementAttributeName.getName())) != null && vastElementAttributeValue.getValue().equals(node2.getNodeValue());
    }

    String getClickThroughUrl() {
        List<String> list = this.getStringDataAsList(VastElementName.CLICK_THROUGH);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    List<String> getClickTrackers() {
        return this.getStringDataAsList(VastElementName.CLICK_TRACKER);
    }

    List<String> getImpressionTrackers() {
        List<String> list = this.getStringDataAsList(VastElementName.IMPRESSION_TRACKER);
        list.addAll(this.getStringDataAsList(VastElementName.MP_IMPRESSION_TRACKER));
        return list;
    }

    String getMediaFileUrl() {
        List<String> list = this.getStringDataAsList(VastElementName.MEDIA_FILE);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    String getVastAdTagURI() {
        List<String> list = this.getStringDataAsList(VastElementName.VAST_AD_TAG);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    List<String> getVideoCompleteTrackers() {
        return this.getVideoTrackerByAttribute(VastElementAttributeValue.COMPLETE);
    }

    List<String> getVideoFirstQuartileTrackers() {
        return this.getVideoTrackerByAttribute(VastElementAttributeValue.FIRST_QUARTILE);
    }

    List<String> getVideoMidpointTrackers() {
        return this.getVideoTrackerByAttribute(VastElementAttributeValue.MIDPOINT);
    }

    List<String> getVideoStartTrackers() {
        return this.getVideoTrackerByAttribute(VastElementAttributeValue.START);
    }

    List<String> getVideoThirdQuartileTrackers() {
        return this.getVideoTrackerByAttribute(VastElementAttributeValue.THIRD_QUARTILE);
    }

    void parseVastXml(String string2) throws ParserConfigurationException, IOException, SAXException {
        String string3 = string2.replaceFirst("<\\?.*\\?>", "");
        String string4 = ROOT_TAG_OPEN + string3 + ROOT_TAG_CLOSE;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setCoalescing(true);
        this.mVastDoc = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(new StringReader(string4)));
    }

    static final class VastElementAttributeName
    extends Enum<VastElementAttributeName> {
        private static final /* synthetic */ VastElementAttributeName[] $VALUES;
        public static final /* enum */ VastElementAttributeName EVENT = new VastElementAttributeName("event");
        private final String name;

        static {
            VastElementAttributeName[] vastElementAttributeNameArray = new VastElementAttributeName[]{EVENT};
            $VALUES = vastElementAttributeNameArray;
        }

        private VastElementAttributeName(String string3) {
            this.name = string3;
        }

        public static VastElementAttributeName valueOf(String string2) {
            return Enum.valueOf(VastElementAttributeName.class, string2);
        }

        public static VastElementAttributeName[] values() {
            return (VastElementAttributeName[])$VALUES.clone();
        }

        public String getName() {
            return this.name;
        }
    }

    static final class VastElementAttributeValue
    extends Enum<VastElementAttributeValue> {
        private static final /* synthetic */ VastElementAttributeValue[] $VALUES;
        public static final /* enum */ VastElementAttributeValue COMPLETE;
        public static final /* enum */ VastElementAttributeValue FIRST_QUARTILE;
        public static final /* enum */ VastElementAttributeValue MIDPOINT;
        public static final /* enum */ VastElementAttributeValue START;
        public static final /* enum */ VastElementAttributeValue THIRD_QUARTILE;
        private final String value;

        static {
            START = new VastElementAttributeValue("start");
            FIRST_QUARTILE = new VastElementAttributeValue("firstQuartile");
            MIDPOINT = new VastElementAttributeValue("midpoint");
            THIRD_QUARTILE = new VastElementAttributeValue("thirdQuartile");
            COMPLETE = new VastElementAttributeValue("complete");
            VastElementAttributeValue[] vastElementAttributeValueArray = new VastElementAttributeValue[]{START, FIRST_QUARTILE, MIDPOINT, THIRD_QUARTILE, COMPLETE};
            $VALUES = vastElementAttributeValueArray;
        }

        private VastElementAttributeValue(String string3) {
            this.value = string3;
        }

        public static VastElementAttributeValue valueOf(String string2) {
            return Enum.valueOf(VastElementAttributeValue.class, string2);
        }

        public static VastElementAttributeValue[] values() {
            return (VastElementAttributeValue[])$VALUES.clone();
        }

        public String getValue() {
            return this.value;
        }
    }

    static final class VastElementName
    extends Enum<VastElementName> {
        private static final /* synthetic */ VastElementName[] $VALUES;
        public static final /* enum */ VastElementName CLICK_THROUGH;
        public static final /* enum */ VastElementName CLICK_TRACKER;
        public static final /* enum */ VastElementName IMPRESSION_TRACKER;
        public static final /* enum */ VastElementName MEDIA_FILE;
        public static final /* enum */ VastElementName MP_IMPRESSION_TRACKER;
        public static final /* enum */ VastElementName VAST_AD_TAG;
        public static final /* enum */ VastElementName VIDEO_TRACKER;
        private final String name;

        static {
            IMPRESSION_TRACKER = new VastElementName("Impression");
            VIDEO_TRACKER = new VastElementName("Tracking");
            CLICK_THROUGH = new VastElementName("ClickThrough");
            CLICK_TRACKER = new VastElementName("ClickTracking");
            MEDIA_FILE = new VastElementName("MediaFile");
            VAST_AD_TAG = new VastElementName("VASTAdTagURI");
            MP_IMPRESSION_TRACKER = new VastElementName("MP_TRACKING_URL");
            VastElementName[] vastElementNameArray = new VastElementName[]{IMPRESSION_TRACKER, VIDEO_TRACKER, CLICK_THROUGH, CLICK_TRACKER, MEDIA_FILE, VAST_AD_TAG, MP_IMPRESSION_TRACKER};
            $VALUES = vastElementNameArray;
        }

        private VastElementName(String string3) {
            this.name = string3;
        }

        public static VastElementName valueOf(String string2) {
            return Enum.valueOf(VastElementName.class, string2);
        }

        public static VastElementName[] values() {
            return (VastElementName[])$VALUES.clone();
        }

        public String getName() {
            return this.name;
        }
    }
}

