/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads.util.vast;

import android.os.AsyncTask;
import com.mopub.mobileads.factories.HttpClientFactory;
import com.mopub.mobileads.util.HttpClients;
import com.mopub.mobileads.util.Strings;
import com.mopub.mobileads.util.vast.VastXmlManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.xml.sax.SAXException;

public class VastManager {
    static final int MAX_TIMES_TO_FOLLOW_VAST_REDIRECT = 20;
    static final int VAST_REDIRECT_TIMEOUT_MILLISECONDS = 30000;
    private String mClickThroughUrl;
    private List<String> mClickTrackers;
    private HttpClient mHttpClient;
    private List<String> mImpressionTrackers = new ArrayList<String>();
    private VastManagerListener mListener;
    private String mMediaFileUrl;
    private int mTimesFollowedVastRedirect;
    private ProcessVastBackgroundTask mVastBackgroundTask;
    private List<String> mVideoCompleteTrackers;
    private List<String> mVideoFirstQuartileTrackers;
    private List<String> mVideoMidpointTrackers;
    private List<String> mVideoStartTrackers = new ArrayList<String>();
    private List<String> mVideoThirdQuartileTrackers;

    public VastManager() {
        this.mVideoFirstQuartileTrackers = new ArrayList<String>();
        this.mVideoMidpointTrackers = new ArrayList<String>();
        this.mVideoThirdQuartileTrackers = new ArrayList<String>();
        this.mVideoCompleteTrackers = new ArrayList<String>();
        this.mClickTrackers = new ArrayList<String>();
        this.mHttpClient = HttpClientFactory.create(30000);
    }

    private void loadVastDataFromXml(VastXmlManager vastXmlManager) {
        this.mImpressionTrackers.addAll(vastXmlManager.getImpressionTrackers());
        this.mVideoStartTrackers.addAll(vastXmlManager.getVideoStartTrackers());
        this.mVideoFirstQuartileTrackers.addAll(vastXmlManager.getVideoFirstQuartileTrackers());
        this.mVideoMidpointTrackers.addAll(vastXmlManager.getVideoMidpointTrackers());
        this.mVideoThirdQuartileTrackers.addAll(vastXmlManager.getVideoThirdQuartileTrackers());
        this.mVideoCompleteTrackers.addAll(vastXmlManager.getVideoCompleteTrackers());
        this.mClickTrackers.addAll(vastXmlManager.getClickTrackers());
        if (this.mClickThroughUrl == null) {
            this.mClickThroughUrl = vastXmlManager.getClickThroughUrl();
        }
        if (this.mMediaFileUrl == null) {
            this.mMediaFileUrl = vastXmlManager.getMediaFileUrl();
        }
    }

    private String processVastFollowingRedirect(String string2) throws IOException, SAXException, ParserConfigurationException {
        VastXmlManager vastXmlManager = new VastXmlManager();
        vastXmlManager.parseVastXml(string2);
        this.loadVastDataFromXml(vastXmlManager);
        String string3 = vastXmlManager.getVastAdTagURI();
        String string4 = null;
        if (string3 != null) {
            int n2 = this.mTimesFollowedVastRedirect;
            string4 = null;
            if (n2 < 20) {
                this.mTimesFollowedVastRedirect = 1 + this.mTimesFollowedVastRedirect;
                HttpGet httpGet = new HttpGet(string3);
                HttpEntity httpEntity = this.mHttpClient.execute((HttpUriRequest)httpGet).getEntity();
                string4 = null;
                if (httpEntity != null) {
                    string4 = Strings.fromStream(httpEntity.getContent());
                }
            }
        }
        return string4;
    }

    private void vastProcessComplete(boolean bl2) {
        HttpClients.safeShutdown(this.mHttpClient);
        this.mTimesFollowedVastRedirect = 0;
        this.mVastBackgroundTask = null;
        if (!bl2) {
            this.mListener.onComplete(this);
        }
    }

    public void cancel() {
        if (this.mVastBackgroundTask != null) {
            this.mVastBackgroundTask.cancel(true);
        }
    }

    public String getClickThroughUrl() {
        return this.mClickThroughUrl;
    }

    public List<String> getClickTrackers() {
        return this.mClickTrackers;
    }

    public List<String> getImpressionTrackers() {
        return this.mImpressionTrackers;
    }

    public String getMediaFileUrl() {
        return this.mMediaFileUrl;
    }

    public List<String> getVideoCompleteTrackers() {
        return this.mVideoCompleteTrackers;
    }

    public List<String> getVideoFirstQuartileTrackers() {
        return this.mVideoFirstQuartileTrackers;
    }

    public List<String> getVideoMidpointTrackers() {
        return this.mVideoMidpointTrackers;
    }

    public List<String> getVideoStartTrackers() {
        return this.mVideoStartTrackers;
    }

    public List<String> getVideoThirdQuartileTrackers() {
        return this.mVideoThirdQuartileTrackers;
    }

    public void processVast(String string2, VastManagerListener vastManagerListener) {
        if (this.mVastBackgroundTask == null) {
            this.mListener = vastManagerListener;
            this.mVastBackgroundTask = new ProcessVastBackgroundTask();
            this.mVastBackgroundTask.execute(new String[]{string2});
        }
    }

    @Deprecated
    void setTimesFollowedVastRedirect(int n2) {
        this.mTimesFollowedVastRedirect = n2;
    }

    private class ProcessVastBackgroundTask
    extends AsyncTask<String, Void, Void> {
        private ProcessVastBackgroundTask() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Void doInBackground(String ... stringArray) {
            if (stringArray == null) return null;
            try {
                if (stringArray.length <= 0) return null;
                String string2 = stringArray[0];
                while (string2 != null) {
                    String string3;
                    if (string2.length() <= 0) return null;
                    if (this.isCancelled()) return null;
                    string2 = string3 = VastManager.this.processVastFollowingRedirect(string2);
                }
                return null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
                return null;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
                return null;
            }
        }

        protected void onCancelled() {
            VastManager.this.vastProcessComplete(true);
        }

        protected void onPostExecute(Void void_) {
            VastManager.this.vastProcessComplete(false);
        }
    }

    public static interface VastManagerListener {
        public void onComplete(VastManager var1);
    }
}

