/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class Reflection {
    public static Method getDeclaredMethodWithTraversal(Class<?> clazz, String string2, Class<?> ... classArray) throws NoSuchMethodException {
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            try {
                Method method = clazz2.getDeclaredMethod(string2, classArray);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        throw new NoSuchMethodException();
    }

    public static class MethodBuilder {
        private Class<?> mClass;
        private final Object mInstance;
        private boolean mIsAccessible;
        private boolean mIsStatic;
        private final String mMethodName;
        private List<Class<?>> mParameterClasses;
        private List<Object> mParameters;

        /*
         * Enabled aggressive block sorting
         */
        public MethodBuilder(Object object, String string2) {
            this.mInstance = object;
            this.mMethodName = string2;
            this.mParameterClasses = new ArrayList();
            this.mParameters = new ArrayList<Object>();
            Class<?> clazz = object != null ? object.getClass() : null;
            this.mClass = clazz;
        }

        public <T> MethodBuilder addParam(Class<T> clazz, T t2) {
            this.mParameterClasses.add(clazz);
            this.mParameters.add(t2);
            return this;
        }

        public Object execute() throws Exception {
            Class[] classArray = new Class[this.mParameterClasses.size()];
            Class[] classArray2 = this.mParameterClasses.toArray(classArray);
            Method method = Reflection.getDeclaredMethodWithTraversal(this.mClass, this.mMethodName, classArray2);
            if (this.mIsAccessible) {
                method.setAccessible(true);
            }
            Object[] objectArray = this.mParameters.toArray();
            if (this.mIsStatic) {
                return method.invoke(null, objectArray);
            }
            return method.invoke(this.mInstance, objectArray);
        }

        public MethodBuilder setAccessible() {
            this.mIsAccessible = true;
            return this;
        }

        public MethodBuilder setStatic(Class<?> clazz) {
            this.mIsStatic = true;
            this.mClass = clazz;
            return this;
        }
    }
}

