/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.mopub.mobileads.AdAlertGestureListener;
import com.mopub.mobileads.AdConfiguration;

public class ViewGestureDetector
extends GestureDetector {
    private AdAlertGestureListener mAdAlertGestureListener;
    private UserClickListener mUserClickListener;
    private final View mView;

    private ViewGestureDetector(Context context, View view, AdAlertGestureListener adAlertGestureListener) {
        super(context, (GestureDetector.OnGestureListener)adAlertGestureListener);
        this.mAdAlertGestureListener = adAlertGestureListener;
        this.mView = view;
        this.setIsLongpressEnabled(false);
    }

    public ViewGestureDetector(Context context, View view, AdConfiguration adConfiguration) {
        this(context, view, new AdAlertGestureListener(view, adConfiguration));
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isMotionEventInView(MotionEvent motionEvent, View view) {
        block3: {
            block2: {
                if (motionEvent == null || view == null) break block2;
                float f2 = motionEvent.getX();
                float f3 = motionEvent.getY();
                if (f2 >= 0.0f && f2 <= (float)view.getWidth() && f3 >= 0.0f && f3 <= (float)view.getHeight()) break block3;
            }
            return false;
        }
        return true;
    }

    void resetAdFlaggingGesture() {
        this.mAdAlertGestureListener.reset();
    }

    /*
     * Enabled aggressive block sorting
     */
    void sendTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            default: {
                return;
            }
            case 1: {
                if (this.mUserClickListener != null) {
                    this.mUserClickListener.onUserClick();
                } else {
                    Log.d((String)"MoPub", (String)"View's onUserClick() is not registered.");
                }
                this.mAdAlertGestureListener.finishGestureDetection();
                return;
            }
            case 0: {
                this.onTouchEvent(motionEvent);
                return;
            }
            case 2: 
        }
        if (this.isMotionEventInView(motionEvent, this.mView)) {
            this.onTouchEvent(motionEvent);
            return;
        }
        this.resetAdFlaggingGesture();
    }

    @Deprecated
    void setAdAlertGestureListener(AdAlertGestureListener adAlertGestureListener) {
        this.mAdAlertGestureListener = adAlertGestureListener;
    }

    void setUserClickListener(UserClickListener userClickListener) {
        this.mUserClickListener = userClickListener;
    }

    static interface UserClickListener {
        public void onResetUserClick();

        public void onUserClick();

        public boolean wasClicked();
    }
}

