/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.content.Intent;
import android.media.MediaPlayer;
import android.os.Handler;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.mopub.mobileads.BaseVideoView;
import com.mopub.mobileads.MraidBrowser;
import com.mopub.mobileads.util.HttpUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class VastVideoView
extends BaseVideoView {
    public static final int DEFAULT_VIDEO_DURATION_FOR_CLOSE_BUTTON = 5000;
    private static final float FIRST_QUARTER_MARKER = 0.25f;
    public static final int MAX_VIDEO_DURATION_FOR_CLOSE_BUTTON = 16000;
    private static final float MID_POINT_MARKER = 0.5f;
    private static final float THIRD_QUARTER_MARKER = 0.75f;
    static final String VIDEO_CLICK_THROUGH_TRACKERS = "video_click_through_trackers";
    static final String VIDEO_CLICK_THROUGH_URL = "video_click_through_url";
    static final String VIDEO_COMPLETE_TRACKERS = "video_complete_trackers";
    static final String VIDEO_FIRST_QUARTER_TRACKERS = "video_first_quarter_trackers";
    static final String VIDEO_IMPRESSION_TRACKERS = "video_impression_trackers";
    static final String VIDEO_MID_POINT_TRACKERS = "video_mid_point_trackers";
    private static final long VIDEO_PROGRESS_TIMER_CHECKER_DELAY = 50L;
    static final String VIDEO_START_TRACKERS = "video_start_trackers";
    static final String VIDEO_THIRD_QUARTER_TRACKERS = "video_third_quarter_trackers";
    private static final ThreadPoolExecutor sThreadPoolExecutor = new ThreadPoolExecutor(10, 50, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final BaseVideoView.BaseVideoViewListener mBaseVideoViewListener;
    private ArrayList<String> mClickThroughTrackers;
    private String mClickThroughUrl;
    private ArrayList<String> mCompletionTrackers;
    private ArrayList<String> mFirstQuarterTrackers;
    private Handler mHandler;
    private ArrayList<String> mImpressionTrackers;
    private boolean mIsFirstMarkHit;
    private boolean mIsSecondMarkHit;
    private boolean mIsThirdMarkHit;
    private boolean mIsVideoFinishedPlaying;
    private boolean mIsVideoProgressShouldBeChecked;
    private ArrayList<String> mMidPointTrackers;
    private int mSeekerPositionOnPause;
    private int mShowCloseButtonDelay = 5000;
    private boolean mShowCloseButtonEventFired;
    private ArrayList<String> mThirdQuarterTrackers;
    private Runnable mVideoProgressCheckerRunnable;
    private ArrayList<String> mVideoStartTrackers;
    private String mVideoUrl;

    public VastVideoView(final Context context, Intent intent, final BaseVideoView.BaseVideoViewListener baseVideoViewListener) {
        super(context);
        this.mBaseVideoViewListener = baseVideoViewListener;
        this.mHandler = new Handler();
        this.mIsVideoProgressShouldBeChecked = true;
        this.mSeekerPositionOnPause = -1;
        this.mVideoUrl = intent.getStringExtra("video_url");
        this.mVideoStartTrackers = intent.getStringArrayListExtra(VIDEO_START_TRACKERS);
        this.mFirstQuarterTrackers = intent.getStringArrayListExtra(VIDEO_FIRST_QUARTER_TRACKERS);
        this.mMidPointTrackers = intent.getStringArrayListExtra(VIDEO_MID_POINT_TRACKERS);
        this.mThirdQuarterTrackers = intent.getStringArrayListExtra(VIDEO_THIRD_QUARTER_TRACKERS);
        this.mCompletionTrackers = intent.getStringArrayListExtra(VIDEO_COMPLETE_TRACKERS);
        this.mImpressionTrackers = intent.getStringArrayListExtra(VIDEO_IMPRESSION_TRACKERS);
        this.mClickThroughUrl = intent.getStringExtra(VIDEO_CLICK_THROUGH_URL);
        this.mClickThroughTrackers = intent.getStringArrayListExtra(VIDEO_CLICK_THROUGH_TRACKERS);
        this.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mediaPlayer) {
                if (VastVideoView.this.getDuration() < 16000) {
                    VastVideoView.access$002(VastVideoView.this, VastVideoView.this.getDuration());
                }
            }
        });
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (motionEvent.getAction() == 1 && VastVideoView.this.shouldAllowClickThrough()) {
                    VastVideoView.this.pingOnBackgroundThread(VastVideoView.this.mClickThroughTrackers);
                    if (VastVideoView.this.mBaseVideoViewListener != null) {
                        VastVideoView.this.mBaseVideoViewListener.videoClicked();
                    }
                    Intent intent = new Intent(context, MraidBrowser.class);
                    intent.putExtra("extra_url", VastVideoView.this.mClickThroughUrl);
                    context.startActivity(intent);
                }
                return true;
            }
        });
        this.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                VastVideoView.this.stopProgressChecker();
                VastVideoView.this.fireShowCloseButtonEvent();
                if (VastVideoView.this.mBaseVideoViewListener != null) {
                    VastVideoView.this.mBaseVideoViewListener.videoCompleted(false);
                }
                VastVideoView.this.pingOnBackgroundThread(VastVideoView.this.mCompletionTrackers);
                VastVideoView.access$902(VastVideoView.this, true);
            }
        });
        this.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
                VastVideoView.this.stopProgressChecker();
                if (baseVideoViewListener != null) {
                    baseVideoViewListener.videoError(false);
                }
                return false;
            }
        });
        this.mVideoProgressCheckerRunnable = new Runnable(){

            @Override
            public void run() {
                float f2 = VastVideoView.this.getDuration();
                if (f2 > 0.0f) {
                    float f3 = (float)VastVideoView.this.getCurrentPosition() / f2;
                    if (f3 > 0.25f && !VastVideoView.this.mIsFirstMarkHit) {
                        VastVideoView.access$1002(VastVideoView.this, true);
                        VastVideoView.this.pingOnBackgroundThread(VastVideoView.this.mFirstQuarterTrackers);
                    }
                    if (f3 > 0.5f && !VastVideoView.this.mIsSecondMarkHit) {
                        VastVideoView.access$1202(VastVideoView.this, true);
                        VastVideoView.this.pingOnBackgroundThread(VastVideoView.this.mMidPointTrackers);
                    }
                    if (f3 > 0.75f && !VastVideoView.this.mIsThirdMarkHit) {
                        VastVideoView.access$1402(VastVideoView.this, true);
                        VastVideoView.this.pingOnBackgroundThread(VastVideoView.this.mThirdQuarterTrackers);
                    }
                    if (VastVideoView.this.shouldShowCloseButton()) {
                        VastVideoView.this.fireShowCloseButtonEvent();
                    }
                }
                if (VastVideoView.this.mIsVideoProgressShouldBeChecked) {
                    VastVideoView.this.mHandler.postDelayed(VastVideoView.this.mVideoProgressCheckerRunnable, 50L);
                }
            }
        };
        this.setVideoPath(this.mVideoUrl);
        this.requestFocus();
        this.pingOnBackgroundThread(this.mVideoStartTrackers);
        this.pingOnBackgroundThread(this.mImpressionTrackers);
        this.mHandler.post(this.mVideoProgressCheckerRunnable);
    }

    static /* synthetic */ int access$002(VastVideoView vastVideoView, int n2) {
        vastVideoView.mShowCloseButtonDelay = n2;
        return n2;
    }

    static /* synthetic */ boolean access$1002(VastVideoView vastVideoView, boolean bl2) {
        vastVideoView.mIsFirstMarkHit = bl2;
        return bl2;
    }

    static /* synthetic */ boolean access$1202(VastVideoView vastVideoView, boolean bl2) {
        vastVideoView.mIsSecondMarkHit = bl2;
        return bl2;
    }

    static /* synthetic */ boolean access$1402(VastVideoView vastVideoView, boolean bl2) {
        vastVideoView.mIsThirdMarkHit = bl2;
        return bl2;
    }

    static /* synthetic */ boolean access$902(VastVideoView vastVideoView, boolean bl2) {
        vastVideoView.mIsVideoFinishedPlaying = bl2;
        return bl2;
    }

    private void fireShowCloseButtonEvent() {
        this.mShowCloseButtonEventFired = true;
        if (this.mBaseVideoViewListener != null) {
            this.mBaseVideoViewListener.showCloseButton();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void pingOnBackgroundThread(List<String> list) {
        if (list != null) {
            for (final String string2 : list) {
                sThreadPoolExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HttpUtils.ping(string2);
                            return;
                        }
                        catch (Exception exception) {
                            Log.d((String)"MoPub", (String)("Unable to track video impression url: " + string2));
                            return;
                        }
                    }
                });
            }
        }
    }

    private boolean shouldAllowClickThrough() {
        return this.mShowCloseButtonEventFired;
    }

    private boolean shouldShowCloseButton() {
        return !this.mShowCloseButtonEventFired && this.getCurrentPosition() > this.mShowCloseButtonDelay;
    }

    private void stopProgressChecker() {
        this.mIsVideoProgressShouldBeChecked = false;
        this.mHandler.removeCallbacks(this.mVideoProgressCheckerRunnable);
    }

    @Deprecated
    int getShowCloseButtonDelay() {
        return this.mShowCloseButtonDelay;
    }

    @Override
    protected void onPause() {
        super.onPause();
        this.stopProgressChecker();
        this.mSeekerPositionOnPause = this.getCurrentPosition();
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.mIsVideoProgressShouldBeChecked = true;
        this.mHandler.post(this.mVideoProgressCheckerRunnable);
        this.seekTo(this.mSeekerPositionOnPause);
        if (!this.mIsVideoFinishedPlaying) {
            this.start();
        }
    }

    @Deprecated
    void setCloseButtonVisible(boolean bl2) {
        this.mShowCloseButtonEventFired = bl2;
    }

    @Deprecated
    void setIsVideoProgressShouldBeChecked(boolean bl2) {
        this.mIsVideoProgressShouldBeChecked = bl2;
    }
}

