/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.net.Uri;
import android.util.Log;
import com.mopub.mobileads.CustomEventInterstitial;
import com.mopub.mobileads.DiskLruCache;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MraidVideoPlayerActivity;
import com.mopub.mobileads.ResponseBodyInterstitial;
import com.mopub.mobileads.VastVideoDownloadTask;
import com.mopub.mobileads.factories.VastManagerFactory;
import com.mopub.mobileads.factories.VastVideoDownloadTaskFactory;
import com.mopub.mobileads.util.vast.VastManager;
import java.util.ArrayList;
import java.util.Map;

class VastVideoInterstitial
extends ResponseBodyInterstitial
implements VastManager.VastManagerListener,
VastVideoDownloadTask.OnDownloadCompleteListener {
    public static final int CACHE_MAX_SIZE = 100000000;
    public static final String VIDEO_CACHE_DIRECTORY_NAME = "mopub_vast_video_cache";
    private String mClickThroughUrl;
    private ArrayList<String> mClickTrackers;
    private CustomEventInterstitial.CustomEventInterstitialListener mCustomEventInterstitialListener;
    private ArrayList<String> mImpressionTrackers;
    private VastManager mVastManager;
    private String mVastResponse;
    private VastVideoDownloadTask mVastVideoDownloadTask;
    private DiskLruCache mVideoCache;
    private ArrayList<String> mVideoCompleteTrackers;
    private ArrayList<String> mVideoFirstQuartileTrackers;
    private ArrayList<String> mVideoMidpointTrackers;
    private ArrayList<String> mVideoStartTrackers;
    private ArrayList<String> mVideoThirdQuartileTrackers;
    private String mVideoUrl;

    VastVideoInterstitial() {
    }

    @Override
    protected void extractExtras(Map<String, String> map) {
        this.mVastResponse = Uri.decode((String)map.get("Html-Response-Body"));
    }

    @Deprecated
    String getVastResponse() {
        return this.mVastResponse;
    }

    @Deprecated
    DiskLruCache getVideoCache() {
        return this.mVideoCache;
    }

    @Override
    public void onComplete(VastManager vastManager) {
        this.mVideoUrl = vastManager.getMediaFileUrl();
        if (this.mVideoCache.getUri(this.mVideoUrl) != null) {
            this.onDownloadSuccess();
            return;
        }
        VastVideoDownloadTask vastVideoDownloadTask = this.mVastVideoDownloadTask = VastVideoDownloadTaskFactory.create(this, this.mVideoCache);
        Object[] objectArray = new String[]{this.mVideoUrl};
        vastVideoDownloadTask.execute(objectArray);
    }

    @Override
    public void onDownloadFailed() {
        this.mCustomEventInterstitialListener.onInterstitialFailed(MoPubErrorCode.VIDEO_DOWNLOAD_ERROR);
    }

    @Override
    public void onDownloadSuccess() {
        this.mVideoStartTrackers = new ArrayList<String>(this.mVastManager.getVideoStartTrackers());
        this.mVideoFirstQuartileTrackers = new ArrayList<String>(this.mVastManager.getVideoFirstQuartileTrackers());
        this.mVideoMidpointTrackers = new ArrayList<String>(this.mVastManager.getVideoMidpointTrackers());
        this.mVideoThirdQuartileTrackers = new ArrayList<String>(this.mVastManager.getVideoThirdQuartileTrackers());
        this.mVideoCompleteTrackers = new ArrayList<String>(this.mVastManager.getVideoCompleteTrackers());
        this.mImpressionTrackers = new ArrayList<String>(this.mVastManager.getImpressionTrackers());
        this.mClickThroughUrl = this.mVastManager.getClickThroughUrl();
        this.mClickTrackers = new ArrayList<String>(this.mVastManager.getClickTrackers());
        this.mCustomEventInterstitialListener.onInterstitialLoaded();
    }

    @Override
    protected void onInvalidate() {
        if (this.mVastManager != null) {
            this.mVastManager.cancel();
        }
        super.onInvalidate();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void preRenderHtml(CustomEventInterstitial.CustomEventInterstitialListener customEventInterstitialListener) {
        this.mCustomEventInterstitialListener = customEventInterstitialListener;
        if (this.mVideoCache == null) {
            try {
                this.mVideoCache = new DiskLruCache(this.mContext, VIDEO_CACHE_DIRECTORY_NAME, 100000000);
            }
            catch (Exception exception) {
                Log.d((String)"MoPub", (String)"Unable to create VAST video cache.");
                this.mCustomEventInterstitialListener.onInterstitialFailed(MoPubErrorCode.VIDEO_CACHE_ERROR);
                return;
            }
        }
        this.mVastManager = VastManagerFactory.create();
        this.mVastManager.processVast(this.mVastResponse, this);
    }

    @Deprecated
    void setVastManager(VastManager vastManager) {
        this.mVastManager = vastManager;
    }

    @Override
    protected void showInterstitial() {
        MraidVideoPlayerActivity.startVast(this.mContext, this.mVideoUrl, this.mVideoStartTrackers, this.mVideoFirstQuartileTrackers, this.mVideoMidpointTrackers, this.mVideoThirdQuartileTrackers, this.mVideoCompleteTrackers, this.mImpressionTrackers, this.mClickThroughUrl, this.mClickTrackers);
    }
}

